/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.audio.packet;

import com.pedro.common.ExtensionsKt;
import com.pedro.common.frame.MediaFrame;
import com.pedro.rtmp.flv.BasePacket;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.audio.AudioFormat;
import com.pedro.rtmp.flv.audio.AudioFourCCPacketType;
import com.pedro.rtmp.flv.audio.config.OpusAudioSpecificConfig;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J:\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\"\u0010\u0010\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/pedro/rtmp/flv/audio/packet/OpusPacket;", "Lcom/pedro/rtmp/flv/BasePacket;", "<init>", "()V", "header", "", "configSend", "", "sampleRate", "", "isStereo", "sendAudioInfo", "", "createFlvPacket", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "Lcom/pedro/rtmp/flv/FlvPacket;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reset", "resetInfo", "rtmp_release"})
public final class OpusPacket
extends BasePacket {
    @NotNull
    private final byte[] header = new byte[5];
    private boolean configSend;
    private int sampleRate = 48000;
    private boolean isStereo = true;

    public final void sendAudioInfo(int sampleRate, boolean isStereo) {
        this.sampleRate = sampleRate;
        this.isStereo = isStereo;
    }

    @Override
    @Nullable
    public Object createFlvPacket(@NotNull MediaFrame mediaFrame, @NotNull Function2<? super FlvPacket, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)mediaFrame.getData(), (MediaFrame.Info)mediaFrame.getInfo());
        long ts = mediaFrame.getInfo().getTimestamp() / (long)1000;
        int codec = AudioFormat.OPUS.getValue();
        this.header[1] = (byte)(codec >> 24);
        this.header[2] = (byte)(codec >> 16);
        this.header[3] = (byte)(codec >> 8);
        this.header[4] = (byte)codec;
        byte[] buffer = null;
        if (!this.configSend) {
            this.header[0] = (byte)(AudioFormat.EX_HEADER.getValue() << 4 | AudioFourCCPacketType.SEQUENCE_START.getValue() & 0xF);
            OpusAudioSpecificConfig config = new OpusAudioSpecificConfig(this.sampleRate, this.isStereo ? 2 : 1);
            buffer = new byte[config.getSize() + this.header.length];
            config.write(buffer, this.header.length);
            this.configSend = true;
        } else {
            this.header[0] = (byte)(AudioFormat.EX_HEADER.getValue() << 4 | AudioFourCCPacketType.CODED_FRAMES.getValue() & 0xF);
            buffer = new byte[fixedBuffer.remaining() + this.header.length];
            fixedBuffer.get(buffer, this.header.length, fixedBuffer.remaining());
        }
        System.arraycopy(this.header, 0, buffer, 0, this.header.length);
        Object object = callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.AUDIO), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void reset(boolean resetInfo) {
        this.configSend = false;
    }
}

