/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.amf.v0;

import com.pedro.rtmp.amf.v0.AmfBoolean;
import com.pedro.rtmp.amf.v0.AmfData;
import com.pedro.rtmp.amf.v0.AmfNull;
import com.pedro.rtmp.amf.v0.AmfNumber;
import com.pedro.rtmp.amf.v0.AmfObjectEnd;
import com.pedro.rtmp.amf.v0.AmfString;
import com.pedro.rtmp.amf.v0.AmfType;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B-\u0012$\b\u0002\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0001H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`\u0005J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\tH\u0016J\b\u0010!\u001a\u00020\u0010H\u0016R*\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lcom/pedro/rtmp/amf/v0/AmfObject;", "Lcom/pedro/rtmp/amf/v0/AmfData;", "properties", "Ljava/util/LinkedHashMap;", "Lcom/pedro/rtmp/amf/v0/AmfString;", "Lkotlin/collections/LinkedHashMap;", "<init>", "(Ljava/util/LinkedHashMap;)V", "bodySize", "", "getBodySize", "()I", "setBodySize", "(I)V", "getProperty", "name", "", "setProperty", "", "data", "", "", "", "getProperties", "readBody", "input", "Ljava/io/InputStream;", "writeBody", "output", "Ljava/io/OutputStream;", "getType", "Lcom/pedro/rtmp/amf/v0/AmfType;", "getSize", "toString", "rtmp_release"})
@SourceDebugExtension(value={"SMAP\nAmfObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmfObject.kt\ncom/pedro/rtmp/amf/v0/AmfObject\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n216#2,2:165\n216#2,2:167\n216#2,2:170\n1#3:169\n*S KotlinDebug\n*F\n+ 1 AmfObject.kt\ncom/pedro/rtmp/amf/v0/AmfObject\n*L\n34#1:165,2\n44#1:167,2\n147#1:170,2\n*E\n"})
public class AmfObject
extends AmfData {
    @NotNull
    private final LinkedHashMap<AmfString, AmfData> properties;
    private int bodySize;

    public AmfObject(@NotNull LinkedHashMap<AmfString, AmfData> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.properties = properties;
        Map $this$forEach$iv = this.properties;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            this.bodySize += ((AmfString)it.getKey()).getSize();
            this.bodySize += ((AmfData)it.getValue()).getSize() + 1;
        }
        AmfObjectEnd objectEnd = new AmfObjectEnd(false, 1, null);
        this.bodySize += objectEnd.getSize();
    }

    public /* synthetic */ AmfObject(LinkedHashMap linkedHashMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            linkedHashMap = new LinkedHashMap();
        }
        this(linkedHashMap);
    }

    protected final int getBodySize() {
        return this.bodySize;
    }

    protected final void setBodySize(int n) {
        this.bodySize = n;
    }

    @Nullable
    public final AmfData getProperty(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map $this$forEach$iv = this.properties;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((AmfString)it.getKey()).getValue(), (Object)name)) continue;
            return (AmfData)it.getValue();
        }
        return null;
    }

    public void setProperty(@NotNull String name, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        AmfString key = new AmfString(name);
        AmfString value = new AmfString(data);
        ((Map)this.properties).put(key, value);
        this.bodySize += key.getSize();
        this.bodySize += value.getSize() + 1;
    }

    public void setProperty(@NotNull String name, boolean data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AmfString key = new AmfString(name);
        AmfBoolean value = new AmfBoolean(data);
        ((Map)this.properties).put(key, value);
        this.bodySize += key.getSize();
        this.bodySize += value.getSize() + 1;
    }

    public void setProperty(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AmfString key = new AmfString(name);
        AmfNull value = new AmfNull();
        ((Map)this.properties).put(key, value);
        this.bodySize += key.getSize();
        this.bodySize += value.getSize() + 1;
    }

    public void setProperty(@NotNull String name, double data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AmfString key = new AmfString(name);
        AmfNumber value = new AmfNumber(data);
        ((Map)this.properties).put(key, value);
        this.bodySize += key.getSize();
        this.bodySize += value.getSize() + 1;
    }

    public void setProperty(@NotNull String name, @NotNull AmfData data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        AmfString key = new AmfString(name);
        ((Map)this.properties).put(key, data);
        this.bodySize += key.getSize();
        this.bodySize += data.getSize() + 1;
    }

    public void setProperty(@NotNull String name, @NotNull Object data) {
        Object v2;
        AmfData newValue;
        block17: {
            AmfData amfData;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Object object = data;
            if (object instanceof String) {
                amfData = new AmfString((String)data);
            } else if (object instanceof Integer) {
                amfData = new AmfNumber(((Number)data).intValue());
            } else if (object instanceof Long) {
                amfData = new AmfNumber(((Number)data).longValue());
            } else if (object instanceof Double) {
                amfData = new AmfNumber(((Number)data).doubleValue());
            } else if (object instanceof Float) {
                amfData = new AmfNumber(((Number)data).floatValue());
            } else if (object instanceof Boolean) {
                amfData = new AmfBoolean((Boolean)data);
            } else if (object instanceof AmfData) {
                amfData = (AmfData)data;
            } else {
                throw new IllegalArgumentException("Unsupported value type: " + data.getClass().getName());
            }
            newValue = amfData;
            Set<Map.Entry<AmfString, AmfData>> set = this.properties.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((AmfString)it.getKey()).getValue(), (Object)name)) continue;
                v2 = t;
                break block17;
            }
            v2 = null;
        }
        Map.Entry existingEntry = v2;
        if (existingEntry != null) {
            ((Map)this.properties).put(existingEntry.getKey(), newValue);
            this.bodySize += newValue.getSize() - ((AmfData)existingEntry.getValue()).getSize();
        } else {
            AmfString key = new AmfString(name);
            ((Map)this.properties).put(key, newValue);
            this.bodySize += key.getSize() + newValue.getSize() + 1;
        }
    }

    @NotNull
    public final LinkedHashMap<AmfString, AmfData> getProperties() {
        return this.properties;
    }

    @Override
    public void readBody(@NotNull InputStream input) throws IOException {
        InputStream markInputStream;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.properties.clear();
        this.bodySize = 0;
        AmfObjectEnd objectEnd = new AmfObjectEnd(false, 1, null);
        InputStream inputStream = markInputStream = input.markSupported() ? input : (InputStream)new BufferedInputStream(input);
        while (!objectEnd.getFound()) {
            markInputStream.mark(objectEnd.getSize());
            objectEnd.readBody(input);
            if (objectEnd.getFound()) {
                this.bodySize += objectEnd.getSize();
                continue;
            }
            markInputStream.reset();
            AmfString key = new AmfString(null, 1, null);
            key.readBody(input);
            this.bodySize += key.getSize();
            AmfData value = AmfData.Companion.getAmfData(input);
            this.bodySize += value.getSize() + 1;
            ((Map)this.properties).put(key, value);
        }
    }

    @Override
    public void writeBody(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Map $this$forEach$iv = this.properties;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            ((AmfString)it.getKey()).writeBody(output);
            ((AmfData)it.getValue()).writeHeader(output);
            ((AmfData)it.getValue()).writeBody(output);
        }
        AmfObjectEnd objectEnd = new AmfObjectEnd(false, 1, null);
        objectEnd.writeBody(output);
    }

    @Override
    @NotNull
    public AmfType getType() {
        return AmfType.OBJECT;
    }

    @Override
    public int getSize() {
        return this.bodySize;
    }

    @NotNull
    public String toString() {
        return "AmfObject properties: " + this.properties;
    }

    public AmfObject() {
        this(null, 1, null);
    }
}

