/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.audio.config;

import com.pedro.common.AudioUtils;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/pedro/rtmp/flv/audio/config/AudioSpecificConfig;", "", "type", "", "sampleRate", "channels", "<init>", "(III)V", "size", "getSize", "()I", "write", "", "buffer", "", "offset", "writeConfig", "rtmp_release"})
public final class AudioSpecificConfig {
    private final int type;
    private final int sampleRate;
    private final int channels;
    private final int size;

    public AudioSpecificConfig(int type, int sampleRate, int channels) {
        this.type = type;
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.size = 9;
    }

    public final int getSize() {
        return this.size;
    }

    public final void write(@NotNull byte[] buffer, int offset) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.writeConfig(buffer, offset);
        ByteBuffer adts = AudioUtils.INSTANCE.createAdtsHeader(this.type, buffer.length, this.sampleRate, this.channels);
        adts.get(buffer, offset + 2, adts.capacity());
    }

    private final void writeConfig(byte[] buffer, int offset) {
        int frequency = AudioUtils.INSTANCE.getFrequency(this.sampleRate);
        buffer[offset] = (byte)(this.type << 3 | frequency >> 1);
        buffer[offset + 1] = (byte)((frequency << 7 & 0x80) + (this.channels << 3 & 0x78));
    }
}

