/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp.message;

import com.pedro.common.ExtensionsKt;
import com.pedro.rtmp.rtmp.chunk.ChunkStreamId;
import com.pedro.rtmp.rtmp.chunk.ChunkType;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.MessageType;
import com.pedro.rtmp.rtmp.message.RtmpMessage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lcom/pedro/rtmp/rtmp/message/SetChunkSize;", "Lcom/pedro/rtmp/rtmp/message/RtmpMessage;", "chunkSize", "", "<init>", "(I)V", "getChunkSize", "()I", "setChunkSize", "readBody", "", "input", "Ljava/io/InputStream;", "storeBody", "", "getType", "Lcom/pedro/rtmp/rtmp/message/MessageType;", "getSize", "toString", "", "rtmp_release"})
public final class SetChunkSize
extends RtmpMessage {
    private int chunkSize;

    public SetChunkSize(int chunkSize) {
        super(new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.PROTOCOL_CONTROL.getMark()));
        this.chunkSize = chunkSize;
    }

    public /* synthetic */ SetChunkSize(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 128;
        }
        this(n);
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    public final void setChunkSize(int n) {
        this.chunkSize = n;
    }

    @Override
    public void readBody(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.chunkSize = ExtensionsKt.readUInt32((InputStream)input);
    }

    @Override
    @NotNull
    public byte[] storeBody() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ExtensionsKt.writeUInt32((OutputStream)byteArrayOutputStream, (int)this.chunkSize);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.SET_CHUNK_SIZE;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @NotNull
    public String toString() {
        return "SetChunkSize(chunkSize=" + this.chunkSize + ")";
    }

    public SetChunkSize() {
        this(0, 1, null);
    }
}

