/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.video.packet;

import android.util.Log;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.frame.MediaFrame;
import com.pedro.rtmp.flv.BasePacket;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.video.VideoDataType;
import com.pedro.rtmp.flv.video.VideoFormat;
import com.pedro.rtmp.flv.video.VideoNalType;
import com.pedro.rtmp.flv.video.config.VideoSpecificConfigAVC;
import com.pedro.rtmp.flv.video.packet.H264Packet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0010J:\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\"\u0010\u0014\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u001a\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\b\b\u0002\u0010\u001d\u001a\u00020\tH\u0002J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/pedro/rtmp/flv/video/packet/H264Packet;", "Lcom/pedro/rtmp/flv/BasePacket;", "<init>", "()V", "TAG", "", "header", "", "naluSize", "", "configSend", "", "sps", "pps", "sendVideoInfo", "", "Ljava/nio/ByteBuffer;", "createFlvPacket", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "Lcom/pedro/rtmp/flv/FlvPacket;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeNaluSize", "buffer", "offset", "size", "removeHeader", "byteBuffer", "getHeaderSize", "getStartCodeSize", "reset", "resetInfo", "Type", "rtmp_release"})
public final class H264Packet
extends BasePacket {
    @NotNull
    private final String TAG;
    @NotNull
    private final byte[] header = new byte[5];
    private final int naluSize;
    private boolean configSend;
    @Nullable
    private byte[] sps;
    @Nullable
    private byte[] pps;

    public H264Packet() {
        this.TAG = "H264Packet";
        this.naluSize = 4;
    }

    public final void sendVideoInfo(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        ByteBuffer mSps = H264Packet.removeHeader$default(this, sps, 0, 2, null);
        ByteBuffer mPps = H264Packet.removeHeader$default(this, pps, 0, 2, null);
        byte[] spsBytes = new byte[mSps.remaining()];
        byte[] ppsBytes = new byte[mPps.remaining()];
        mSps.get(spsBytes, 0, spsBytes.length);
        mPps.get(ppsBytes, 0, ppsBytes.length);
        this.sps = spsBytes;
        this.pps = ppsBytes;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object createFlvPacket(@NotNull MediaFrame var1_1, @NotNull Function2<? super FlvPacket, ? super Continuation<? super Unit>, ? extends Object> var2_2, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof createFlvPacket.1)) ** GOTO lbl-1000
        var15_4 = $completion;
        if ((var15_4.label & -2147483648) != 0) {
            var15_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ H264Packet this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createFlvPacket(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)mediaFrame.getData(), (MediaFrame.Info)mediaFrame.getInfo());
                ts = mediaFrame.getInfo().getTimestamp() / (long)1000;
                cts = 0;
                this.header[2] = (byte)(cts >> 16);
                this.header[3] = (byte)(cts >> 8);
                this.header[4] = (byte)cts;
                if (this.configSend) ** GOTO lbl49
                this.header[0] = (byte)(VideoDataType.KEYFRAME.getValue() << 4 | VideoFormat.AVC.getValue());
                this.header[1] = Type.SEQUENCE.getValue();
                sps = this.sps;
                pps = this.pps;
                if (sps == null || pps == null) {
                    Log.e((String)this.TAG, (String)"waiting for a valid sps and pps");
                    return Unit.INSTANCE;
                }
                config = new VideoSpecificConfigAVC(sps, pps);
                buffer = new byte[config.getSize() + this.header.length];
                config.write(buffer, this.header.length);
                System.arraycopy(this.header, 0, buffer, 0, this.header.length);
                $continuation.L$0 = mediaFrame;
                $continuation.L$1 = callback;
                $continuation.L$2 = fixedBuffer;
                $continuation.J$0 = ts;
                $continuation.label = 1;
                v0 = callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.VIDEO), (Object)$continuation);
                if (v0 == var16_6) {
                    return var16_6;
                }
                ** GOTO lbl48
            }
            case 1: {
                ts = $continuation.J$0;
                fixedBuffer = (ByteBuffer)$continuation.L$2;
                callback = (Function2)$continuation.L$1;
                mediaFrame = (MediaFrame)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl48:
                // 2 sources

                this.configSend = true;
lbl49:
                // 2 sources

                if ((headerSize = this.getHeaderSize(fixedBuffer)) == 0) {
                    return Unit.INSTANCE;
                }
                fixedBuffer.rewind();
                validBuffer = this.removeHeader(fixedBuffer, headerSize);
                size = validBuffer.remaining();
                buffer = new byte[this.header.length + size + this.naluSize];
                type = (byte)(validBuffer.get(0) & 31);
                nalType = VideoDataType.INTER_FRAME.getValue();
                if (type == VideoNalType.IDR.getValue() || mediaFrame.getInfo().isKeyFrame()) {
                    nalType = VideoDataType.KEYFRAME.getValue();
                } else if (type == VideoNalType.SPS.getValue() || type == VideoNalType.PPS.getValue()) {
                    return Unit.INSTANCE;
                }
                this.header[0] = (byte)(nalType << 4 | VideoFormat.AVC.getValue());
                this.header[1] = Type.NALU.getValue();
                this.writeNaluSize(buffer, this.header.length, size);
                validBuffer.get(buffer, this.header.length + this.naluSize, size);
                System.arraycopy(this.header, 0, buffer, 0, this.header.length);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.VIDEO), (Object)$continuation);
                if (v1 == var16_6) {
                    return var16_6;
                }
                ** GOTO lbl80
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl80:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void writeNaluSize(byte[] buffer, int offset, int size) {
        buffer[offset] = (byte)(size >>> 24);
        buffer[offset + 1] = (byte)(size >>> 16);
        buffer[offset + 2] = (byte)(size >>> 8);
        buffer[offset + 3] = (byte)size;
    }

    private final ByteBuffer removeHeader(ByteBuffer byteBuffer, int size) {
        int position = size == -1 ? this.getStartCodeSize(byteBuffer) : size;
        byteBuffer.position(position);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"slice(...)");
        return byteBuffer2;
    }

    static /* synthetic */ ByteBuffer removeHeader$default(H264Packet h264Packet, ByteBuffer byteBuffer, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return h264Packet.removeHeader(byteBuffer, n);
    }

    private final int getHeaderSize(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < 4) {
            return 0;
        }
        byte[] sps = this.sps;
        byte[] pps = this.pps;
        if (sps != null && pps != null) {
            int startCodeSize = this.getStartCodeSize(byteBuffer);
            if (startCodeSize == 0) {
                return 0;
            }
            int n = 0;
            byte[] byArray = new byte[startCodeSize];
            while (n < startCodeSize) {
                int n2 = n++;
                byArray[n2] = 0;
            }
            byte[] startCode = byArray;
            startCode[startCodeSize - 1] = 1;
            byte[] avcHeader = ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])startCode, (byte[])sps), (byte[])startCode), (byte[])pps), (byte[])startCode);
            if (byteBuffer.remaining() < avcHeader.length) {
                return startCodeSize;
            }
            byte[] possibleAvcHeader = new byte[avcHeader.length];
            byteBuffer.get(possibleAvcHeader, 0, possibleAvcHeader.length);
            return Arrays.equals(avcHeader, possibleAvcHeader) ? avcHeader.length : startCodeSize;
        }
        return 0;
    }

    private final int getStartCodeSize(ByteBuffer byteBuffer) {
        int startCodeSize = 0;
        if (byteBuffer.get(0) == 0 && byteBuffer.get(1) == 0 && byteBuffer.get(2) == 0 && byteBuffer.get(3) == 1) {
            startCodeSize = 4;
        } else if (byteBuffer.get(0) == 0 && byteBuffer.get(1) == 0 && byteBuffer.get(2) == 1) {
            startCodeSize = 3;
        }
        return startCodeSize;
    }

    @Override
    public void reset(boolean resetInfo) {
        if (resetInfo) {
            this.sps = null;
            this.pps = null;
        }
        this.configSend = false;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/pedro/rtmp/flv/video/packet/H264Packet$Type;", "", "value", "", "<init>", "(Ljava/lang/String;IB)V", "getValue", "()B", "SEQUENCE", "NALU", "EO_SEQ", "rtmp_release"})
    public static final class Type
    extends Enum<Type> {
        private final byte value;
        public static final /* enum */ Type SEQUENCE = new Type(0);
        public static final /* enum */ Type NALU = new Type(1);
        public static final /* enum */ Type EO_SEQ = new Type(2);
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(byte value) {
            this.value = value;
        }

        public final byte getValue() {
            return this.value;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.SEQUENCE, Type.NALU, Type.EO_SEQ};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

