/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.video.config;

import com.pedro.common.BitBuffer;
import com.pedro.common.av1.Av1Parser;
import com.pedro.common.av1.Obu;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\tJ$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/pedro/rtmp/flv/video/config/VideoSpecificConfigAV1;", "", "sequenceObu", "", "<init>", "([B)V", "av1Parser", "Lcom/pedro/common/av1/Av1Parser;", "size", "", "getSize", "()I", "write", "", "buffer", "offset", "readUVLC", "Lkotlin/Pair;", "byteArray", "rtmp_release"})
public final class VideoSpecificConfigAV1 {
    @NotNull
    private final byte[] sequenceObu;
    @NotNull
    private final Av1Parser av1Parser;
    private final int size;

    public VideoSpecificConfigAV1(@NotNull byte[] sequenceObu) {
        Intrinsics.checkNotNullParameter((Object)sequenceObu, (String)"sequenceObu");
        this.sequenceObu = sequenceObu;
        this.av1Parser = new Av1Parser();
        this.size = 4 + this.sequenceObu.length;
    }

    public final int getSize() {
        return this.size;
    }

    public final void write(@NotNull byte[] buffer, int offset) {
        int n;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        byte[] obuData = ((Obu)this.av1Parser.getObus(this.sequenceObu).get(0)).getData();
        BitBuffer bitBuffer = new BitBuffer(obuData);
        int index = 0;
        int seqProfile = bitBuffer.getBits(index, 3);
        index += 3;
        int reducedStillPictureHeader = bitBuffer.getBits(++index, 1);
        ++index;
        int seqLevelIdx = 0;
        int seqTier = 0;
        int initialDisplayDelayPresentFlag = 0;
        int initialPresentationDelay = 0;
        if (reducedStillPictureHeader == 1) {
            seqLevelIdx = bitBuffer.getBits(index, 5);
            index += 5;
        } else {
            int timingInfoPresentFlag = bitBuffer.getBits(index, 1);
            ++index;
            int decoderModelInfoPresentFlag = 0;
            int bufferDelayLengthMinus1 = 0;
            if (timingInfoPresentFlag == 1) {
                int equalPictureInterval = bitBuffer.getBits(index += 64, 1);
                ++index;
                if (equalPictureInterval == 1) {
                    Pair<Integer, Integer> uvlc = this.readUVLC(obuData, index);
                    index += ((Number)uvlc.getSecond()).intValue();
                }
                decoderModelInfoPresentFlag = bitBuffer.getBits(index, 1);
                ++index;
                if (decoderModelInfoPresentFlag == 1) {
                    bufferDelayLengthMinus1 = bitBuffer.getBits(index, 5);
                    index += 5;
                    index += 42;
                }
            }
            initialDisplayDelayPresentFlag = bitBuffer.getBits(index, 1);
            int operatingPointsCntMinus1 = bitBuffer.getBits(++index, 5);
            index += 5;
            int i = 0;
            if (i <= operatingPointsCntMinus1) {
                while (true) {
                    int levelIdx = bitBuffer.getBits(index += 12, 5);
                    index += 5;
                    if (i == 0) {
                        seqLevelIdx = levelIdx;
                    }
                    if (levelIdx > 7) {
                        int sTier = bitBuffer.getBits(index, 1);
                        ++index;
                        if (i == 0) {
                            seqTier = sTier;
                        }
                    }
                    if (decoderModelInfoPresentFlag == 1) {
                        int decoderModelPresentForThisOp = bitBuffer.getBits(index, 1);
                        ++index;
                        if (decoderModelPresentForThisOp == 1) {
                            int n2 = bufferDelayLengthMinus1 + 1;
                            index += n2 * 2 + 1;
                        }
                    }
                    if (initialDisplayDelayPresentFlag == 1) {
                        int initialDisplayDelayPresentForThisOp = bitBuffer.getBits(index, 1);
                        ++index;
                        if (initialDisplayDelayPresentForThisOp == 1) {
                            int initialDisplayDelayMinus1 = bitBuffer.getBits(index, 4);
                            index += 4;
                            if (i == 0) {
                                initialPresentationDelay = initialDisplayDelayMinus1;
                            }
                        }
                    }
                    if (i == operatingPointsCntMinus1) break;
                    ++i;
                }
            }
        }
        int frameWidthBitsMinus1 = bitBuffer.getBits(index, 4);
        int frameHeightBitsMinus1 = bitBuffer.getBits(index += 4, 4);
        index += 4;
        index += frameWidthBitsMinus1 + 1 + frameHeightBitsMinus1 + 1;
        int frameIdNumbersPresentFlag = 0;
        if (reducedStillPictureHeader != 1) {
            frameIdNumbersPresentFlag = bitBuffer.getBits(index, 1);
            ++index;
        }
        if (frameIdNumbersPresentFlag == 1) {
            index += 7;
        }
        index += 3;
        if (reducedStillPictureHeader != 1) {
            int enableOrderHint = bitBuffer.getBits(index += 4, 1);
            ++index;
            if (enableOrderHint == 1) {
                index += 2;
            }
            int seqChooseScreenContentTools = bitBuffer.getBits(index, 1);
            ++index;
            int seqForceScreenContentTools = 2;
            if (seqChooseScreenContentTools != 1) {
                seqForceScreenContentTools = bitBuffer.getBits(index, 1);
                ++index;
            }
            if (seqForceScreenContentTools > 0) {
                int seqChooseIntegerMv = bitBuffer.getBits(index, 1);
                ++index;
                if (seqChooseIntegerMv != 1) {
                    ++index;
                }
            }
            if (enableOrderHint == 1) {
                index += 3;
            }
        }
        int highBitDepth = bitBuffer.getBits(index += 3, 1);
        ++index;
        int twelveBit = 0;
        int bitDepth = 0;
        if (seqProfile == 2 && highBitDepth == 1) {
            twelveBit = bitBuffer.getBits(index, 1);
            ++index;
            bitDepth = twelveBit == 1 ? 12 : 10;
        } else if (seqProfile <= 2) {
            int n3 = bitDepth = highBitDepth == 1 ? 10 : 8;
        }
        if (seqProfile == 1) {
            n = 0;
        } else {
            int chrome = bitBuffer.getBits(index, 1);
            ++index;
            n = chrome;
        }
        int monochrome = n;
        int colorDescriptionPresentFlag = bitBuffer.getBits(index, 1);
        ++index;
        int colorPrimaries = 0;
        int transferCharacteristics = 0;
        int matrixCoefficients = 0;
        if (colorDescriptionPresentFlag == 1) {
            colorPrimaries = bitBuffer.getBits(index, 8);
            transferCharacteristics = bitBuffer.getBits(index += 8, 8);
            matrixCoefficients = bitBuffer.getBits(index += 8, 8);
            index += 8;
        }
        int subsamplingX = 0;
        int subsamplingY = 0;
        int samplePosition = 0;
        if (monochrome == 1) {
            ++index;
            subsamplingX = 1;
            subsamplingY = 1;
        } else if (colorPrimaries == 1 && transferCharacteristics == 1 && matrixCoefficients == 1) {
            subsamplingX = 0;
            subsamplingY = 0;
        } else {
            ++index;
            switch (seqProfile) {
                case 0: {
                    subsamplingX = 1;
                    subsamplingY = 1;
                    break;
                }
                case 1: {
                    subsamplingX = 0;
                    subsamplingY = 0;
                    break;
                }
                default: {
                    if (bitDepth == 12) {
                        subsamplingX = bitBuffer.getBits(index, 1);
                        ++index;
                        if (subsamplingX == 1) {
                            subsamplingY = bitBuffer.getBits(index, 1);
                            ++index;
                        } else {
                            subsamplingY = 0;
                        }
                    } else {
                        subsamplingX = 1;
                        subsamplingY = 0;
                    }
                    if (subsamplingX != 1 || subsamplingY != true) break;
                    samplePosition = bitBuffer.getBits(index, 1);
                    ++index;
                }
            }
        }
        ++index;
        ++index;
        ByteBuffer data = ByteBuffer.wrap(buffer, offset, this.size);
        data.put((byte)-127);
        data.put((byte)(seqProfile << 5 | seqLevelIdx));
        data.put((byte)(seqTier << 7 | highBitDepth << 6 | twelveBit << 5 | monochrome << 4 | subsamplingX << 3 | subsamplingY << 2 | samplePosition));
        int reserved = 0;
        data.put((byte)(reserved << 5 | initialDisplayDelayPresentFlag << 4 | initialPresentationDelay));
        data.put(this.sequenceObu);
    }

    private final Pair<Integer, Integer> readUVLC(byte[] byteArray, int offset) {
        int leadingZeros = 0;
        int value = 0;
        int currentIndex = offset / 8;
        int currentBit = 7 - offset % 8;
        while ((byteArray[currentIndex] & 1 << currentBit) == 0) {
            ++leadingZeros;
            if (currentBit == 0) {
                ++currentIndex;
                currentBit = 7;
                continue;
            }
            --currentBit;
        }
        int n = leadingZeros + 1;
        for (int i = 0; i < n; ++i) {
            if (currentBit == 0) {
                ++currentIndex;
                currentBit = 7;
            } else {
                --currentBit;
            }
            value = value << 1 | byteArray[currentIndex] >>> currentBit & 1;
        }
        return new Pair((Object)value, (Object)(offset + leadingZeros + 1));
    }
}

