/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.video.packet;

import android.util.Log;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.av1.Av1Parser;
import com.pedro.common.av1.ObuType;
import com.pedro.common.frame.MediaFrame;
import com.pedro.rtmp.flv.BasePacket;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.video.FourCCPacketType;
import com.pedro.rtmp.flv.video.VideoDataType;
import com.pedro.rtmp.flv.video.VideoFormat;
import com.pedro.rtmp.flv.video.config.VideoSpecificConfigAV1;
import com.pedro.rtmp.flv.video.packet.Av1Packet;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J=\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\"\u0010\u0010\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/pedro/rtmp/flv/video/packet/Av1Packet;", "Lcom/pedro/rtmp/flv/BasePacket;", "()V", "TAG", "", "configSend", "", "header", "", "obuSequence", "parser", "Lcom/pedro/common/av1/Av1Parser;", "createFlvPacket", "", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "Lcom/pedro/rtmp/flv/FlvPacket;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reset", "resetInfo", "sendVideoInfo", "Ljava/nio/ByteBuffer;", "rtmp_release"})
public final class Av1Packet
extends BasePacket {
    @NotNull
    private final String TAG;
    @NotNull
    private final Av1Parser parser = new Av1Parser();
    @NotNull
    private final byte[] header = new byte[5];
    private boolean configSend;
    @Nullable
    private byte[] obuSequence;

    public Av1Packet() {
        this.TAG = "AV1Packet";
    }

    public final void sendVideoInfo(@NotNull ByteBuffer obuSequence) {
        Intrinsics.checkNotNullParameter((Object)obuSequence, (String)"obuSequence");
        this.obuSequence = ExtensionsKt.toByteArray((ByteBuffer)obuSequence);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object createFlvPacket(@NotNull MediaFrame var1_1, @NotNull Function2<? super FlvPacket, ? super Continuation<? super Unit>, ? extends Object> var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof createFlvPacket.1)) ** GOTO lbl-1000
        var12_4 = var3_3;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ Av1Packet this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createFlvPacket(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = mediaFrame.getData().duplicate();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"mediaFrame.data.duplicate()");
                fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)v0, (MediaFrame.Info)mediaFrame.getInfo());
                ts = mediaFrame.getInfo().getTimestamp() / (long)1000;
                codec = VideoFormat.AV1.getValue();
                this.header[1] = (byte)(codec >> 24);
                this.header[2] = (byte)(codec >> 16);
                this.header[3] = (byte)(codec >> 8);
                this.header[4] = (byte)codec;
                if (this.configSend) ** GOTO lbl51
                this.header[0] = (byte)(128 | VideoDataType.KEYFRAME.getValue() << 4 | FourCCPacketType.SEQUENCE_START.getValue());
                obuSequence = this.obuSequence;
                if (obuSequence == null) {
                    Log.e((String)this.TAG, (String)"waiting for a valid av1ConfigurationRecord");
                    return Unit.INSTANCE;
                }
                config = new VideoSpecificConfigAV1((byte[])obuSequence);
                buffer = new byte[config.getSize() + this.header.length];
                config.write(buffer, this.header.length);
                System.arraycopy(this.header, 0, buffer, 0, this.header.length);
                $continuation.L$0 = this;
                $continuation.L$1 = mediaFrame;
                $continuation.L$2 = callback;
                $continuation.L$3 = fixedBuffer;
                $continuation.J$0 = ts;
                $continuation.label = 1;
                v1 = callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.VIDEO), (Object)$continuation);
                if (v1 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl50
            }
            case 1: {
                ts = $continuation.J$0;
                fixedBuffer = (ByteBuffer)$continuation.L$3;
                callback = (Function2)$continuation.L$2;
                mediaFrame = (MediaFrame)$continuation.L$1;
                this = (Av1Packet)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl50:
                // 2 sources

                this.configSend = true;
lbl51:
                // 2 sources

                if (this.parser.getObuType(fixedBuffer.get(0)) == ObuType.TEMPORAL_DELIMITER) {
                    fixedBuffer.position(2);
                    obuSequence = fixedBuffer.slice();
                    Intrinsics.checkNotNullExpressionValue((Object)obuSequence, (String)"fixedBuffer.slice()");
                    fixedBuffer = obuSequence;
                }
                fixedBuffer.rewind();
                size = fixedBuffer.remaining();
                buffer = new byte[this.header.length + size];
                nalType = mediaFrame.getInfo().isKeyFrame() != false ? VideoDataType.KEYFRAME.getValue() : VideoDataType.INTER_FRAME.getValue();
                this.header[0] = (byte)(128 | nalType << 4 | FourCCPacketType.CODED_FRAMES.getValue());
                fixedBuffer.get(buffer, this.header.length, size);
                System.arraycopy(this.header, 0, buffer, 0, this.header.length);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v2 = callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.VIDEO), (Object)$continuation);
                if (v2 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl78
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl78:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void reset(boolean resetInfo) {
        if (resetInfo) {
            this.obuSequence = null;
        }
        this.configSend = false;
    }
}

