/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.video;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.av1.Av1Parser;
import com.pedro.common.av1.ObuType;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.video.FourCCPacketType;
import com.pedro.rtmp.flv.video.VideoDataType;
import com.pedro.rtmp.flv.video.VideoFormat;
import com.pedro.rtmp.flv.video.VideoSpecificConfigAV1;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u0013J\u0010\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/pedro/rtmp/flv/video/Av1Packet;", "", "()V", "TAG", "", "configSend", "", "header", "", "obuSequence", "parser", "Lcom/pedro/common/av1/Av1Parser;", "createFlvVideoPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "callback", "Lkotlin/Function1;", "Lcom/pedro/rtmp/flv/FlvPacket;", "reset", "resetInfo", "sendVideoInfo", "rtmp_release"})
public final class Av1Packet {
    @NotNull
    private final String TAG;
    @NotNull
    private final Av1Parser parser = new Av1Parser();
    @NotNull
    private final byte[] header = new byte[5];
    private boolean configSend;
    @Nullable
    private byte[] obuSequence;

    public Av1Packet() {
        this.TAG = "AV1Packet";
    }

    public final void sendVideoInfo(@NotNull ByteBuffer obuSequence) {
        Intrinsics.checkNotNullParameter((Object)obuSequence, (String)"obuSequence");
        this.obuSequence = ExtensionsKt.toByteArray((ByteBuffer)obuSequence);
    }

    public final void createFlvVideoPacket(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo info, @NotNull Function1<? super FlvPacket, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"duplicate(...)");
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)byteBuffer2, (MediaCodec.BufferInfo)info);
        long ts = info.presentationTimeUs / (long)1000;
        int codec = VideoFormat.AV1.getValue();
        this.header[1] = (byte)(codec >> 24);
        this.header[2] = (byte)(codec >> 16);
        this.header[3] = (byte)(codec >> 8);
        this.header[4] = (byte)codec;
        byte[] buffer = null;
        if (!this.configSend) {
            this.header[0] = (byte)(0x80 | VideoDataType.KEYFRAME.getValue() << 4 | FourCCPacketType.SEQUENCE_START.getValue());
            byte[] obuSequence = this.obuSequence;
            if (obuSequence == null) {
                Log.e((String)this.TAG, (String)"waiting for a valid av1ConfigurationRecord");
                return;
            }
            VideoSpecificConfigAV1 config = new VideoSpecificConfigAV1(obuSequence);
            buffer = new byte[config.getSize() + this.header.length];
            config.write(buffer, this.header.length);
            System.arraycopy(this.header, 0, buffer, 0, this.header.length);
            callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.VIDEO));
            this.configSend = true;
        }
        if (this.parser.getObuType(fixedBuffer.get(0)) == ObuType.TEMPORAL_DELIMITER) {
            fixedBuffer.position(2);
            ByteBuffer byteBuffer3 = fixedBuffer.slice();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"slice(...)");
            fixedBuffer = byteBuffer3;
        }
        fixedBuffer.rewind();
        int size = fixedBuffer.remaining();
        buffer = new byte[this.header.length + size];
        int nalType = ExtensionsKt.isKeyframe((MediaCodec.BufferInfo)info) ? VideoDataType.KEYFRAME.getValue() : VideoDataType.INTER_FRAME.getValue();
        this.header[0] = (byte)(0x80 | nalType << 4 | FourCCPacketType.CODED_FRAMES.getValue());
        fixedBuffer.get(buffer, this.header.length, size);
        System.arraycopy(this.header, 0, buffer, 0, this.header.length);
        callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.VIDEO));
    }

    public final void reset(boolean resetInfo) {
        if (resetInfo) {
            this.obuSequence = null;
        }
        this.configSend = false;
    }

    public static /* synthetic */ void reset$default(Av1Packet av1Packet, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        av1Packet.reset(bl);
    }
}

