/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.video;

import com.pedro.rtmp.flv.video.SPSH265Parser;
import com.pedro.rtmp.utils.UtilsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\bJ \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/pedro/rtmp/flv/video/VideoSpecificConfigHEVC;", "", "sps", "", "pps", "vps", "([B[B[B)V", "size", "", "getSize", "()I", "calculateSize", "write", "", "buffer", "offset", "writeNaluArray", "type", "", "naluByteBuffer", "Ljava/nio/ByteBuffer;", "rtmp_release"})
public final class VideoSpecificConfigHEVC {
    @NotNull
    private final byte[] sps;
    @NotNull
    private final byte[] pps;
    @NotNull
    private final byte[] vps;
    private final int size;

    public VideoSpecificConfigHEVC(@NotNull byte[] sps, @NotNull byte[] pps, @NotNull byte[] vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Intrinsics.checkNotNullParameter((Object)vps, (String)"vps");
        this.sps = sps;
        this.pps = pps;
        this.vps = vps;
        this.size = this.calculateSize(this.sps, this.pps, this.vps);
    }

    public final int getSize() {
        return this.size;
    }

    public final void write(@NotNull byte[] buffer, int offset) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer data = ByteBuffer.wrap(buffer, offset, this.size);
        boolean configurationVersion = true;
        data.put((byte)(configurationVersion ? 1 : 0));
        SPSH265Parser spsParsed = new SPSH265Parser();
        spsParsed.parse(this.sps);
        int generalProfileSpace = spsParsed.getGeneralProfileSpace();
        int generalTierFlag = spsParsed.getGeneralTierFlag();
        int generalProfileIdc = spsParsed.getGeneralProfileIdc();
        int combined = generalProfileSpace << 6 | generalTierFlag << 5 | generalProfileIdc;
        data.put((byte)combined);
        int generalProfileCompatibilityFlags = spsParsed.getGeneralProfileCompatibilityFlags();
        data.putInt(generalProfileCompatibilityFlags);
        long generalConstraintIndicatorFlags = spsParsed.getGeneralConstraintIndicatorFlags();
        data.put(ArraysKt.sliceArray((byte[])UtilsKt.toByteArray(generalConstraintIndicatorFlags), (IntRange)RangesKt.until((int)2, (int)8)));
        int generalLevelIdc = spsParsed.getGeneralLevelIdc();
        data.put((byte)generalLevelIdc);
        int minSpatialSegmentationIdc = 0;
        data.putShort((short)(0xF000 | minSpatialSegmentationIdc));
        int parallelismType = 0;
        data.put((byte)(0xFC | parallelismType));
        int chromaFormatIdc = spsParsed.getChromaFormat();
        data.put((byte)(0xFC | chromaFormatIdc));
        int bitDepthLumaMinus8 = spsParsed.getBitDepthLumaMinus8();
        data.put((byte)(0xF8 | bitDepthLumaMinus8));
        int bitDepthChromaMinus8 = spsParsed.getBitDepthChromaMinus8();
        data.put((byte)(0xF8 | bitDepthChromaMinus8));
        boolean avgFrameRate = false;
        data.putShort((short)(avgFrameRate ? 1 : 0));
        int constantFrameRate = 0;
        int numTemporalLayers = 0;
        int temporalIdNested = 0;
        int lengthSizeMinusOne = 3;
        int combined2 = constantFrameRate << 6 | numTemporalLayers << 3 | temporalIdNested << 2 | lengthSizeMinusOne;
        data.put((byte)combined2);
        data.put((byte)3);
        Intrinsics.checkNotNull((Object)data);
        this.writeNaluArray((byte)32, this.vps, data);
        this.writeNaluArray((byte)33, this.sps, data);
        this.writeNaluArray((byte)34, this.pps, data);
    }

    private final void writeNaluArray(byte type, byte[] naluByteBuffer, ByteBuffer buffer) {
        int arrayCompleteness = 1;
        int reserved = 0;
        buffer.put((byte)(arrayCompleteness << 7 | reserved << 6 | type));
        boolean numNalus = true;
        buffer.putShort((short)(numNalus ? 1 : 0));
        buffer.putShort((short)naluByteBuffer.length);
        buffer.put(naluByteBuffer);
    }

    private final int calculateSize(byte[] sps, byte[] pps, byte[] vps) {
        return 28 + vps.length + 5 + sps.length + 5 + pps.length;
    }
}

