/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.utils.socket;

import com.pedro.rtmp.utils.TLSSocketFactory;
import com.pedro.rtmp.utils.socket.RtmpSocket;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/pedro/rtmp/utils/socket/TcpSocket;", "Lcom/pedro/rtmp/utils/socket/RtmpSocket;", "host", "", "port", "", "secured", "", "(Ljava/lang/String;IZ)V", "input", "Ljava/io/BufferedInputStream;", "output", "Ljava/io/OutputStream;", "socket", "Ljava/net/Socket;", "close", "", "connect", "flush", "getInputStream", "Ljava/io/InputStream;", "getOutStream", "isConnected", "isReachable", "rtmp_release"})
public final class TcpSocket
extends RtmpSocket {
    @NotNull
    private final String host;
    private final int port;
    private final boolean secured;
    private Socket socket;
    private BufferedInputStream input;
    private OutputStream output;

    public TcpSocket(@NotNull String host, int port, boolean secured) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.secured = secured;
    }

    @Override
    @NotNull
    public OutputStream getOutStream() {
        OutputStream outputStream = this.output;
        if (outputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"output");
            outputStream = null;
        }
        return outputStream;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        BufferedInputStream bufferedInputStream = this.input;
        if (bufferedInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"input");
            bufferedInputStream = null;
        }
        return bufferedInputStream;
    }

    @Override
    public void flush() {
        this.getOutStream().flush();
    }

    @Override
    public void connect() {
        Socket socket;
        if (this.secured) {
            try {
                TLSSocketFactory socketFactory = new TLSSocketFactory();
                this.socket = socketFactory.createSocket(this.host, this.port);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Create SSL socket failed: " + e.getMessage());
            }
        } else {
            this.socket = new Socket();
            SocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
            Socket socket2 = this.socket;
            if (socket2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                socket2 = null;
            }
            socket2.connect(socketAddress, this.getTimeout());
        }
        if ((socket = this.socket) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket = null;
        }
        OutputStream outputStream = socket.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"socket.getOutputStream()");
        this.output = outputStream;
        Socket socket3 = this.socket;
        if (socket3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket3 = null;
        }
        this.input = new BufferedInputStream(socket3.getInputStream());
        Socket socket4 = this.socket;
        if (socket4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket4 = null;
        }
        socket4.setSoTimeout(this.getTimeout());
    }

    @Override
    public void close() {
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket = null;
        }
        if (socket.isConnected()) {
            Socket socket2 = this.socket;
            if (socket2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                socket2 = null;
            }
            socket2.getInputStream().close();
            BufferedInputStream bufferedInputStream = this.input;
            if (bufferedInputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"input");
                bufferedInputStream = null;
            }
            bufferedInputStream.close();
            OutputStream outputStream = this.output;
            if (outputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                outputStream = null;
            }
            outputStream.close();
            Socket socket3 = this.socket;
            if (socket3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                socket3 = null;
            }
            socket3.close();
        }
    }

    @Override
    public boolean isConnected() {
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket = null;
        }
        return socket.isConnected();
    }

    @Override
    public boolean isReachable() {
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket = null;
        }
        InetAddress inetAddress = socket.getInetAddress();
        return inetAddress != null ? inetAddress.isReachable(5000) : false;
    }
}

