/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.amf.v0;

import com.pedro.rtmp.amf.v0.AmfData;
import com.pedro.rtmp.amf.v0.AmfType;
import com.pedro.rtmp.utils.UtilsKt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004\u00a8\u0006\u0015"}, d2={"Lcom/pedro/rtmp/amf/v0/AmfString;", "Lcom/pedro/rtmp/amf/v0/AmfData;", "value", "", "(Ljava/lang/String;)V", "bodySize", "", "getValue", "()Ljava/lang/String;", "setValue", "getSize", "getType", "Lcom/pedro/rtmp/amf/v0/AmfType;", "readBody", "", "input", "Ljava/io/InputStream;", "toString", "writeBody", "output", "Ljava/io/OutputStream;", "rtmp_release"})
public final class AmfString
extends AmfData {
    @NotNull
    private String value;
    private int bodySize;

    public AmfString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = this.value = value;
        Charset charset = Charsets.US_ASCII;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.bodySize = byArray.length + 2;
    }

    public /* synthetic */ AmfString(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final void setValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.value = string;
    }

    @Override
    public void readBody(@NotNull InputStream input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.bodySize = UtilsKt.readUInt16(input);
        byte[] bytes = new byte[this.bodySize];
        Object object = this;
        ((AmfString)object).bodySize += 2;
        UtilsKt.readUntil(input, bytes);
        object = Charsets.US_ASCII;
        boolean bl = false;
        this.value = new String(bytes, (Charset)object);
    }

    @Override
    public void writeBody(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String string = this.value;
        Charset charset = Charsets.US_ASCII;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        UtilsKt.writeUInt16(output, this.bodySize - 2);
        output.write(bytes);
    }

    @Override
    @NotNull
    public AmfType getType() {
        return AmfType.STRING;
    }

    @Override
    public int getSize() {
        return this.bodySize;
    }

    @NotNull
    public String toString() {
        return Intrinsics.stringPlus((String)"AmfString value: ", (Object)this.value);
    }

    public AmfString() {
        this(null, 1, null);
    }
}

