/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp;

import android.media.MediaCodec;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import com.pedro.rtmp.amf.v0.AmfNumber;
import com.pedro.rtmp.amf.v0.AmfObject;
import com.pedro.rtmp.amf.v0.AmfString;
import com.pedro.rtmp.flv.video.ProfileIop;
import com.pedro.rtmp.rtmp.CommandsManager;
import com.pedro.rtmp.rtmp.Handshake;
import com.pedro.rtmp.rtmp.RtmpSender;
import com.pedro.rtmp.rtmp.message.Abort;
import com.pedro.rtmp.rtmp.message.Acknowledgement;
import com.pedro.rtmp.rtmp.message.Aggregate;
import com.pedro.rtmp.rtmp.message.MessageType;
import com.pedro.rtmp.rtmp.message.RtmpMessage;
import com.pedro.rtmp.rtmp.message.SetChunkSize;
import com.pedro.rtmp.rtmp.message.SetPeerBandwidth;
import com.pedro.rtmp.rtmp.message.WindowAcknowledgementSize;
import com.pedro.rtmp.rtmp.message.command.Command;
import com.pedro.rtmp.rtmp.message.control.Type;
import com.pedro.rtmp.rtmp.message.control.UserControl;
import com.pedro.rtmp.utils.AuthUtil;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtmp.utils.CreateSSLSocket;
import com.pedro.rtmp.utils.RtmpConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00102\u001a\u000203H\u0002J\u001c\u00104\u001a\u0002032\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u00105\u001a\u00020\u0010H\u0007J\u0006\u00106\u001a\u000203J\u0010\u00106\u001a\u0002032\u0006\u00107\u001a\u00020\u0010H\u0002J\b\u00108\u001a\u00020\u0010H\u0002J\u000e\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020\u0010J\u0018\u0010;\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0006H\u0002J\u0010\u0010>\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0006H\u0002J\u0010\u0010?\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0002J\b\u0010@\u001a\u000203H\u0002J\b\u0010A\u001a\u000203H\u0002J\u0006\u0010B\u001a\u00020\u0010J\u001c\u0010C\u001a\u0002032\u0006\u0010D\u001a\u00020\u00122\n\b\u0002\u0010E\u001a\u0004\u0018\u00010\u0006H\u0007J\u0006\u0010F\u001a\u000203J\u0006\u0010G\u001a\u000203J\u0006\u0010H\u001a\u000203J\u0006\u0010I\u001a\u000203J\u000e\u0010J\u001a\u0002032\u0006\u0010K\u001a\u00020\bJ\u0016\u0010L\u001a\u0002032\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020PJ\u0016\u0010Q\u001a\u0002032\u0006\u0010R\u001a\u00020N2\u0006\u0010O\u001a\u00020PJ\u0016\u0010S\u001a\u0002032\u0006\u0010T\u001a\u00020\b2\u0006\u0010U\u001a\u00020\u0010J\u001a\u0010V\u001a\u0002032\b\u0010W\u001a\u0004\u0018\u00010\u00062\b\u0010X\u001a\u0004\u0018\u00010\u0006J\u000e\u0010Y\u001a\u0002032\u0006\u0010Z\u001a\u00020\u0010J\u000e\u0010[\u001a\u0002032\u0006\u0010\\\u001a\u00020\u0010J\u000e\u0010]\u001a\u0002032\u0006\u0010^\u001a\u00020_J\u000e\u0010`\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\bJ \u0010a\u001a\u0002032\u0006\u0010b\u001a\u00020N2\u0006\u0010c\u001a\u00020N2\b\u0010d\u001a\u0004\u0018\u00010NJ\u0016\u0010e\u001a\u0002032\u0006\u0010f\u001a\u00020\b2\u0006\u0010g\u001a\u00020\bJ\u000e\u0010h\u001a\u00020\u00102\u0006\u0010i\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n %*\u0004\u0018\u00010$0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0014R\u0011\u0010*\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0014R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lcom/pedro/rtmp/rtmp/RtmpClient;", "", "connectCheckerRtmp", "Lcom/pedro/rtmp/utils/ConnectCheckerRtmp;", "(Lcom/pedro/rtmp/utils/ConnectCheckerRtmp;)V", "TAG", "", "cacheSize", "", "getCacheSize", "()I", "commandsManager", "Lcom/pedro/rtmp/rtmp/CommandsManager;", "connectionSocket", "Ljava/net/Socket;", "doingRetry", "", "droppedAudioFrames", "", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "handler", "Landroid/os/Handler;", "<set-?>", "isStreaming", "()Z", "numRetry", "publishPermitted", "reTries", "reader", "Ljava/io/BufferedInputStream;", "rtmpSender", "Lcom/pedro/rtmp/rtmp/RtmpSender;", "rtmpUrlPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "runnable", "Ljava/lang/Runnable;", "sentAudioFrames", "getSentAudioFrames", "sentVideoFrames", "getSentVideoFrames", "thread", "Landroid/os/HandlerThread;", "tlsEnabled", "url", "writer", "Ljava/io/BufferedOutputStream;", "closeConnection", "", "connect", "isRetry", "disconnect", "clear", "establishConnection", "forceAkamaiTs", "enabled", "getAppName", "app", "name", "getStreamName", "getTcUrl", "handleMessages", "handleServerPackets", "hasCongestion", "reConnect", "delay", "backupUrl", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudio", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideo", "h264Buffer", "setAudioInfo", "sampleRate", "isStereo", "setAuthorization", "user", "password", "setLogs", "enable", "setOnlyAudio", "onlyAudio", "setProfileIop", "profileIop", "Lcom/pedro/rtmp/flv/video/ProfileIop;", "setReTries", "setSPSandPPS", "sps", "pps", "vps", "setVideoResolution", "width", "height", "shouldRetry", "reason", "rtmp_release"})
public final class RtmpClient {
    @NotNull
    private final ConnectCheckerRtmp connectCheckerRtmp;
    @NotNull
    private final String TAG;
    private final Pattern rtmpUrlPattern;
    @Nullable
    private Socket connectionSocket;
    @Nullable
    private BufferedInputStream reader;
    @Nullable
    private BufferedOutputStream writer;
    @Nullable
    private HandlerThread thread;
    @NotNull
    private final CommandsManager commandsManager;
    @NotNull
    private final RtmpSender rtmpSender;
    private volatile boolean isStreaming;
    @Nullable
    private String url;
    private boolean tlsEnabled;
    private boolean doingRetry;
    private int numRetry;
    private int reTries;
    @NotNull
    private final Handler handler;
    @Nullable
    private Runnable runnable;
    private boolean publishPermitted;

    public RtmpClient(@NotNull ConnectCheckerRtmp connectCheckerRtmp) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtmp, (String)"connectCheckerRtmp");
        this.connectCheckerRtmp = connectCheckerRtmp;
        this.TAG = "RtmpClient";
        this.rtmpUrlPattern = Pattern.compile("^rtmps?://([^/:]+)(?::(\\d+))*/([^/]+)/?([^*]*)$");
        this.commandsManager = new CommandsManager();
        this.rtmpSender = new RtmpSender(this.connectCheckerRtmp, this.commandsManager);
        this.handler = new Handler(Looper.getMainLooper());
    }

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final long getDroppedAudioFrames() {
        return this.rtmpSender.getDroppedAudioFrames();
    }

    public final long getDroppedVideoFrames() {
        return this.rtmpSender.getDroppedVideoFrames();
    }

    public final int getCacheSize() {
        return this.rtmpSender.getCacheSize();
    }

    public final long getSentAudioFrames() {
        return this.rtmpSender.getSentAudioFrames();
    }

    public final long getSentVideoFrames() {
        return this.rtmpSender.getSentVideoFrames();
    }

    public final void setOnlyAudio(boolean onlyAudio) {
        this.commandsManager.setOnlyAudio(onlyAudio);
    }

    public final void forceAkamaiTs(boolean enabled) {
        this.commandsManager.setAkamaiTs(enabled);
    }

    public final void setAuthorization(@Nullable String user, @Nullable String password) {
        this.commandsManager.setAuth(user, password);
    }

    public final void setReTries(int reTries) {
        this.numRetry = reTries;
        this.reTries = reTries;
    }

    public final boolean shouldRetry(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        boolean validReason = this.doingRetry && !StringsKt.contains$default((CharSequence)reason, (CharSequence)"Endpoint malformed", (boolean)false, (int)2, null);
        return validReason && this.reTries > 0;
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.commandsManager.setAudioInfo(sampleRate, isStereo);
        this.rtmpSender.setAudioInfo(sampleRate, isStereo);
    }

    public final void setSPSandPPS(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Log.i((String)this.TAG, (String)"send sps and pps");
        this.rtmpSender.setVideoInfo(sps, pps, vps);
    }

    public final void setProfileIop(@NotNull ProfileIop profileIop) {
        Intrinsics.checkNotNullParameter((Object)((Object)profileIop), (String)"profileIop");
        this.rtmpSender.setProfileIop(profileIop);
    }

    public final void setVideoResolution(int width, int height) {
        this.commandsManager.setVideoResolution(width, height);
    }

    @JvmOverloads
    public final void connect(@Nullable String url, boolean isRetry) {
        if (!isRetry) {
            this.doingRetry = true;
        }
        if (url == null) {
            this.isStreaming = false;
            this.connectCheckerRtmp.onConnectionFailedRtmp("Endpoint malformed, should be: rtmp://ip:port/appname/streamname");
            return;
        }
        if (!this.isStreaming || isRetry) {
            int n;
            boolean bl;
            String string;
            int n2;
            String portStr;
            this.url = url;
            this.connectCheckerRtmp.onConnectionStartedRtmp(url);
            Matcher rtmpMatcher = this.rtmpUrlPattern.matcher(url);
            if (!rtmpMatcher.matches()) {
                this.connectCheckerRtmp.onConnectionFailedRtmp("Endpoint malformed, should be: rtmp://ip:port/appname/streamname");
                return;
            }
            String string2 = rtmpMatcher.group(0);
            this.tlsEnabled = StringsKt.startsWith$default((String)(string2 == null ? "" : string2), (String)"rtmps", (boolean)false, (int)2, null);
            string2 = rtmpMatcher.group(1);
            this.commandsManager.setHost(string2 == null ? "" : string2);
            String string3 = portStr = rtmpMatcher.group(2);
            if (string3 == null) {
                n2 = 1935;
            } else {
                string = string3;
                bl = false;
                n2 = n = Integer.parseInt(string);
            }
            this.commandsManager.setPort(n2);
            string3 = rtmpMatcher.group(3);
            String string4 = string3 == null ? "" : string3;
            string3 = rtmpMatcher.group(4);
            this.commandsManager.setAppName(this.getAppName(string4, string3 == null ? "" : string3));
            string3 = rtmpMatcher.group(4);
            this.commandsManager.setStreamName(this.getStreamName(string3 == null ? "" : string3));
            string3 = rtmpMatcher.group(0);
            string3 = string3 == null ? "" : string3;
            n = 0;
            string = rtmpMatcher.group(0);
            int n3 = (string == null ? "" : string).length() - this.commandsManager.getStreamName().length();
            bl = false;
            String string5 = string3.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.commandsManager.setTcUrl(this.getTcUrl(string5));
            this.isStreaming = true;
            this.thread = new HandlerThread(this.TAG);
            string3 = this.thread;
            if (string3 != null) {
                string3.start();
            }
            string3 = this.thread;
            if (string3 != null) {
                String string6 = string3;
                n3 = 0;
                bl = false;
                String it = string6;
                boolean bl2 = false;
                Handler h = new Handler(it.getLooper());
                h.post(() -> RtmpClient.connect$lambda-1$lambda-0(this));
            }
        }
    }

    public static /* synthetic */ void connect$default(RtmpClient rtmpClient, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        rtmpClient.connect(string, bl);
    }

    private final void handleServerPackets() {
        try {
            while (!Thread.interrupted()) {
                this.handleMessages();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final String getAppName(String app, String name) {
        String string;
        if (!StringsKt.contains$default((CharSequence)name, (CharSequence)"/", (boolean)false, (int)2, null)) {
            string = app;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(app).append('/');
            String string2 = name;
            int n = 0;
            int n2 = StringsKt.indexOf$default((CharSequence)name, (String)"/", (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = stringBuilder.append(string4).toString();
        }
        return string;
    }

    private final String getStreamName(String name) {
        String string;
        if (!StringsKt.contains$default((CharSequence)name, (CharSequence)"/", (boolean)false, (int)2, null)) {
            string = name;
        } else {
            String string2 = name;
            int n = StringsKt.indexOf$default((CharSequence)name, (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    private final String getTcUrl(String url) {
        String string;
        if (StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
            String string2 = url;
            int n = 0;
            int n2 = url.length() - 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = url;
        }
        return string;
    }

    private final boolean establishConnection() throws IOException {
        Object socketAddress;
        Socket socket = null;
        if (!this.tlsEnabled) {
            socket = new Socket();
            socketAddress = new InetSocketAddress(this.commandsManager.getHost(), this.commandsManager.getPort());
            socket.connect((SocketAddress)socketAddress, 5000);
        } else {
            socketAddress = CreateSSLSocket.createSSlSocket(this.commandsManager.getHost(), this.commandsManager.getPort());
            if (socketAddress == null) {
                throw new IOException("Socket creation failed");
            }
            socket = socketAddress;
        }
        socket.setSoTimeout(5000);
        BufferedInputStream reader = new BufferedInputStream(socket.getInputStream());
        BufferedOutputStream writer = new BufferedOutputStream(socket.getOutputStream());
        long timestamp = System.currentTimeMillis() / (long)1000;
        Handshake handshake = new Handshake();
        if (!handshake.sendHandshake(reader, writer)) {
            return false;
        }
        this.commandsManager.setTimestamp((int)timestamp);
        this.commandsManager.setStartTs(System.nanoTime() / (long)1000);
        this.connectionSocket = socket;
        this.reader = reader;
        this.writer = writer;
        return true;
    }

    private final void handleMessages() throws IOException {
        BufferedInputStream bufferedInputStream = this.reader;
        if (bufferedInputStream == null) {
            throw new IOException("Invalid reader, Connection failed");
        }
        BufferedInputStream reader = bufferedInputStream;
        BufferedOutputStream bufferedOutputStream = this.writer;
        if (bufferedOutputStream == null) {
            throw new IOException("Invalid writer, Connection failed");
        }
        BufferedOutputStream writer = bufferedOutputStream;
        RtmpMessage message = this.commandsManager.readMessageResponse(reader);
        MessageType messageType = message.getType();
        int n = WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()];
        block3 : switch (n) {
            case 1: {
                SetChunkSize setChunkSize = (SetChunkSize)message;
                this.commandsManager.setReadChunkSize(setChunkSize.getChunkSize());
                Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"chunk size configured to ", (Object)setChunkSize.getChunkSize()));
                break;
            }
            case 2: {
                Acknowledgement setChunkSize = (Acknowledgement)message;
                break;
            }
            case 3: {
                WindowAcknowledgementSize windowAcknowledgementSize = (WindowAcknowledgementSize)message;
                RtmpConfig.INSTANCE.setAcknowledgementWindowSize(windowAcknowledgementSize.getAcknowledgementWindowSize());
                break;
            }
            case 4: {
                SetPeerBandwidth setPeerBandwidth = (SetPeerBandwidth)message;
                this.commandsManager.sendWindowAcknowledgementSize(writer);
                break;
            }
            case 5: {
                Abort setPeerBandwidth = (Abort)message;
                break;
            }
            case 6: {
                Aggregate setPeerBandwidth = (Aggregate)message;
                break;
            }
            case 7: {
                UserControl userControl = (UserControl)message;
                Type type = userControl.getType();
                int n2 = WhenMappings.$EnumSwitchMapping$1[type.ordinal()];
                if (n2 == 1) {
                    this.commandsManager.sendPong(userControl.getEvent(), writer);
                    break;
                }
                Log.i((String)this.TAG, (String)("user control command " + (Object)((Object)type) + " ignored"));
                break;
            }
            case 8: 
            case 9: {
                Command command = (Command)message;
                String commandName = this.commandsManager.getSessionHistory().getName(command.getCommandId());
                switch (command.getName()) {
                    case "_result": {
                        String string = commandName;
                        if (Intrinsics.areEqual((Object)string, (Object)"connect")) {
                            if (this.commandsManager.getOnAuth()) {
                                this.connectCheckerRtmp.onAuthSuccessRtmp();
                                this.commandsManager.setOnAuth(false);
                            }
                            this.commandsManager.createStream(writer);
                        } else if (Intrinsics.areEqual((Object)string, (Object)"createStream")) {
                            try {
                                this.commandsManager.setStreamId((int)((AmfNumber)command.getData().get(3)).getValue());
                                this.commandsManager.sendPublish(writer);
                            }
                            catch (ClassCastException e) {
                                Log.e((String)this.TAG, (String)"error parsing _result createStream", (Throwable)e);
                            }
                        }
                        string = commandName;
                        Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"success response received from ", (Object)(string == null ? "unknown command" : string)));
                        break block3;
                    }
                    case "_error": {
                        try {
                            Object object = ((AmfObject)command.getData().get(3)).getProperty("description");
                            if (object == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.pedro.rtmp.amf.v0.AmfString");
                            }
                            String description = ((AmfString)object).getValue();
                            object = commandName;
                            if (Intrinsics.areEqual((Object)object, (Object)"connect")) {
                                if (StringsKt.contains$default((CharSequence)description, (CharSequence)"reason=authfail", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)description, (CharSequence)"reason=nosuchuser", (boolean)false, (int)2, null)) {
                                    this.connectCheckerRtmp.onAuthErrorRtmp();
                                    break block3;
                                }
                                if (this.commandsManager.getUser() != null && this.commandsManager.getPassword() != null && StringsKt.contains$default((CharSequence)description, (CharSequence)"challenge=", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)description, (CharSequence)"salt=", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)description, (CharSequence)"nonce=", (boolean)false, (int)2, null)) {
                                    this.closeConnection();
                                    this.establishConnection();
                                    BufferedOutputStream bufferedOutputStream2 = this.writer;
                                    if (bufferedOutputStream2 == null) {
                                        throw new IOException("Invalid writer, Connection failed");
                                    }
                                    writer = bufferedOutputStream2;
                                    this.commandsManager.setOnAuth(true);
                                    if (StringsKt.contains$default((CharSequence)description, (CharSequence)"challenge=", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)description, (CharSequence)"salt=", (boolean)false, (int)2, null)) {
                                        String salt = AuthUtil.INSTANCE.getSalt(description);
                                        String challenge = AuthUtil.INSTANCE.getChallenge(description);
                                        String opaque = AuthUtil.INSTANCE.getOpaque(description);
                                        String string = this.commandsManager.getUser();
                                        String string2 = string == null ? "" : string;
                                        string = this.commandsManager.getPassword();
                                        this.commandsManager.sendConnect(AuthUtil.INSTANCE.getAdobeAuthUserResult(string2, string == null ? "" : string, salt, challenge, opaque), writer);
                                        break block3;
                                    }
                                    if (!StringsKt.contains$default((CharSequence)description, (CharSequence)"nonce=", (boolean)false, (int)2, null)) break block3;
                                    String nonce = AuthUtil.INSTANCE.getNonce(description);
                                    String string = this.commandsManager.getUser();
                                    String string3 = string == null ? "" : string;
                                    string = this.commandsManager.getPassword();
                                    this.commandsManager.sendConnect(AuthUtil.INSTANCE.getLlnwAuthUserResult(string3, string == null ? "" : string, nonce, this.commandsManager.getAppName()), writer);
                                    break block3;
                                }
                                if (StringsKt.contains$default((CharSequence)description, (CharSequence)"code=403", (boolean)false, (int)2, null)) {
                                    if (StringsKt.contains$default((CharSequence)description, (CharSequence)"authmod=adobe", (boolean)false, (int)2, null)) {
                                        this.closeConnection();
                                        this.establishConnection();
                                        BufferedOutputStream bufferedOutputStream3 = this.writer;
                                        if (bufferedOutputStream3 == null) {
                                            throw new IOException("Invalid writer, Connection failed");
                                        }
                                        writer = bufferedOutputStream3;
                                        Log.i((String)this.TAG, (String)"sending auth mode adobe");
                                        this.commandsManager.sendConnect(Intrinsics.stringPlus((String)"?authmod=adobe&user=", (Object)this.commandsManager.getUser()), writer);
                                        break block3;
                                    }
                                    if (!StringsKt.contains$default((CharSequence)description, (CharSequence)"authmod=llnw", (boolean)false, (int)2, null)) break block3;
                                    Log.i((String)this.TAG, (String)"sending auth mode llnw");
                                    this.commandsManager.sendConnect(Intrinsics.stringPlus((String)"?authmod=llnw&user=", (Object)this.commandsManager.getUser()), writer);
                                    break block3;
                                }
                                this.connectCheckerRtmp.onAuthErrorRtmp();
                                break block3;
                            }
                            this.connectCheckerRtmp.onConnectionFailedRtmp(description);
                        }
                        catch (ClassCastException e) {
                            Log.e((String)this.TAG, (String)"error parsing _error command", (Throwable)e);
                        }
                        break block3;
                    }
                    case "onStatus": {
                        try {
                            String code;
                            Object object = ((AmfObject)command.getData().get(3)).getProperty("code");
                            if (object == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.pedro.rtmp.amf.v0.AmfString");
                            }
                            switch (((AmfString)object).getValue()) {
                                case "NetStream.Publish.Start": {
                                    this.commandsManager.sendMetadata(writer);
                                    this.connectCheckerRtmp.onConnectionSuccessRtmp();
                                    this.rtmpSender.setOutput(writer);
                                    this.rtmpSender.start();
                                    this.publishPermitted = true;
                                    break block3;
                                }
                                case "NetStream.Publish.BadName": 
                                case "NetConnection.Connect.Rejected": {
                                    this.connectCheckerRtmp.onConnectionFailedRtmp(Intrinsics.stringPlus((String)"onStatus: ", (Object)code));
                                    break block3;
                                }
                            }
                            object = commandName;
                            Log.i((String)this.TAG, (String)("onStatus " + code + " response received from " + (String)(object == null ? "unknown command" : object)));
                        }
                        catch (ClassCastException e) {
                            Log.e((String)this.TAG, (String)"error parsing onStatus command", (Throwable)e);
                        }
                        break block3;
                    }
                }
                String string = commandName;
                Log.i((String)this.TAG, (String)("unknown " + command.getName() + " response received from " + (string == null ? "unknown command" : string)));
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                Log.e((String)this.TAG, (String)("unimplemented response for " + (Object)((Object)message.getType()) + ". Ignored"));
            }
        }
    }

    private final void closeConnection() {
        Socket socket = this.connectionSocket;
        if (socket != null) {
            socket.close();
        }
        this.commandsManager.reset();
    }

    @JvmOverloads
    public final void reConnect(long delay, @Nullable String backupUrl) {
        Object object = this;
        int n = ((RtmpClient)object).reTries;
        ((RtmpClient)object).reTries = n + -1;
        this.disconnect(false);
        this.runnable = () -> RtmpClient.reConnect$lambda-2(backupUrl, this);
        object = this.runnable;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            this.handler.postDelayed((Runnable)it, delay);
        }
    }

    public static /* synthetic */ void reConnect$default(RtmpClient rtmpClient, long l, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        rtmpClient.reConnect(l, string);
    }

    public final void disconnect() {
        Runnable runnable = this.runnable;
        if (runnable != null) {
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            this.handler.removeCallbacks(it);
        }
        this.disconnect(true);
    }

    private final void disconnect(boolean clear) {
        Closeable closeable;
        if (this.isStreaming) {
            this.rtmpSender.stop(clear);
        }
        if ((closeable = this.reader) != null) {
            ((BufferedInputStream)closeable).close();
        }
        this.reader = null;
        Object object = this.thread;
        Object object2 = closeable = object == null ? null : object.getLooper();
        if (closeable != null && (object = closeable.getThread()) != null) {
            ((Thread)object).interrupt();
        }
        if ((closeable = this.thread) != null && (object = closeable.getLooper()) != null) {
            object.quit();
        }
        if ((closeable = this.thread) != null) {
            closeable.quit();
        }
        try {
            closeable = this.writer;
            if (closeable != null) {
                ((BufferedOutputStream)closeable).flush();
            }
            closeable = this.thread;
            if (closeable != null) {
                closeable.join(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thread = new HandlerThread(this.TAG);
        closeable = this.thread;
        if (closeable != null) {
            closeable.start();
        }
        closeable = this.thread;
        if (closeable != null) {
            object = closeable;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            Handler h = new Handler(it.getLooper());
            h.post(() -> RtmpClient.disconnect$lambda-7$lambda-6(this));
        }
        try {
            closeable = this.thread;
            if (closeable != null) {
                closeable.join(200L);
            }
            object = this.thread;
            Object object3 = closeable = object == null ? null : object.getLooper();
            if (closeable != null && (object = closeable.getThread()) != null) {
                ((Thread)object).interrupt();
            }
            if ((closeable = this.thread) != null && (object = closeable.getLooper()) != null) {
                object.quit();
            }
            if ((closeable = this.thread) != null) {
                closeable.quit();
            }
            this.thread = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clear) {
            this.reTries = this.numRetry;
            this.doingRetry = false;
            this.isStreaming = false;
            this.connectCheckerRtmp.onDisconnectRtmp();
        }
        this.publishPermitted = false;
        this.commandsManager.reset();
    }

    public final void sendVideo(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtmpSender.sendVideoFrame(h264Buffer, info);
    }

    public final void sendAudio(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtmpSender.sendAudioFrame(aacBuffer, info);
    }

    public final boolean hasCongestion() {
        return this.rtmpSender.hasCongestion();
    }

    public final void resetSentAudioFrames() {
        this.rtmpSender.resetSentAudioFrames();
    }

    public final void resetSentVideoFrames() {
        this.rtmpSender.resetSentVideoFrames();
    }

    public final void resetDroppedAudioFrames() {
        this.rtmpSender.resetDroppedAudioFrames();
    }

    public final void resetDroppedVideoFrames() {
        this.rtmpSender.resetDroppedVideoFrames();
    }

    public final void resizeCache(int newSize) throws RuntimeException {
        this.rtmpSender.resizeCache(newSize);
    }

    public final void setLogs(boolean enable) {
        this.rtmpSender.setLogs(enable);
    }

    @JvmOverloads
    public final void connect(@Nullable String url) {
        RtmpClient.connect$default(this, url, false, 2, null);
    }

    @JvmOverloads
    public final void reConnect(long delay) {
        RtmpClient.reConnect$default(this, delay, null, 2, null);
    }

    private static final void connect$lambda-1$lambda-0(RtmpClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            if (!this$0.establishConnection()) {
                this$0.connectCheckerRtmp.onConnectionFailedRtmp("Handshake failed");
                return;
            }
            BufferedOutputStream bufferedOutputStream = this$0.writer;
            if (bufferedOutputStream == null) {
                throw new IOException("Invalid writer, Connection failed");
            }
            BufferedOutputStream writer = bufferedOutputStream;
            this$0.commandsManager.sendConnect("", writer);
            while (!Thread.interrupted() && !this$0.publishPermitted) {
                this$0.handleMessages();
            }
            this$0.handleServerPackets();
        }
        catch (Exception e) {
            Log.e((String)this$0.TAG, (String)"connection error", (Throwable)e);
            this$0.connectCheckerRtmp.onConnectionFailedRtmp(Intrinsics.stringPlus((String)"Error configure stream, ", (Object)e.getMessage()));
            return;
        }
    }

    private static final void reConnect$lambda-2(String $backupUrl, RtmpClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = $backupUrl;
        String reconnectUrl = string == null ? this$0.url : string;
        this$0.connect(reconnectUrl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void disconnect$lambda-7$lambda-6(RtmpClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            BufferedOutputStream bufferedOutputStream = this$0.writer;
            if (bufferedOutputStream != null) {
                BufferedOutputStream bufferedOutputStream2 = bufferedOutputStream;
                boolean bl = false;
                boolean bl2 = false;
                BufferedOutputStream writer = bufferedOutputStream2;
                boolean bl3 = false;
                this$0.commandsManager.sendClose(writer);
            }
            bufferedOutputStream = this$0.writer;
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
            this$0.writer = null;
            this$0.closeConnection();
        }
        catch (IOException e) {
            Log.e((String)this$0.TAG, (String)"disconnect error", (Throwable)e);
        }
        finally {
            Looper looper;
            HandlerThread handlerThread = this$0.thread;
            if (handlerThread != null && (looper = handlerThread.getLooper()) != null) {
                looper.quit();
            }
            return;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MessageType.values().length];
            nArray[MessageType.SET_CHUNK_SIZE.ordinal()] = 1;
            nArray[MessageType.ACKNOWLEDGEMENT.ordinal()] = 2;
            nArray[MessageType.WINDOW_ACKNOWLEDGEMENT_SIZE.ordinal()] = 3;
            nArray[MessageType.SET_PEER_BANDWIDTH.ordinal()] = 4;
            nArray[MessageType.ABORT.ordinal()] = 5;
            nArray[MessageType.AGGREGATE.ordinal()] = 6;
            nArray[MessageType.USER_CONTROL.ordinal()] = 7;
            nArray[MessageType.COMMAND_AMF0.ordinal()] = 8;
            nArray[MessageType.COMMAND_AMF3.ordinal()] = 9;
            nArray[MessageType.VIDEO.ordinal()] = 10;
            nArray[MessageType.AUDIO.ordinal()] = 11;
            nArray[MessageType.DATA_AMF0.ordinal()] = 12;
            nArray[MessageType.DATA_AMF3.ordinal()] = 13;
            nArray[MessageType.SHARED_OBJECT_AMF0.ordinal()] = 14;
            nArray[MessageType.SHARED_OBJECT_AMF3.ordinal()] = 15;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Type.values().length];
            nArray[Type.PING_REQUEST.ordinal()] = 1;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

