/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp;

import android.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;

public class Util {
    private static final String HEXES = "0123456789ABCDEF";

    public static void writeUnsignedInt32(OutputStream out, int value) throws IOException {
        out.write((byte)(value >>> 24));
        out.write((byte)(value >>> 16));
        out.write((byte)(value >>> 8));
        out.write((byte)value);
    }

    public static int readUnsignedInt32(InputStream in) throws IOException {
        return (in.read() & 0xFF) << 24 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 8 | in.read() & 0xFF;
    }

    public static int readUnsignedInt24(InputStream in) throws IOException {
        return (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 8 | in.read() & 0xFF;
    }

    public static int readUnsignedInt16(InputStream in) throws IOException {
        return (in.read() & 0xFF) << 8 | in.read() & 0xFF;
    }

    public static void writeUnsignedInt24(OutputStream out, int value) throws IOException {
        out.write((byte)(value >>> 16));
        out.write((byte)(value >>> 8));
        out.write((byte)value);
    }

    public static void writeUnsignedInt16(OutputStream out, int value) throws IOException {
        out.write((byte)(value >>> 8));
        out.write((byte)value);
    }

    public static int toUnsignedInt32(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static int toUnsignedInt32LittleEndian(byte[] bytes) {
        return (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
    }

    public static void writeUnsignedInt32LittleEndian(OutputStream out, int value) throws IOException {
        out.write((byte)value);
        out.write((byte)(value >>> 8));
        out.write((byte)(value >>> 16));
        out.write((byte)(value >>> 24));
    }

    public static int toUnsignedInt24(byte[] bytes) {
        return (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static int toUnsignedInt16(byte[] bytes) {
        return (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static String toHexString(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static String toHexString(byte b) {
        return "" + HEXES.charAt((b & 0xF0) >> 4) + HEXES.charAt(b & 0xF);
    }

    public static void readBytesUntilFull(InputStream in, byte[] targetBuffer) throws IOException {
        int read;
        int totalBytesRead = 0;
        int targetBytes = targetBuffer.length;
        do {
            if ((read = in.read(targetBuffer, totalBytesRead, targetBytes - totalBytesRead)) != -1) continue;
            throw new IOException("Unexpected EOF reached before read buffer was filled");
        } while ((totalBytesRead += read) < targetBytes);
    }

    public static byte[] toByteArray(double d) {
        long l = Double.doubleToRawLongBits(d);
        return new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
    }

    public static byte[] unsignedInt32ToByteArray(int value) throws IOException {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static double readDouble(InputStream in) throws IOException {
        long bits = (long)(in.read() & 0xFF) << 56 | (long)(in.read() & 0xFF) << 48 | (long)(in.read() & 0xFF) << 40 | (long)(in.read() & 0xFF) << 32 | (long)((in.read() & 0xFF) << 24) | (long)((in.read() & 0xFF) << 16) | (long)((in.read() & 0xFF) << 8) | (long)(in.read() & 0xFF);
        return Double.longBitsToDouble(bits);
    }

    public static void writeDouble(OutputStream out, double d) throws IOException {
        long l = Double.doubleToRawLongBits(d);
        out.write(new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)});
    }

    public static String getSalt(String description) {
        String[] data;
        String salt = null;
        for (String s : data = description.split("&")) {
            if (!s.contains("salt=")) continue;
            salt = s.substring(5);
            break;
        }
        return salt;
    }

    public static String getChallenge(String description) {
        String[] data;
        String challenge = null;
        for (String s : data = description.split("&")) {
            if (!s.contains("challenge=")) continue;
            challenge = s.substring(10);
            break;
        }
        return challenge;
    }

    public static String getOpaque(String description) {
        String[] data;
        String opaque = "";
        for (String s : data = description.split("&")) {
            if (!s.contains("opaque=")) continue;
            opaque = s.substring(7);
            break;
        }
        return opaque;
    }

    public static String stringToMD5BASE64(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes("UTF-8"), 0, s.length());
            byte[] md5hash = md.digest();
            return Base64.encodeToString((byte[])md5hash, (int)2);
        }
        catch (Exception e) {
            return null;
        }
    }
}

