/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.io;

import android.util.Log;
import com.github.faucamp.simplertmp.RtmpPublisher;
import com.github.faucamp.simplertmp.Util;
import com.github.faucamp.simplertmp.amf.AmfMap;
import com.github.faucamp.simplertmp.amf.AmfNull;
import com.github.faucamp.simplertmp.amf.AmfNumber;
import com.github.faucamp.simplertmp.amf.AmfObject;
import com.github.faucamp.simplertmp.amf.AmfString;
import com.github.faucamp.simplertmp.io.ChunkStreamInfo;
import com.github.faucamp.simplertmp.io.RtmpDecoder;
import com.github.faucamp.simplertmp.io.RtmpSessionInfo;
import com.github.faucamp.simplertmp.packets.Abort;
import com.github.faucamp.simplertmp.packets.Audio;
import com.github.faucamp.simplertmp.packets.Command;
import com.github.faucamp.simplertmp.packets.Data;
import com.github.faucamp.simplertmp.packets.Handshake;
import com.github.faucamp.simplertmp.packets.RtmpPacket;
import com.github.faucamp.simplertmp.packets.UserControl;
import com.github.faucamp.simplertmp.packets.Video;
import com.github.faucamp.simplertmp.packets.WindowAckSize;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ossrs.rtmp.BitrateManager;
import net.ossrs.rtmp.ConnectCheckerRtmp;
import net.ossrs.rtmp.CreateSSLSocket;

public class RtmpConnection
implements RtmpPublisher {
    private static final String TAG = "RtmpConnection";
    private static final Pattern rtmpUrlPattern = Pattern.compile("^rtmps?://([^/:]+)(?::(\\d+))*/([^/]+)/?([^*]*)$");
    private int port;
    private String host;
    private String appName;
    private String streamName;
    private String publishType;
    private String swfUrl;
    private String tcUrl;
    private String pageUrl;
    private Socket socket;
    private RtmpSessionInfo rtmpSessionInfo;
    private RtmpDecoder rtmpDecoder;
    private BufferedInputStream inputStream;
    private BufferedOutputStream outputStream;
    private Thread rxPacketHandler;
    private volatile boolean connected = false;
    private volatile boolean publishPermitted = false;
    private final Object connectingLock = new Object();
    private final Object publishLock = new Object();
    private int currentStreamId = 0;
    private int transactionIdCounter = 0;
    private int videoWidth;
    private int videoHeight;
    private ConnectCheckerRtmp connectCheckerRtmp;
    private boolean tlsEnabled;
    private String user = null;
    private String password = null;
    private String salt = null;
    private String challenge = null;
    private String opaque = null;
    private boolean onAuth = false;
    private String netConnectionDescription;
    private BitrateManager bitrateManager;

    public RtmpConnection(ConnectCheckerRtmp connectCheckerRtmp) {
        this.connectCheckerRtmp = connectCheckerRtmp;
        this.bitrateManager = new BitrateManager(connectCheckerRtmp);
    }

    private void handshake(InputStream in, OutputStream out) throws IOException {
        Handshake handshake = new Handshake();
        handshake.writeC0(out);
        handshake.writeC1(out);
        out.flush();
        handshake.readS0(in);
        handshake.readS1(in);
        handshake.writeC2(out);
        out.flush();
        handshake.readS2(in);
    }

    private String getAppName(String app, String name) {
        if (!name.contains("/")) {
            return app;
        }
        return app + "/" + name.substring(0, name.indexOf("/"));
    }

    private String getStreamName(String name) {
        if (!name.contains("/")) {
            return name;
        }
        return name.substring(name.indexOf("/") + 1);
    }

    private String getTcUrl(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    @Override
    public boolean connect(String url) {
        if (url == null) {
            this.connectCheckerRtmp.onConnectionFailedRtmp("Endpoint malformed, should be: rtmp://ip:port/appname/streamname");
            return false;
        }
        Matcher rtmpMatcher = rtmpUrlPattern.matcher(url);
        if (!rtmpMatcher.matches()) {
            this.connectCheckerRtmp.onConnectionFailedRtmp("Endpoint malformed, should be: rtmp://ip:port/appname/streamname");
            return false;
        }
        this.tlsEnabled = rtmpMatcher.group(0).startsWith("rtmps");
        this.swfUrl = "";
        this.pageUrl = "";
        this.host = rtmpMatcher.group(1);
        String portStr = rtmpMatcher.group(2);
        this.port = portStr != null ? Integer.parseInt(portStr) : 1935;
        this.appName = this.getAppName(rtmpMatcher.group(3), rtmpMatcher.group(4));
        this.streamName = this.getStreamName(rtmpMatcher.group(4));
        this.tcUrl = this.getTcUrl(rtmpMatcher.group(0).substring(0, rtmpMatcher.group(0).length() - this.streamName.length()));
        Log.d((String)TAG, (String)("connect() called. Host: " + this.host + ", port: " + this.port + ", appName: " + this.appName + ", publishPath: " + this.streamName));
        this.rtmpSessionInfo = new RtmpSessionInfo();
        this.rtmpDecoder = new RtmpDecoder(this.rtmpSessionInfo);
        try {
            if (!this.tlsEnabled) {
                this.socket = new Socket();
                InetSocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
                this.socket.connect(socketAddress, 5000);
            } else {
                this.socket = CreateSSLSocket.createSSlSocket(this.host, this.port);
                if (this.socket == null) {
                    throw new IOException("Socket creation failed");
                }
            }
            this.inputStream = new BufferedInputStream(this.socket.getInputStream());
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
            Log.d((String)TAG, (String)"connect(): socket connection established, doing handhake...");
            this.handshake(this.inputStream, this.outputStream);
            Log.d((String)TAG, (String)"connect(): handshake done");
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error", (Throwable)e);
            this.connectCheckerRtmp.onConnectionFailedRtmp("Connect error, " + e.getMessage());
            return false;
        }
        this.rxPacketHandler = new Thread(new Runnable(){

            @Override
            public void run() {
                Log.d((String)RtmpConnection.TAG, (String)"starting main rx handler loop");
                RtmpConnection.this.handleRxPacketLoop();
            }
        });
        this.rxPacketHandler.start();
        return this.rtmpConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rtmpConnect() {
        if (this.connected) {
            this.connectCheckerRtmp.onConnectionFailedRtmp("Already connected");
            return false;
        }
        if (this.user != null && this.password != null) {
            this.sendConnect("?authmod=adobe&user=" + this.user);
        } else {
            this.sendConnect("");
        }
        Object object = this.connectingLock;
        synchronized (object) {
            try {
                this.connectingLock.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.connected) {
            this.shutdown(true);
            this.connectCheckerRtmp.onConnectionFailedRtmp("Fail to connect, time out");
        }
        return this.connected;
    }

    private void sendConnect(String user) {
        ChunkStreamInfo.markSessionTimestampTx();
        Log.d((String)TAG, (String)"rtmpConnect(): Building 'connect' invoke packet");
        ChunkStreamInfo chunkStreamInfo = this.rtmpSessionInfo.getChunkStreamInfo(5);
        Command invoke = new Command("connect", ++this.transactionIdCounter, chunkStreamInfo);
        invoke.getHeader().setMessageStreamId(0);
        AmfObject args = new AmfObject();
        args.setProperty("app", this.appName + user);
        args.setProperty("flashVer", "FMLE/3.0 (compatible; Lavf57.56.101)");
        args.setProperty("swfUrl", this.swfUrl);
        args.setProperty("tcUrl", this.tcUrl + user);
        args.setProperty("fpad", false);
        args.setProperty("capabilities", 239);
        args.setProperty("audioCodecs", 3191);
        args.setProperty("videoCodecs", 252);
        args.setProperty("videoFunction", 1);
        args.setProperty("pageUrl", this.pageUrl);
        args.setProperty("objectEncoding", 0);
        invoke.addData(args);
        this.sendRtmpPacket(invoke);
    }

    private String getAuthUserResult(String user, String password, String salt, String challenge, String opaque) {
        String challenge2 = String.format("%08x", new Random().nextInt());
        String response = Util.stringToMD5BASE64(user + salt + password);
        if (!opaque.isEmpty()) {
            response = response + opaque;
        } else if (!challenge.isEmpty()) {
            response = response + challenge;
        }
        response = Util.stringToMD5BASE64(response + challenge2);
        String result = "?authmod=adobe&user=" + user + "&challenge=" + challenge2 + "&response=" + response;
        if (!opaque.isEmpty()) {
            result = result + "&opaque=" + opaque;
        }
        return result;
    }

    @Override
    public boolean publish(String type) {
        if (type == null) {
            this.connectCheckerRtmp.onConnectionFailedRtmp("Null publish type");
            return false;
        }
        this.publishType = type;
        return this.createStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createStream() {
        if (!this.connected || this.currentStreamId != 0) {
            this.connectCheckerRtmp.onConnectionFailedRtmp("Create stream failed, connected= " + this.connected + ", StreamId= " + this.currentStreamId);
            return false;
        }
        this.netConnectionDescription = null;
        Log.d((String)TAG, (String)"createStream(): Sending releaseStream command...");
        Command releaseStream = new Command("releaseStream", ++this.transactionIdCounter);
        releaseStream.getHeader().setChunkStreamId(5);
        releaseStream.addData(new AmfNull());
        releaseStream.addData(this.streamName);
        this.sendRtmpPacket(releaseStream);
        Log.d((String)TAG, (String)"createStream(): Sending FCPublish command...");
        Command FCPublish = new Command("FCPublish", ++this.transactionIdCounter);
        FCPublish.getHeader().setChunkStreamId(5);
        FCPublish.addData(new AmfNull());
        FCPublish.addData(this.streamName);
        this.sendRtmpPacket(FCPublish);
        Log.d((String)TAG, (String)"createStream(): Sending createStream command...");
        ChunkStreamInfo chunkStreamInfo = this.rtmpSessionInfo.getChunkStreamInfo(3);
        Command createStream = new Command("createStream", ++this.transactionIdCounter, chunkStreamInfo);
        createStream.addData(new AmfNull());
        this.sendRtmpPacket(createStream);
        Object object = this.publishLock;
        synchronized (object) {
            try {
                this.publishLock.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.publishPermitted) {
            this.shutdown(true);
            if (this.netConnectionDescription != null && !this.netConnectionDescription.isEmpty()) {
                this.connectCheckerRtmp.onConnectionFailedRtmp(this.netConnectionDescription);
            } else {
                this.connectCheckerRtmp.onConnectionFailedRtmp("Error configure stream, publish permitted failed");
            }
        }
        return this.publishPermitted;
    }

    private void fmlePublish() {
        if (!this.connected || this.currentStreamId == 0) {
            Log.e((String)TAG, (String)"fmlePublish failed");
            return;
        }
        Log.d((String)TAG, (String)"fmlePublish(): Sending publish command...");
        Command publish = new Command("publish", ++this.transactionIdCounter);
        publish.getHeader().setChunkStreamId(5);
        publish.getHeader().setMessageStreamId(this.currentStreamId);
        publish.addData(new AmfNull());
        publish.addData(this.streamName);
        publish.addData(this.publishType);
        this.sendRtmpPacket(publish);
    }

    private void onMetaData() {
        if (!this.connected || this.currentStreamId == 0) {
            Log.e((String)TAG, (String)"onMetaData failed");
            return;
        }
        Log.d((String)TAG, (String)"onMetaData(): Sending empty onMetaData...");
        Data metadata = new Data("@setDataFrame");
        metadata.getHeader().setMessageStreamId(this.currentStreamId);
        metadata.addData("onMetaData");
        AmfMap ecmaArray = new AmfMap();
        ecmaArray.setProperty("duration", 0);
        ecmaArray.setProperty("width", this.videoWidth);
        ecmaArray.setProperty("height", this.videoHeight);
        ecmaArray.setProperty("videocodecid", 7);
        ecmaArray.setProperty("framerate", 30);
        ecmaArray.setProperty("videodatarate", 0);
        ecmaArray.setProperty("audiocodecid", 10);
        ecmaArray.setProperty("audiosamplerate", 44100);
        ecmaArray.setProperty("audiosamplesize", 16);
        ecmaArray.setProperty("audiodatarate", 0);
        ecmaArray.setProperty("stereo", true);
        ecmaArray.setProperty("filesize", 0);
        metadata.addData(ecmaArray);
        this.sendRtmpPacket(metadata);
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.closeStream();
        }
        this.shutdown(true);
    }

    private void closeStream() {
        if (!this.connected || this.currentStreamId == 0 || !this.publishPermitted) {
            Log.e((String)TAG, (String)"closeStream failed");
            return;
        }
        Log.d((String)TAG, (String)"closeStream(): setting current stream ID to 0");
        Command closeStream = new Command("closeStream", ++this.transactionIdCounter);
        closeStream.getHeader().setChunkStreamId(5);
        closeStream.getHeader().setMessageStreamId(this.currentStreamId);
        closeStream.addData(new AmfNull());
        this.sendRtmpPacket(closeStream);
    }

    private synchronized void shutdown(boolean r) {
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
            }
            catch (IOException | UnsupportedOperationException e) {
                Log.e((String)TAG, (String)"Shutdown socket", (Throwable)e);
            }
            if (this.rxPacketHandler != null) {
                this.rxPacketHandler.interrupt();
                try {
                    this.rxPacketHandler.join(100L);
                }
                catch (InterruptedException ie) {
                    this.rxPacketHandler.interrupt();
                }
                this.rxPacketHandler = null;
            }
            try {
                this.socket.close();
                Log.d((String)TAG, (String)"socket closed");
            }
            catch (IOException ex) {
                Log.e((String)TAG, (String)"shutdown(): failed to close socket", (Throwable)ex);
            }
        }
        if (r) {
            this.reset();
        }
    }

    private void reset() {
        this.connected = false;
        this.publishPermitted = false;
        this.netConnectionDescription = null;
        this.tcUrl = null;
        this.swfUrl = null;
        this.pageUrl = null;
        this.appName = null;
        this.streamName = null;
        this.publishType = null;
        this.currentStreamId = 0;
        this.transactionIdCounter = 0;
        this.socket = null;
        this.rtmpSessionInfo = null;
        this.user = null;
        this.password = null;
        this.salt = null;
        this.challenge = null;
        this.opaque = null;
    }

    @Override
    public void publishAudioData(byte[] data, int size, int dts) {
        if (data == null || data.length == 0 || dts < 0 || !this.connected || this.currentStreamId == 0 || !this.publishPermitted) {
            return;
        }
        Audio audio = new Audio();
        audio.setData(data, size);
        audio.getHeader().setAbsoluteTimestamp(dts);
        audio.getHeader().setMessageStreamId(this.currentStreamId);
        this.sendRtmpPacket(audio);
        this.bitrateManager.calculateBitrate(size * 8);
    }

    @Override
    public void publishVideoData(byte[] data, int size, int dts) {
        if (data == null || data.length == 0 || dts < 0 || !this.connected || this.currentStreamId == 0 || !this.publishPermitted) {
            return;
        }
        Video video = new Video();
        video.setData(data, size);
        video.getHeader().setAbsoluteTimestamp(dts);
        video.getHeader().setMessageStreamId(this.currentStreamId);
        this.sendRtmpPacket(video);
        this.bitrateManager.calculateBitrate(size * 8);
    }

    private void sendRtmpPacket(RtmpPacket rtmpPacket) {
        try {
            ChunkStreamInfo chunkStreamInfo = this.rtmpSessionInfo.getChunkStreamInfo(rtmpPacket.getHeader().getChunkStreamId());
            chunkStreamInfo.setPrevHeaderTx(rtmpPacket.getHeader());
            if (!(rtmpPacket instanceof Video) && !(rtmpPacket instanceof Audio)) {
                rtmpPacket.getHeader().setAbsoluteTimestamp((int)chunkStreamInfo.markAbsoluteTimestampTx());
            }
            rtmpPacket.writeTo(this.outputStream, this.rtmpSessionInfo.getTxChunkSize(), chunkStreamInfo);
            Log.d((String)TAG, (String)("wrote packet: " + rtmpPacket + ", size: " + rtmpPacket.getHeader().getPacketLength()));
            if (rtmpPacket instanceof Command) {
                this.rtmpSessionInfo.addInvokedCommand(((Command)rtmpPacket).getTransactionId(), ((Command)rtmpPacket).getCommandName());
            }
            this.outputStream.flush();
        }
        catch (IOException ioe) {
            this.connectCheckerRtmp.onConnectionFailedRtmp("Error send packet: " + ioe.getMessage());
            Log.e((String)TAG, (String)("Caught IOException during write loop, shutting down: " + ioe.getMessage()));
            Thread.currentThread().interrupt();
        }
    }

    private void handleRxPacketLoop() {
        block15: while (!Thread.interrupted()) {
            try {
                RtmpPacket rtmpPacket = this.rtmpDecoder.readPacket(this.inputStream);
                if (rtmpPacket == null) continue;
                switch (rtmpPacket.getHeader().getMessageType()) {
                    case ABORT: {
                        this.rtmpSessionInfo.getChunkStreamInfo(((Abort)rtmpPacket).getChunkStreamId()).clearStoredChunks();
                        continue block15;
                    }
                    case USER_CONTROL_MESSAGE: {
                        UserControl user = (UserControl)rtmpPacket;
                        switch (user.getType()) {
                            case STREAM_BEGIN: {
                                continue block15;
                            }
                            case PING_REQUEST: {
                                ChunkStreamInfo channelInfo = this.rtmpSessionInfo.getChunkStreamInfo(2);
                                Log.d((String)TAG, (String)"handleRxPacketLoop(): Sending PONG reply..");
                                UserControl pong = new UserControl(user, channelInfo);
                                this.sendRtmpPacket(pong);
                                continue block15;
                            }
                            case STREAM_EOF: {
                                Log.i((String)TAG, (String)"handleRxPacketLoop(): Stream EOF reached, closing RTMP writer...");
                                continue block15;
                            }
                        }
                        continue block15;
                    }
                    case WINDOW_ACKNOWLEDGEMENT_SIZE: {
                        WindowAckSize windowAckSize = (WindowAckSize)rtmpPacket;
                        int size = windowAckSize.getAcknowledgementWindowSize();
                        Log.d((String)TAG, (String)("handleRxPacketLoop(): Setting acknowledgement window size: " + size));
                        this.rtmpSessionInfo.setAcknowledgmentWindowSize(size);
                        continue block15;
                    }
                    case SET_PEER_BANDWIDTH: {
                        this.rtmpSessionInfo.setAcknowledgmentWindowSize(this.socket.getSendBufferSize());
                        int acknowledgementWindowsize = this.rtmpSessionInfo.getAcknowledgementWindowSize();
                        ChunkStreamInfo chunkStreamInfo = this.rtmpSessionInfo.getChunkStreamInfo(2);
                        Log.d((String)TAG, (String)("handleRxPacketLoop(): Send acknowledgement window size: " + acknowledgementWindowsize));
                        this.sendRtmpPacket(new WindowAckSize(acknowledgementWindowsize, chunkStreamInfo));
                        this.socket.setSendBufferSize(acknowledgementWindowsize);
                        continue block15;
                    }
                    case COMMAND_AMF0: {
                        this.handleRxInvoke((Command)rtmpPacket);
                        continue block15;
                    }
                }
                Log.w((String)TAG, (String)("handleRxPacketLoop(): Not handling unimplemented/unknown packet of type: " + (Object)((Object)rtmpPacket.getHeader().getMessageType())));
            }
            catch (EOFException eof) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                this.connectCheckerRtmp.onConnectionFailedRtmp("Error reading packet: " + e.getMessage());
                Log.e((String)TAG, (String)("Caught SocketException while reading/decoding packet, shutting down: " + e.getMessage()));
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleRxInvoke(Command invoke) {
        String commandName;
        switch (commandName = invoke.getCommandName()) {
            case "_error": {
                try {
                    String description = ((AmfString)((AmfObject)invoke.getData().get(1)).getProperty("description")).getValue();
                    Log.i((String)TAG, (String)description);
                    if (description.contains("reason=authfailed")) {
                        this.connectCheckerRtmp.onAuthErrorRtmp();
                        this.connected = false;
                        Object object = this.connectingLock;
                        synchronized (object) {
                            this.connectingLock.notifyAll();
                            return;
                        }
                    }
                    if (this.user != null && this.password != null && description.contains("challenge=") && description.contains("salt=")) {
                        this.onAuth = true;
                        try {
                            this.shutdown(false);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        this.rtmpSessionInfo = new RtmpSessionInfo();
                        this.rtmpDecoder = new RtmpDecoder(this.rtmpSessionInfo);
                        if (!this.tlsEnabled) {
                            this.socket = new Socket(this.host, this.port);
                        } else {
                            this.socket = CreateSSLSocket.createSSlSocket(this.host, this.port);
                            if (this.socket == null) {
                                throw new IOException("Socket creation failed");
                            }
                        }
                        this.inputStream = new BufferedInputStream(this.socket.getInputStream());
                        this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
                        Log.d((String)TAG, (String)"connect(): socket connection established, doing handshake...");
                        this.salt = Util.getSalt(description);
                        this.challenge = Util.getChallenge(description);
                        this.opaque = Util.getOpaque(description);
                        this.handshake(this.inputStream, this.outputStream);
                        this.rxPacketHandler = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                RtmpConnection.this.handleRxPacketLoop();
                            }
                        });
                        this.rxPacketHandler.start();
                        this.sendConnect(this.getAuthUserResult(this.user, this.password, this.salt, this.challenge, this.opaque));
                        return;
                    }
                    if (description.contains("code=403") && this.user == null || this.password == null) {
                        this.connectCheckerRtmp.onAuthErrorRtmp();
                        this.connected = false;
                        Object e2 = this.connectingLock;
                        synchronized (e2) {
                            this.connectingLock.notifyAll();
                            return;
                        }
                    }
                    this.connectCheckerRtmp.onConnectionFailedRtmp(description);
                    this.connected = false;
                    Object e2 = this.connectingLock;
                    synchronized (e2) {
                        this.connectingLock.notifyAll();
                        return;
                    }
                }
                catch (Exception e) {
                    this.connectCheckerRtmp.onConnectionFailedRtmp(e.getMessage());
                    this.connected = false;
                    Object e2 = this.connectingLock;
                    synchronized (e2) {
                        this.connectingLock.notifyAll();
                        return;
                    }
                }
            }
            case "_result": {
                String method = this.rtmpSessionInfo.takeInvokedCommand(invoke.getTransactionId());
                Log.i((String)TAG, (String)("handleRxInvoke: Got result for invoked method: " + method));
                if ("connect".equals(method)) {
                    if (this.onAuth) {
                        this.connectCheckerRtmp.onAuthSuccessRtmp();
                        this.onAuth = false;
                    }
                    this.connected = true;
                    Object e2 = this.connectingLock;
                    synchronized (e2) {
                        this.connectingLock.notifyAll();
                        return;
                    }
                }
                if ("createStream".contains(method)) {
                    this.currentStreamId = (int)((AmfNumber)invoke.getData().get(1)).getValue();
                    Log.d((String)TAG, (String)("handleRxInvoke(): Stream ID to publish: " + this.currentStreamId));
                    if (this.streamName == null || this.publishType == null) return;
                    this.fmlePublish();
                    return;
                }
                if ("releaseStream".contains(method)) {
                    Log.d((String)TAG, (String)"handleRxInvoke(): 'releaseStream'");
                    return;
                }
                if ("FCPublish".contains(method)) {
                    Log.d((String)TAG, (String)"handleRxInvoke(): 'FCPublish'");
                    return;
                }
                Log.w((String)TAG, (String)("handleRxInvoke(): '_result' message received for unknown method: " + method));
                return;
            }
            case "onBWDone": {
                Log.d((String)TAG, (String)"handleRxInvoke(): 'onBWDone'");
                return;
            }
            case "onFCPublish": {
                Log.d((String)TAG, (String)"handleRxInvoke(): 'onFCPublish'");
                return;
            }
            case "onStatus": {
                String code = ((AmfString)((AmfObject)invoke.getData().get(1)).getProperty("code")).getValue();
                Log.d((String)TAG, (String)("handleRxInvoke(): onStatus " + code));
                switch (code) {
                    case "NetStream.Publish.Start": {
                        this.onMetaData();
                        this.publishPermitted = true;
                        Object object = this.publishLock;
                        synchronized (object) {
                            this.publishLock.notifyAll();
                            return;
                        }
                    }
                    case "NetConnection.Connect.Rejected": {
                        this.netConnectionDescription = ((AmfString)((AmfObject)invoke.getData().get(1)).getProperty("description")).getValue();
                        this.publishPermitted = false;
                        Object object = this.publishLock;
                        synchronized (object) {
                            this.publishLock.notifyAll();
                            return;
                        }
                    }
                    case "NetStream.Unpublish.Success": {
                        this.connectCheckerRtmp.onConnectionFailedRtmp("Unpublish received");
                    }
                }
                return;
            }
            default: {
                Log.e((String)TAG, (String)("handleRxInvoke(): Unknown/unhandled server invoke: " + invoke));
            }
        }
    }

    @Override
    public void setVideoResolution(int width, int height) {
        this.videoWidth = width;
        this.videoHeight = height;
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.user = user;
        this.password = password;
    }
}

