/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.amf;

import com.github.faucamp.simplertmp.amf.AmfArray;
import com.github.faucamp.simplertmp.amf.AmfBoolean;
import com.github.faucamp.simplertmp.amf.AmfData;
import com.github.faucamp.simplertmp.amf.AmfMap;
import com.github.faucamp.simplertmp.amf.AmfNull;
import com.github.faucamp.simplertmp.amf.AmfNumber;
import com.github.faucamp.simplertmp.amf.AmfObject;
import com.github.faucamp.simplertmp.amf.AmfString;
import com.github.faucamp.simplertmp.amf.AmfType;
import com.github.faucamp.simplertmp.amf.AmfUndefined;
import java.io.IOException;
import java.io.InputStream;

public class AmfDecoder {
    public static AmfData readFrom(InputStream in) throws IOException {
        AmfData amfData;
        block11: {
            block10: {
                byte amfTypeByte = (byte)in.read();
                AmfType amfType = AmfType.valueOf(amfTypeByte);
                if (amfType == null) break block10;
                switch (amfType) {
                    case NUMBER: {
                        amfData = new AmfNumber();
                        break block11;
                    }
                    case BOOLEAN: {
                        amfData = new AmfBoolean();
                        break block11;
                    }
                    case STRING: {
                        amfData = new AmfString();
                        break block11;
                    }
                    case OBJECT: {
                        amfData = new AmfObject();
                        break block11;
                    }
                    case NULL: {
                        return new AmfNull();
                    }
                    case UNDEFINED: {
                        return new AmfUndefined();
                    }
                    case ECMA_MAP: {
                        amfData = new AmfMap();
                        break block11;
                    }
                    case STRICT_ARRAY: {
                        amfData = new AmfArray();
                        break block11;
                    }
                    default: {
                        throw new IOException("Unknown/unimplemented AMF data type: " + (Object)((Object)amfType));
                    }
                }
            }
            throw new IOException("Unknown AMF data type");
        }
        amfData.readFrom(in);
        return amfData;
    }
}

