/*
 * Decompiled with CFR 0.152.
 */
package net.ossrs.rtmp;

import net.ossrs.rtmp.ConnectCheckerRtmp;

public class BitrateManager {
    private long bitrate;
    private long timeStamp = System.currentTimeMillis();
    private ConnectCheckerRtmp connectCheckerRtmp;

    public BitrateManager(ConnectCheckerRtmp connectCheckerRtsp) {
        this.connectCheckerRtmp = connectCheckerRtsp;
    }

    public synchronized void calculateBitrate(long size) {
        this.bitrate += size;
        long timeDiff = System.currentTimeMillis() - this.timeStamp;
        if (timeDiff >= 1000L) {
            this.connectCheckerRtmp.onNewBitrateRtmp(this.bitrate / (timeDiff / 1000L));
            this.timeStamp = System.currentTimeMillis();
            this.bitrate = 0L;
        }
    }
}

