/*
 * Decompiled with CFR 0.152.
 */
package net.ossrs.rtmp;

import android.media.MediaCodec;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import com.github.faucamp.simplertmp.DefaultRtmpPublisher;
import com.github.faucamp.simplertmp.RtmpPublisher;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.ossrs.rtmp.ConnectCheckerRtmp;
import net.ossrs.rtmp.SrsAllocator;

public class SrsFlvMuxer {
    private static final String TAG = "SrsFlvMuxer";
    private static final int VIDEO_ALLOC_SIZE = 131072;
    private static final int AUDIO_ALLOC_SIZE = 4096;
    private volatile boolean connected = false;
    private RtmpPublisher publisher;
    private Thread worker;
    private SrsFlv flv = new SrsFlv();
    private boolean needToFindKeyFrame = true;
    private SrsFlvFrame mVideoSequenceHeader;
    private SrsFlvFrame mAudioSequenceHeader;
    private SrsAllocator mVideoAllocator = new SrsAllocator(131072);
    private SrsAllocator mAudioAllocator = new SrsAllocator(4096);
    private volatile BlockingQueue<SrsFlvFrame> mFlvTagCache = new LinkedBlockingQueue<SrsFlvFrame>(30);
    private ConnectCheckerRtmp connectCheckerRtmp;
    private int sampleRate = 0;
    private boolean isPpsSpsSend = false;
    private byte profileIop = 0;
    private String url;
    private int numRetry;
    private int reTries;
    private Handler handler;
    private Runnable runnable;
    private long mAudioFramesSent = 0L;
    private long mVideoFramesSent = 0L;
    private long mDroppedAudioFrames = 0L;
    private long mDroppedVideoFrames = 0L;

    public SrsFlvMuxer(ConnectCheckerRtmp connectCheckerRtmp, RtmpPublisher publisher) {
        this.connectCheckerRtmp = connectCheckerRtmp;
        this.publisher = publisher;
        this.handler = new Handler(Looper.getMainLooper());
    }

    public SrsFlvMuxer(ConnectCheckerRtmp connectCheckerRtmp) {
        this(connectCheckerRtmp, new DefaultRtmpPublisher(connectCheckerRtmp));
    }

    public void setProfileIop(byte profileIop) {
        this.profileIop = profileIop;
    }

    public void setSpsPPs(ByteBuffer sps, ByteBuffer pps) {
        this.flv.setSpsPPs(sps, pps);
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void setIsStereo(boolean isStereo) {
        int channel = isStereo ? 2 : 1;
        this.flv.setAchannel(channel);
    }

    public void setAuthorization(String user, String password) {
        this.publisher.setAuthorization(user, password);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void resizeFlvTagCache(int newSize) {
        if (newSize < this.mFlvTagCache.size() - this.mFlvTagCache.remainingCapacity()) {
            throw new RuntimeException("Can't fit current cache inside new cache size");
        }
        LinkedBlockingQueue<SrsFlvFrame> tempQueue = new LinkedBlockingQueue<SrsFlvFrame>(newSize);
        this.mFlvTagCache.drainTo(tempQueue);
        this.mFlvTagCache = tempQueue;
    }

    public int getFlvTagCacheSize() {
        return this.mFlvTagCache.size();
    }

    public long getSentAudioFrames() {
        return this.mAudioFramesSent;
    }

    public long getSentVideoFrames() {
        return this.mVideoFramesSent;
    }

    public long getDroppedAudioFrames() {
        return this.mDroppedAudioFrames;
    }

    public long getDroppedVideoFrames() {
        return this.mDroppedVideoFrames;
    }

    public void resetSentAudioFrames() {
        this.mAudioFramesSent = 0L;
    }

    public void resetSentVideoFrames() {
        this.mVideoFramesSent = 0L;
    }

    public void resetDroppedAudioFrames() {
        this.mDroppedAudioFrames = 0L;
    }

    public void resetDroppedVideoFrames() {
        this.mDroppedVideoFrames = 0L;
    }

    public void setVideoResolution(int width, int height) {
        this.publisher.setVideoResolution(width, height);
    }

    private void disconnect(ConnectCheckerRtmp connectChecker) {
        try {
            this.publisher.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.connected = false;
        this.mVideoSequenceHeader = null;
        this.mAudioSequenceHeader = null;
        this.resetSentAudioFrames();
        this.resetSentVideoFrames();
        this.resetDroppedAudioFrames();
        this.resetDroppedVideoFrames();
        if (connectChecker != null) {
            this.reTries = 0;
            connectChecker.onDisconnectRtmp();
        }
        Log.i((String)TAG, (String)"worker: disconnect ok.");
    }

    public void setReTries(int reTries) {
        this.numRetry = reTries;
        this.reTries = reTries;
    }

    public boolean shouldRetry(String reason) {
        boolean validReason = !reason.contains("Endpoint malformed");
        return validReason && this.reTries > 0;
    }

    public void reConnect(long delay) {
        --this.reTries;
        this.stop(null);
        this.runnable = new Runnable(){

            @Override
            public void run() {
                SrsFlvMuxer.this.start(SrsFlvMuxer.this.url);
            }
        };
        this.handler.postDelayed(this.runnable, delay);
    }

    private boolean connect(String url) {
        this.url = url;
        if (!this.connected) {
            Log.i((String)TAG, (String)String.format("worker: connecting to RTMP server by url=%s\n", url));
            if (this.publisher.connect(url)) {
                this.connected = this.publisher.publish("live");
            }
            this.mVideoSequenceHeader = null;
            this.mAudioSequenceHeader = null;
        }
        return this.connected;
    }

    private void sendFlvTag(SrsFlvFrame frame) {
        if (!this.connected || frame == null) {
            return;
        }
        if (frame.is_video()) {
            if (frame.is_keyframe()) {
                Log.i((String)TAG, (String)String.format("worker: send frame type=%d, dts=%d, size=%dB", frame.type, frame.dts, frame.flvTag.array().length));
            }
            this.publisher.publishVideoData(frame.flvTag.array(), frame.flvTag.size(), frame.dts);
            this.mVideoAllocator.release(frame.flvTag);
            ++this.mVideoFramesSent;
        } else if (frame.is_audio()) {
            this.publisher.publishAudioData(frame.flvTag.array(), frame.flvTag.size(), frame.dts);
            this.mAudioAllocator.release(frame.flvTag);
            ++this.mAudioFramesSent;
        }
    }

    public void start(final String rtmpUrl) {
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)-1);
                if (!SrsFlvMuxer.this.connect(rtmpUrl)) {
                    return;
                }
                SrsFlvMuxer.this.reTries = SrsFlvMuxer.this.numRetry;
                SrsFlvMuxer.this.connectCheckerRtmp.onConnectionSuccessRtmp();
                while (!Thread.interrupted()) {
                    try {
                        SrsFlvFrame frame = (SrsFlvFrame)SrsFlvMuxer.this.mFlvTagCache.poll(1L, TimeUnit.SECONDS);
                        if (frame == null) {
                            Log.i((String)SrsFlvMuxer.TAG, (String)"Skipping iteration, frame null");
                            continue;
                        }
                        if (frame.is_sequenceHeader()) {
                            if (frame.is_video()) {
                                SrsFlvMuxer.this.mVideoSequenceHeader = frame;
                                SrsFlvMuxer.this.sendFlvTag(SrsFlvMuxer.this.mVideoSequenceHeader);
                                continue;
                            }
                            if (!frame.is_audio()) continue;
                            SrsFlvMuxer.this.mAudioSequenceHeader = frame;
                            SrsFlvMuxer.this.sendFlvTag(SrsFlvMuxer.this.mAudioSequenceHeader);
                            continue;
                        }
                        if (frame.is_video() && SrsFlvMuxer.this.mVideoSequenceHeader != null) {
                            SrsFlvMuxer.this.sendFlvTag(frame);
                            continue;
                        }
                        if (!frame.is_audio() || SrsFlvMuxer.this.mAudioSequenceHeader == null) continue;
                        SrsFlvMuxer.this.sendFlvTag(frame);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        this.worker.start();
    }

    public void stop() {
        this.stop(this.connectCheckerRtmp);
    }

    private void stop(final ConnectCheckerRtmp connectCheckerRtmp) {
        this.handler.removeCallbacks(this.runnable);
        if (this.worker != null) {
            this.worker.interrupt();
            try {
                this.worker.join(100L);
            }
            catch (InterruptedException e) {
                this.worker.interrupt();
            }
            this.worker = null;
        }
        this.mFlvTagCache.clear();
        this.flv.reset();
        this.needToFindKeyFrame = true;
        Log.i((String)TAG, (String)"SrsFlvMuxer closed");
        new Thread(new Runnable(){

            @Override
            public void run() {
                SrsFlvMuxer.this.disconnect(connectCheckerRtmp);
            }
        }).start();
    }

    public void sendVideo(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        this.flv.writeVideoSample(byteBuffer, bufferInfo);
    }

    public void sendAudio(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        this.flv.writeAudioSample(byteBuffer, bufferInfo);
    }

    private class SrsFlv {
        private SrsRawH264Stream avc;
        private ArrayList<SrsFlvFrameBytes> ipbs;
        private SrsAllocator.Allocation audio_tag;
        private SrsAllocator.Allocation video_tag;
        private ByteBuffer Sps;
        private ByteBuffer Pps;
        private boolean aac_specific_config_got;
        private int achannel;

        public SrsFlv() {
            this.avc = new SrsRawH264Stream();
            this.ipbs = new ArrayList();
            this.reset();
        }

        public void setAchannel(int achannel) {
            this.achannel = achannel;
        }

        public void reset() {
            this.Sps = null;
            this.Pps = null;
            SrsFlvMuxer.this.isPpsSpsSend = false;
            this.aac_specific_config_got = false;
        }

        public void writeAudioSample(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            int dts = (int)(bi.presentationTimeUs / 1000L);
            this.audio_tag = SrsFlvMuxer.this.mAudioAllocator.allocate(bi.size + 2);
            byte aac_packet_type = 1;
            if (!this.aac_specific_config_got) {
                int samplingFrequencyIndex;
                byte ch = (byte)(bi.flags == 2 ? bb.get(0) & 0xF8 : (bb.get(0) & 0xF8) / 2);
                switch (SrsFlvMuxer.this.sampleRate) {
                    case 96000: {
                        samplingFrequencyIndex = 0;
                        break;
                    }
                    case 88200: {
                        samplingFrequencyIndex = 1;
                        break;
                    }
                    case 64000: {
                        samplingFrequencyIndex = 2;
                        break;
                    }
                    case 48000: {
                        samplingFrequencyIndex = 3;
                        break;
                    }
                    case 44100: {
                        samplingFrequencyIndex = 4;
                        break;
                    }
                    case 32000: {
                        samplingFrequencyIndex = 5;
                        break;
                    }
                    case 24000: {
                        samplingFrequencyIndex = 6;
                        break;
                    }
                    case 22050: {
                        samplingFrequencyIndex = 7;
                        break;
                    }
                    case 16000: {
                        samplingFrequencyIndex = 8;
                        break;
                    }
                    case 12000: {
                        samplingFrequencyIndex = 9;
                        break;
                    }
                    case 11025: {
                        samplingFrequencyIndex = 10;
                        break;
                    }
                    default: {
                        samplingFrequencyIndex = 4;
                    }
                }
                ch = (byte)(ch | samplingFrequencyIndex >> 1 & 7);
                this.audio_tag.put(ch, 2);
                ch = (byte)(samplingFrequencyIndex << 7 & 0x80);
                int channelConfiguration = 1;
                if (this.achannel == 2) {
                    channelConfiguration = 2;
                }
                ch = (byte)(ch | channelConfiguration << 3 & 0x78);
                this.audio_tag.put(ch, 3);
                this.aac_specific_config_got = true;
                aac_packet_type = 0;
                this.writeAdtsHeader(this.audio_tag.array(), 4);
                this.audio_tag.appendOffset(7);
            } else {
                bb.get(this.audio_tag.array(), 2, bi.size);
                this.audio_tag.appendOffset(bi.size + 2);
            }
            int sound_format = 10;
            boolean sound_type = false;
            if (this.achannel == 2) {
                sound_type = true;
            }
            int sound_size = 1;
            int sound_rate = 3;
            if (SrsFlvMuxer.this.sampleRate == 22050) {
                sound_rate = 2;
            } else if (SrsFlvMuxer.this.sampleRate == 11025) {
                sound_rate = 1;
            }
            byte audio_header = (byte)((sound_type ? 1 : 0) & 1);
            audio_header = (byte)(audio_header | sound_size << 1 & 2);
            audio_header = (byte)(audio_header | sound_rate << 2 & 0xC);
            audio_header = (byte)(audio_header | sound_format << 4 & 0xF0);
            this.audio_tag.put(audio_header, 0);
            this.audio_tag.put(aac_packet_type, 1);
            this.writeRtmpPacket(8, dts, 0, aac_packet_type, this.audio_tag);
        }

        private void writeAdtsHeader(byte[] frame, int offset) {
            frame[offset] = -1;
            frame[offset + 1] = -16;
            int n = offset + 1;
            frame[n] = (byte)(frame[n] | 0);
            int n2 = offset + 1;
            frame[n2] = (byte)(frame[n2] | 0);
            int n3 = offset + 1;
            frame[n3] = (byte)(frame[n3] | 1);
            frame[offset + 2] = 64;
            int n4 = offset + 2;
            frame[n4] = (byte)(frame[n4] | 0x10);
            int n5 = offset + 2;
            frame[n5] = (byte)(frame[n5] | 0);
            frame[offset + 3] = -128;
            int n6 = offset + 3;
            frame[n6] = (byte)(frame[n6] | 0);
            int n7 = offset + 3;
            frame[n7] = (byte)(frame[n7] | 0);
            int n8 = offset + 3;
            frame[n8] = (byte)(frame[n8] | 0);
            int n9 = offset + 3;
            frame[n9] = (byte)(frame[n9] | 0);
            int n10 = offset + 3;
            frame[n10] = (byte)(frame[n10] | (frame.length - 2 & 0x1800) >> 11);
            frame[offset + 4] = (byte)((frame.length - 2 & 0x7F8) >> 3);
            frame[offset + 5] = (byte)((frame.length - 2 & 7) << 5);
            int n11 = offset + 5;
            frame[n11] = (byte)(frame[n11] | 0x1F);
            frame[offset + 6] = -4;
            int n12 = offset + 6;
            frame[n12] = (byte)(frame[n12] | 0);
        }

        public void writeVideoSample(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            if (bi.size < 4) {
                return;
            }
            bb.rewind();
            int pts = (int)(bi.presentationTimeUs / 1000L);
            int type = 2;
            SrsFlvFrameBytes frame = this.avc.demuxAnnexb(bb, bi.size, true);
            int nal_unit_type = frame.data.get(0) & 0x1F;
            if (nal_unit_type == 5 || bi.flags == 1) {
                type = 1;
            } else {
                if (nal_unit_type == 7 || nal_unit_type == 8) {
                    SrsFlvFrameBytes frame_pps = this.avc.demuxAnnexb(bb, bi.size, false);
                    frame.size = frame.size - frame_pps.size - 4;
                    if (!frame.data.equals(this.Sps)) {
                        byte[] sps = new byte[frame.size];
                        frame.data.get(sps);
                        SrsFlvMuxer.this.isPpsSpsSend = false;
                        this.Sps = ByteBuffer.wrap(sps);
                    }
                    SrsFlvFrameBytes frame_sei = this.avc.demuxAnnexb(bb, bi.size, false);
                    if (frame_sei.size > 0 && 6 == (frame_sei.data.get(0) & 0x1F)) {
                        frame_pps.size = frame_pps.size - frame_sei.size - 3;
                    }
                    if (frame_pps.size > 0 && !frame_pps.data.equals(this.Pps)) {
                        byte[] pps = new byte[frame_pps.size];
                        frame_pps.data.get(pps);
                        SrsFlvMuxer.this.isPpsSpsSend = false;
                        this.Pps = ByteBuffer.wrap(pps);
                        this.writeH264SpsPps(pts);
                    }
                    return;
                }
                if (nal_unit_type != 1) {
                    return;
                }
            }
            this.ipbs.add(this.avc.muxNaluHeader(frame));
            this.ipbs.add(frame);
            this.writeH264IpbFrame(this.ipbs, type, pts);
            this.ipbs.clear();
        }

        public void setSpsPPs(ByteBuffer sps, ByteBuffer pps) {
            this.Sps = sps;
            this.Pps = pps;
        }

        private void writeH264SpsPps(int pts) {
            if (this.Pps == null || this.Sps == null || SrsFlvMuxer.this.isPpsSpsSend) {
                return;
            }
            ArrayList<SrsFlvFrameBytes> frames = new ArrayList<SrsFlvFrameBytes>();
            this.avc.muxSequenceHeader(this.Sps, this.Pps, frames);
            int frame_type = 1;
            int avc_packet_type = 0;
            this.video_tag = this.avc.muxFlvTag(frames, frame_type, avc_packet_type);
            SrsFlvMuxer.this.isPpsSpsSend = true;
            this.writeRtmpPacket(9, pts, frame_type, avc_packet_type, this.video_tag);
            Log.i((String)SrsFlvMuxer.TAG, (String)String.format("flv: h264 sps/pps sent, sps=%dB, pps=%dB", this.Sps.array().length, this.Pps.array().length));
        }

        private void writeH264IpbFrame(ArrayList<SrsFlvFrameBytes> frames, int frame_type, int dts) {
            if (this.Pps == null || this.Sps == null) {
                return;
            }
            this.video_tag = this.avc.muxFlvTag(frames, frame_type, 1);
            this.writeRtmpPacket(9, dts, frame_type, 1, this.video_tag);
        }

        private void writeRtmpPacket(int type, int dts, int frame_type, int avc_aac_type, SrsAllocator.Allocation tag) {
            SrsFlvFrame frame = new SrsFlvFrame();
            frame.flvTag = tag;
            frame.type = type;
            frame.dts = dts;
            frame.frame_type = frame_type;
            frame.avc_aac_type = avc_aac_type;
            if (frame.is_video()) {
                if (SrsFlvMuxer.this.needToFindKeyFrame) {
                    if (frame.is_keyframe()) {
                        SrsFlvMuxer.this.needToFindKeyFrame = false;
                        this.flvFrameCacheAdd(frame);
                    }
                } else {
                    this.flvFrameCacheAdd(frame);
                }
            } else if (frame.is_audio()) {
                this.flvFrameCacheAdd(frame);
            }
        }

        private void flvFrameCacheAdd(SrsFlvFrame frame) {
            try {
                SrsFlvMuxer.this.mFlvTagCache.add(frame);
            }
            catch (IllegalStateException e) {
                Log.i((String)SrsFlvMuxer.TAG, (String)"frame discarded");
                if (frame.is_video()) {
                    SrsFlvMuxer.this.mDroppedVideoFrames++;
                }
                SrsFlvMuxer.this.mDroppedAudioFrames++;
            }
        }
    }

    private class SrsRawH264Stream {
        private static final String TAG = "SrsFlvMuxer";
        private SrsAnnexbSearch annexb;
        private SrsFlvFrameBytes nalu_header;
        private SrsFlvFrameBytes seq_hdr;
        private SrsFlvFrameBytes sps_hdr;
        private SrsFlvFrameBytes sps_bb;
        private SrsFlvFrameBytes pps_hdr;
        private SrsFlvFrameBytes pps_bb;

        private SrsRawH264Stream() {
            this.annexb = new SrsAnnexbSearch();
            this.nalu_header = new SrsFlvFrameBytes();
            this.seq_hdr = new SrsFlvFrameBytes();
            this.sps_hdr = new SrsFlvFrameBytes();
            this.sps_bb = new SrsFlvFrameBytes();
            this.pps_hdr = new SrsFlvFrameBytes();
            this.pps_bb = new SrsFlvFrameBytes();
        }

        public boolean isSps(SrsFlvFrameBytes frame) {
            return frame.size >= 1 && (frame.data.get(0) & 0x1F) == 7;
        }

        public boolean isPps(SrsFlvFrameBytes frame) {
            return frame.size >= 1 && (frame.data.get(0) & 0x1F) == 8;
        }

        public SrsFlvFrameBytes muxNaluHeader(SrsFlvFrameBytes frame) {
            if (this.nalu_header.data == null) {
                this.nalu_header.data = ByteBuffer.allocate(4);
                this.nalu_header.size = 4;
            }
            this.nalu_header.data.rewind();
            int NAL_unit_length = frame.size;
            this.nalu_header.data.putInt(NAL_unit_length);
            this.nalu_header.data.rewind();
            return this.nalu_header;
        }

        public void muxSequenceHeader(ByteBuffer sps, ByteBuffer pps, ArrayList<SrsFlvFrameBytes> frames) {
            if (this.seq_hdr.data == null) {
                this.seq_hdr.data = ByteBuffer.allocate(5);
                this.seq_hdr.size = 5;
            }
            this.seq_hdr.data.rewind();
            byte profile_idc = sps.get(1);
            byte level_idc = sps.get(3);
            this.seq_hdr.data.put((byte)1);
            this.seq_hdr.data.put(profile_idc);
            this.seq_hdr.data.put(SrsFlvMuxer.this.profileIop);
            this.seq_hdr.data.put(level_idc);
            this.seq_hdr.data.put((byte)3);
            this.seq_hdr.data.rewind();
            frames.add(this.seq_hdr);
            if (this.sps_hdr.data == null) {
                this.sps_hdr.data = ByteBuffer.allocate(3);
                this.sps_hdr.size = 3;
            }
            this.sps_hdr.data.rewind();
            this.sps_hdr.data.put((byte)1);
            this.sps_hdr.data.putShort((short)sps.array().length);
            this.sps_hdr.data.rewind();
            frames.add(this.sps_hdr);
            this.sps_bb.size = sps.array().length;
            this.sps_bb.data = sps.duplicate();
            frames.add(this.sps_bb);
            if (this.pps_hdr.data == null) {
                this.pps_hdr.data = ByteBuffer.allocate(3);
                this.pps_hdr.size = 3;
            }
            this.pps_hdr.data.rewind();
            this.pps_hdr.data.put((byte)1);
            this.pps_hdr.data.putShort((short)pps.array().length);
            this.pps_hdr.data.rewind();
            frames.add(this.pps_hdr);
            this.pps_bb.size = pps.array().length;
            this.pps_bb.data = pps.duplicate();
            frames.add(this.pps_bb);
        }

        public SrsAllocator.Allocation muxFlvTag(ArrayList<SrsFlvFrameBytes> frames, int frame_type, int avc_packet_type) {
            int size = 5;
            for (int i = 0; i < frames.size(); ++i) {
                size += frames.get((int)i).size;
            }
            SrsAllocator.Allocation allocation = SrsFlvMuxer.this.mVideoAllocator.allocate(size);
            allocation.put((byte)(frame_type << 4 | 7));
            allocation.put((byte)avc_packet_type);
            int cts = 0;
            allocation.put((byte)(cts >> 16));
            allocation.put((byte)(cts >> 8));
            allocation.put((byte)cts);
            for (int i = 0; i < frames.size(); ++i) {
                SrsFlvFrameBytes frame = frames.get(i);
                frame.data.rewind();
                frame.data.get(allocation.array(), allocation.size(), frame.size);
                allocation.appendOffset(frame.size);
            }
            return allocation;
        }

        private SrsAnnexbSearch searchStartcode(ByteBuffer bb, int size) {
            this.annexb.match = false;
            this.annexb.nb_start_code = 0;
            if (size - 4 > 0) {
                if (bb.get(0) == 0 && bb.get(1) == 0 && bb.get(2) == 0 && bb.get(3) == 1) {
                    this.annexb.match = true;
                    this.annexb.nb_start_code = 4;
                } else if (bb.get(0) == 0 && bb.get(1) == 0 && bb.get(2) == 1) {
                    this.annexb.match = true;
                    this.annexb.nb_start_code = 3;
                }
            }
            return this.annexb;
        }

        private SrsAnnexbSearch searchAnnexb(ByteBuffer bb, int size) {
            this.annexb.match = false;
            this.annexb.nb_start_code = 0;
            for (int i = bb.position(); i < size - 4; ++i) {
                if (bb.get(i) != 0 || bb.get(i + 1) != 0) continue;
                if (bb.get(i + 2) == 1) {
                    this.annexb.match = true;
                    this.annexb.nb_start_code = i + 3 - bb.position();
                    break;
                }
                if (bb.get(i + 2) != 0 || bb.get(i + 3) != 1) continue;
                this.annexb.match = true;
                this.annexb.nb_start_code = i + 4 - bb.position();
                break;
            }
            return this.annexb;
        }

        public SrsFlvFrameBytes demuxAnnexb(ByteBuffer bb, int size, boolean isOnlyChkHeader) {
            SrsFlvFrameBytes tbb = new SrsFlvFrameBytes();
            if (bb.position() < size - 4) {
                SrsAnnexbSearch tbbsc;
                SrsAnnexbSearch srsAnnexbSearch = tbbsc = isOnlyChkHeader ? this.searchStartcode(bb, size) : this.searchAnnexb(bb, size);
                if (!tbbsc.match || tbbsc.nb_start_code < 3) {
                    Log.e((String)"SrsFlvMuxer", (String)"annexb not match.");
                } else {
                    for (int i = 0; i < tbbsc.nb_start_code; ++i) {
                        bb.get();
                    }
                    tbb.data = bb.slice();
                    tbb.size = size - bb.position();
                }
            }
            return tbb;
        }
    }

    private class SrsFlvFrame {
        public SrsAllocator.Allocation flvTag;
        public int avc_aac_type;
        public int frame_type;
        public int type;
        public int dts;

        private SrsFlvFrame() {
        }

        public boolean is_keyframe() {
            return this.is_video() && this.frame_type == 1;
        }

        public boolean is_sequenceHeader() {
            return this.avc_aac_type == 0;
        }

        public boolean is_video() {
            return this.type == 9;
        }

        public boolean is_audio() {
            return this.type == 8;
        }
    }

    private class SrsFlvFrameBytes {
        public ByteBuffer data;
        public int size;

        private SrsFlvFrameBytes() {
        }
    }

    private class SrsAnnexbSearch {
        public int nb_start_code = 0;
        public boolean match = false;

        private SrsAnnexbSearch() {
        }
    }

    private class SrsAvcNaluType {
        public static final int Reserved = 0;
        public static final int NonIDR = 1;
        public static final int DataPartitionA = 2;
        public static final int DataPartitionB = 3;
        public static final int DataPartitionC = 4;
        public static final int IDR = 5;
        public static final int SEI = 6;
        public static final int SPS = 7;
        public static final int PPS = 8;
        public static final int AccessUnitDelimiter = 9;
        public static final int EOSequence = 10;
        public static final int EOStream = 11;
        public static final int FilterData = 12;
        public static final int SPSExt = 13;
        public static final int PrefixNALU = 14;
        public static final int SubsetSPS = 15;
        public static final int LayerWithoutPartition = 19;
        public static final int CodedSliceExt = 20;

        private SrsAvcNaluType() {
        }
    }

    private class SrsAacObjectType {
        public static final int AacLC = 2;

        private SrsAacObjectType() {
        }
    }

    private class SrsCodecVideo {
        public static final int AVC = 7;

        private SrsCodecVideo() {
        }
    }

    private class AudioSampleRate {
        public static final int R11025 = 11025;
        public static final int R12000 = 12000;
        public static final int R16000 = 16000;
        public static final int R22050 = 22050;
        public static final int R24000 = 24000;
        public static final int R32000 = 32000;
        public static final int R44100 = 44100;
        public static final int R48000 = 48000;
        public static final int R64000 = 64000;
        public static final int R88200 = 88200;
        public static final int R96000 = 96000;

        private AudioSampleRate() {
        }
    }

    private class SrsCodecFlvTag {
        public static final int Audio = 8;
        public static final int Video = 9;

        private SrsCodecFlvTag() {
        }
    }

    private class SrsCodecVideoAVCType {
        public static final int SequenceHeader = 0;
        public static final int NALU = 1;

        private SrsCodecVideoAVCType() {
        }
    }

    private class SrsCodecVideoAVCFrame {
        public static final int KeyFrame = 1;
        public static final int InterFrame = 2;

        private SrsCodecVideoAVCFrame() {
        }
    }
}

