/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.amf;

import com.github.faucamp.simplertmp.Util;
import com.github.faucamp.simplertmp.amf.AmfData;
import com.github.faucamp.simplertmp.amf.AmfObject;
import com.github.faucamp.simplertmp.amf.AmfString;
import com.github.faucamp.simplertmp.amf.AmfType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class AmfMap
extends AmfObject {
    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(AmfType.MAP.getValue());
        Util.writeUnsignedInt32(out, this.properties.size());
        for (Map.Entry entry : this.properties.entrySet()) {
            AmfString.writeStringTo(out, (String)entry.getKey(), true);
            ((AmfData)entry.getValue()).writeTo(out);
        }
        out.write(OBJECT_END_MARKER);
    }

    @Override
    public void readFrom(InputStream in) throws IOException {
        int length = Util.readUnsignedInt32(in);
        super.readFrom(in);
        this.size += 4;
    }

    @Override
    public int getSize() {
        if (this.size == -1) {
            this.size = super.getSize();
            this.size += 4;
        }
        return this.size;
    }
}

