/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.extrasources;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.Image;
import android.util.Range;
import android.util.Size;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import androidx.annotation.OptIn;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.Preview;
import androidx.camera.core.SurfaceOrientedMeteringPointFactory;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.ZoomState;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.core.resolutionselector.ResolutionStrategy;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import com.google.common.util.concurrent.ListenableFuture;
import com.pedro.encoder.input.sources.video.Camera2Source;
import com.pedro.encoder.input.sources.video.VideoSource;
import com.pedro.encoder.input.video.Camera2ApiManager;
import com.pedro.encoder.input.video.Camera2ResolutionCalculator;
import com.pedro.encoder.input.video.CameraHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0014J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020*H\u0016J\b\u0010.\u001a\u00020*H\u0016J\b\u0010/\u001a\u00020\u0019H\u0016J\u0006\u00100\u001a\u00020*J\u0010\u00101\u001a\u00020*2\u0006\u00102\u001a\u000203H\u0007J\u0006\u00104\u001a\u00020\u0013J\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020\u001f062\u0006\u0010\u0012\u001a\u000207J\u000e\u00108\u001a\u00020*2\u0006\u00109\u001a\u00020\u0013J\u0006\u0010:\u001a\u00020\u0013J\u0006\u0010;\u001a\u00020*J\u0006\u0010<\u001a\u00020*J\u0006\u0010=\u001a\u00020\u0019J\u0006\u0010>\u001a\u00020\u0019J\u0006\u0010?\u001a\u00020\u0019J\u0006\u0010@\u001a\u00020\u0019J\u0016\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EJ\u001a\u0010F\u001a\u00020*2\u0006\u0010D\u001a\u00020E2\b\b\u0002\u0010G\u001a\u00020\u001dH\u0007J\u000e\u0010F\u001a\u00020*2\u0006\u00109\u001a\u00020\u001dJ\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001d0IJ\u0006\u0010J\u001a\u00020\u001dJ\u0006\u0010K\u001a\u00020\u0019J\u0006\u0010L\u001a\u00020*J\u0006\u0010M\u001a\u00020\u0019J0\u0010N\u001a\u00020*2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010O\u001a\u00020\u00132\u0006\u0010P\u001a\u00020\u00192\u0006\u0010Q\u001a\u00020RH\u0007J\u0006\u0010S\u001a\u00020*J\u0006\u0010T\u001a\u00020\u0019J\u0006\u0010U\u001a\u00020*J\u0006\u0010V\u001a\u00020\u0019J\b\u0010W\u001a\u00020\u0013H\u0002J\u0010\u0010X\u001a\u00020*2\b\u0010Y\u001a\u0004\u0018\u00010\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006Z"}, d2={"Lcom/pedro/extrasources/CameraXSource;", "Lcom/pedro/encoder/input/sources/video/VideoSource;", "Landroidx/lifecycle/LifecycleOwner;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "lifecycleRegistry", "Landroidx/lifecycle/LifecycleRegistry;", "cameraProviderFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "cameraProvider", "camera", "Landroidx/camera/core/Camera;", "preview", "Landroidx/camera/core/Preview;", "Lorg/jspecify/annotations/NonNull;", "facing", "", "cameraSelectorBuilder", "Landroidx/camera/core/CameraSelector$Builder;", "surface", "Landroid/view/Surface;", "autoFocusEnabled", "", "autoExposureEnabled", "autoWhiteBalanceEnabled", "fingerSpacing", "", "requiredSize", "Landroid/util/Size;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "getLifecycle", "()Landroidx/lifecycle/Lifecycle;", "create", "width", "height", "fps", "rotation", "start", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "stop", "release", "isRunning", "switchCamera", "openCamera", "info", "Landroidx/camera/core/CameraInfo;", "getCameraFacing", "getCameraResolutions", "", "Lcom/pedro/encoder/input/video/CameraHelper$Facing;", "setExposure", "level", "getExposure", "enableLantern", "disableLantern", "isLanternEnabled", "enableAutoFocus", "disableAutoFocus", "isAutoFocusEnabled", "tapToFocus", "view", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "setZoom", "delta", "getZoomRange", "Landroid/util/Range;", "getZoom", "enableAutoExposure", "disableAutoExposure", "isAutoExposureEnabled", "addImageListener", "format", "autoClose", "listener", "Lcom/pedro/encoder/input/video/Camera2ApiManager$ImageCallback;", "removeImageListener", "enableAutoWhiteBalance", "disableAutoWhiteBalance", "isAutoWhiteBalanceEnabled", "getMeteringFlag", "setRequiredResolution", "size", "extra-sources_release"})
@SourceDebugExtension(value={"SMAP\nCameraXSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraXSource.kt\ncom/pedro/extrasources/CameraXSource\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,366:1\n37#2,2:367\n37#2,2:369\n37#2,2:371\n774#3:373\n865#3,2:374\n*S KotlinDebug\n*F\n+ 1 CameraXSource.kt\ncom/pedro/extrasources/CameraXSource\n*L\n77#1:367,2\n96#1:369,2\n288#1:371,2\n145#1:373\n145#1:374,2\n*E\n"})
public final class CameraXSource
extends VideoSource
implements LifecycleOwner {
    @NotNull
    private final Context context;
    @NotNull
    private final LifecycleRegistry lifecycleRegistry;
    @NotNull
    private final ListenableFuture<ProcessCameraProvider> cameraProviderFuture;
    @NotNull
    private final ProcessCameraProvider cameraProvider;
    @Nullable
    private Camera camera;
    @NotNull
    private Preview preview;
    private int facing;
    @NotNull
    private CameraSelector.Builder cameraSelectorBuilder;
    @Nullable
    private Surface surface;
    private boolean autoFocusEnabled;
    private boolean autoExposureEnabled;
    private boolean autoWhiteBalanceEnabled;
    private float fingerSpacing;
    @Nullable
    private Size requiredSize;
    @NotNull
    private final Lifecycle lifecycle;

    public CameraXSource(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.lifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);
        this.cameraProviderFuture = ProcessCameraProvider.Companion.getInstance(this.context);
        Object object = this.cameraProviderFuture.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.cameraProvider = (ProcessCameraProvider)object;
        Preview preview = new Preview.Builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)preview, (String)"build(...)");
        this.preview = preview;
        this.facing = 1;
        this.cameraSelectorBuilder = new CameraSelector.Builder();
        this.lifecycle = (Lifecycle)this.lifecycleRegistry;
    }

    @NotNull
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    protected boolean create(int width, int height, int fps, int rotation) {
        CameraHelper.Facing facing = this.facing == 1 ? CameraHelper.Facing.BACK : CameraHelper.Facing.FRONT;
        Size size = this.requiredSize;
        if (size == null) {
            Collection $this$toTypedArray$iv = this.getCameraResolutions(facing);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            size = Camera2ResolutionCalculator.INSTANCE.getOptimalResolution(new Size(width, height), thisCollection$iv.toArray(new Size[0]));
        }
        Size optimalResolution = size;
        Preview preview = new Preview.Builder().setTargetFrameRate(new Range((Comparable)Integer.valueOf(fps), (Comparable)Integer.valueOf(fps))).setResolutionSelector(new ResolutionSelector.Builder().setResolutionStrategy(new ResolutionStrategy(optimalResolution, 1)).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)preview, (String)"build(...)");
        this.preview = preview;
        this.lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
        return true;
    }

    public void start(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        CameraHelper.Facing facing = this.facing == 1 ? CameraHelper.Facing.BACK : CameraHelper.Facing.FRONT;
        Size size = this.requiredSize;
        if (size == null) {
            Collection $this$toTypedArray$iv = this.getCameraResolutions(facing);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            size = Camera2ResolutionCalculator.INSTANCE.getOptimalResolution(new Size(this.getWidth(), this.getHeight()), thisCollection$iv.toArray(new Size[0]));
        }
        Size optimalResolution = size;
        surfaceTexture.setDefaultBufferSize(optimalResolution.getWidth(), optimalResolution.getHeight());
        this.setSurfaceTexture(surfaceTexture);
        this.lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_START);
        CameraSelector cameraSelector = this.cameraSelectorBuilder.requireLensFacing(this.facing).build();
        Intrinsics.checkNotNullExpressionValue((Object)cameraSelector, (String)"build(...)");
        CameraSelector cameraSelector2 = cameraSelector;
        this.preview.setSurfaceProvider(arg_0 -> CameraXSource.start$lambda$0(surfaceTexture, this, arg_0));
        UseCase[] useCaseArray = new UseCase[]{this.preview};
        this.camera = this.cameraProvider.bindToLifecycle((LifecycleOwner)this, cameraSelector2, useCaseArray);
    }

    public void stop() {
        block1: {
            this.lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
            Camera camera = this.camera;
            if (camera == null) break block1;
            Camera it = camera;
            boolean bl = false;
            this.cameraProvider.unbindAll();
            this.camera = null;
            Surface surface = this.surface;
            if (surface != null) {
                surface.release();
            }
            this.surface = null;
        }
    }

    public void release() {
        this.lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
    }

    public boolean isRunning() {
        return this.camera != null;
    }

    public final void switchCamera() {
        block0: {
            SurfaceTexture surfaceTexture = this.getSurfaceTexture();
            if (surfaceTexture == null) break block0;
            SurfaceTexture it = surfaceTexture;
            boolean bl = false;
            this.stop();
            this.facing = this.facing == 1 ? 0 : 1;
            this.cameraSelectorBuilder = new CameraSelector.Builder();
            this.start(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public final void openCamera(@NotNull CameraInfo info) {
        block0: {
            void $this$openCamera_u24lambda_u240_u240;
            CameraSelector.Builder builder;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            SurfaceTexture surfaceTexture = this.getSurfaceTexture();
            if (surfaceTexture == null) break block0;
            SurfaceTexture surface = surfaceTexture;
            boolean bl = false;
            this.stop();
            this.facing = info.getLensFacing();
            CameraSelector.Builder builder2 = builder = new CameraSelector.Builder();
            CameraXSource cameraXSource = this;
            boolean bl2 = false;
            $this$openCamera_u24lambda_u240_u240.addCameraFilter(arg_0 -> CameraXSource.openCamera$lambda$0$0$0(info, arg_0));
            cameraXSource.cameraSelectorBuilder = builder;
            this.start(surface);
        }
    }

    public final int getCameraFacing() {
        return this.facing;
    }

    @NotNull
    public final List<Size> getCameraResolutions(@NotNull CameraHelper.Facing facing) {
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Camera2Source camera2 = new Camera2Source(this.context);
        return camera2.getCameraResolutions(facing);
    }

    public final void setExposure(int level) {
        block0: {
            Camera camera = this.camera;
            if (camera == null || (camera = camera.getCameraControl()) == null) break block0;
            camera.setExposureCompensationIndex(level);
        }
    }

    public final int getExposure() {
        Camera camera;
        return this.isRunning() ? ((camera = this.camera) != null && (camera = camera.getCameraInfo()) != null && (camera = camera.getExposureState()) != null ? camera.getExposureCompensationIndex() : 0) : 0;
    }

    public final void enableLantern() {
        block0: {
            Camera camera;
            if (!this.isRunning() || (camera = this.camera) == null || (camera = camera.getCameraControl()) == null) break block0;
            camera.enableTorch(true);
        }
    }

    public final void disableLantern() {
        block0: {
            Camera camera;
            if (!this.isRunning() || (camera = this.camera) == null || (camera = camera.getCameraControl()) == null) break block0;
            camera.enableTorch(false);
        }
    }

    public final boolean isLanternEnabled() {
        boolean bl;
        if (this.isRunning()) {
            Camera camera = this.camera;
            if (camera != null && (camera = camera.getCameraInfo()) != null && (camera = camera.getTorchState()) != null) {
                Integer n = (Integer)camera.getValue();
                int n2 = 1;
                bl = n != null && n == n2;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean enableAutoFocus() {
        if (this.isRunning()) {
            this.autoFocusEnabled = true;
            MeteringPoint meteringPoint = new SurfaceOrientedMeteringPointFactory(1.0f, 1.0f).createPoint(0.5f, 0.5f);
            Intrinsics.checkNotNullExpressionValue((Object)meteringPoint, (String)"createPoint(...)");
            MeteringPoint point = meteringPoint;
            FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(point, this.getMeteringFlag()).build();
            Intrinsics.checkNotNullExpressionValue((Object)focusMeteringAction, (String)"build(...)");
            FocusMeteringAction autoFocusAction = focusMeteringAction;
            Camera camera = this.camera;
            if (camera != null && (camera = camera.getCameraControl()) != null) {
                camera.startFocusAndMetering(autoFocusAction);
            }
            return true;
        }
        this.autoFocusEnabled = false;
        return false;
    }

    public final boolean disableAutoFocus() {
        if (this.isRunning()) {
            this.autoFocusEnabled = false;
            int flag = this.getMeteringFlag();
            if (flag != 0) {
                MeteringPoint meteringPoint = new SurfaceOrientedMeteringPointFactory(1.0f, 1.0f).createPoint(0.5f, 0.5f);
                Intrinsics.checkNotNullExpressionValue((Object)meteringPoint, (String)"createPoint(...)");
                MeteringPoint point = meteringPoint;
                FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(point, flag).build();
                Intrinsics.checkNotNullExpressionValue((Object)focusMeteringAction, (String)"build(...)");
                FocusMeteringAction autoFocusAction = focusMeteringAction;
                Camera camera = this.camera;
                if (camera != null && (camera = camera.getCameraControl()) != null) {
                    camera.startFocusAndMetering(autoFocusAction);
                }
            } else {
                Camera camera = this.camera;
                if (camera != null && (camera = camera.getCameraControl()) != null) {
                    camera.cancelFocusAndMetering();
                }
            }
            return true;
        }
        return false;
    }

    public final boolean isAutoFocusEnabled() {
        return this.autoFocusEnabled;
    }

    public final boolean tapToFocus(@NotNull View view, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isRunning()) {
            this.autoFocusEnabled = true;
            SurfaceOrientedMeteringPointFactory factory = new SurfaceOrientedMeteringPointFactory((float)view.getWidth(), (float)view.getHeight());
            MeteringPoint meteringPoint = factory.createPoint(event.getX(), event.getY());
            Intrinsics.checkNotNullExpressionValue((Object)meteringPoint, (String)"createPoint(...)");
            MeteringPoint autoFocusPoint = meteringPoint;
            FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(autoFocusPoint, this.getMeteringFlag()).build();
            Intrinsics.checkNotNullExpressionValue((Object)focusMeteringAction, (String)"build(...)");
            FocusMeteringAction autoFocusAction = focusMeteringAction;
            Camera camera = this.camera;
            if (camera != null && (camera = camera.getCameraControl()) != null) {
                camera.startFocusAndMetering(autoFocusAction);
            }
            return true;
        }
        this.autoFocusEnabled = false;
        return false;
    }

    @JvmOverloads
    public final void setZoom(@NotNull MotionEvent event, float delta) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isRunning()) {
            if (event.getPointerCount() < 2 || event.getAction() != 2) {
                return;
            }
            float currentFingerSpacing = CameraHelper.getFingerSpacing((MotionEvent)event);
            if (currentFingerSpacing > this.fingerSpacing) {
                float zoom = this.getZoom() + delta;
                Camera camera = this.camera;
                if (camera != null && (camera = camera.getCameraControl()) != null) {
                    camera.setZoomRatio(zoom);
                }
            } else if (currentFingerSpacing < this.fingerSpacing) {
                float zoom = this.getZoom() - delta;
                Camera camera = this.camera;
                if (camera != null && (camera = camera.getCameraControl()) != null) {
                    camera.setZoomRatio(zoom);
                }
            }
            this.fingerSpacing = currentFingerSpacing;
        }
    }

    public static /* synthetic */ void setZoom$default(CameraXSource cameraXSource, MotionEvent motionEvent, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.1f;
        }
        cameraXSource.setZoom(motionEvent, f);
    }

    public final void setZoom(float level) {
        block0: {
            Camera camera;
            if (!this.isRunning() || (camera = this.camera) == null || (camera = camera.getCameraControl()) == null) break block0;
            camera.setZoomRatio(level);
        }
    }

    @NotNull
    public final Range<Float> getZoomRange() {
        Camera camera = this.camera;
        if (camera == null || (camera = camera.getCameraInfo()) == null || (camera = camera.getZoomState()) == null || (camera = (ZoomState)camera.getValue()) == null) {
            return new Range((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(0.0f));
        }
        Camera zoomState = camera;
        return new Range((Comparable)Float.valueOf(zoomState.getMinZoomRatio()), (Comparable)Float.valueOf(zoomState.getMaxZoomRatio()));
    }

    public final float getZoom() {
        Camera camera = this.camera;
        return camera != null && (camera = camera.getCameraInfo()) != null && (camera = camera.getZoomState()) != null && (camera = (ZoomState)camera.getValue()) != null ? camera.getZoomRatio() : 0.0f;
    }

    public final boolean enableAutoExposure() {
        boolean bl;
        if (this.isRunning()) {
            this.autoExposureEnabled = true;
            MeteringPoint meteringPoint = new SurfaceOrientedMeteringPointFactory(1.0f, 1.0f).createPoint(0.5f, 0.5f);
            Intrinsics.checkNotNullExpressionValue((Object)meteringPoint, (String)"createPoint(...)");
            MeteringPoint point = meteringPoint;
            FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(point, this.getMeteringFlag()).build();
            Intrinsics.checkNotNullExpressionValue((Object)focusMeteringAction, (String)"build(...)");
            FocusMeteringAction autoFocusAction = focusMeteringAction;
            Camera camera = this.camera;
            if (camera != null && (camera = camera.getCameraControl()) != null) {
                camera.startFocusAndMetering(autoFocusAction);
            }
            bl = true;
        } else {
            this.autoExposureEnabled = false;
            bl = false;
        }
        return bl;
    }

    public final void disableAutoExposure() {
        block0: {
            block1: {
                if (!this.isRunning()) break block0;
                this.autoExposureEnabled = false;
                int flag = this.getMeteringFlag();
                if (flag == 0) break block1;
                MeteringPoint meteringPoint = new SurfaceOrientedMeteringPointFactory(1.0f, 1.0f).createPoint(0.5f, 0.5f);
                Intrinsics.checkNotNullExpressionValue((Object)meteringPoint, (String)"createPoint(...)");
                MeteringPoint point = meteringPoint;
                FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(point, flag).build();
                Intrinsics.checkNotNullExpressionValue((Object)focusMeteringAction, (String)"build(...)");
                FocusMeteringAction autoFocusAction = focusMeteringAction;
                Camera camera = this.camera;
                if (camera == null || (camera = camera.getCameraControl()) == null) break block0;
                camera.startFocusAndMetering(autoFocusAction);
                break block0;
            }
            Camera camera = this.camera;
            if (camera == null || (camera = camera.getCameraControl()) == null) break block0;
            camera.cancelFocusAndMetering();
        }
    }

    public final boolean isAutoExposureEnabled() {
        return this.autoExposureEnabled;
    }

    @OptIn(markerClass={ExperimentalGetImage.class})
    public final void addImageListener(int width, int height, int format, boolean autoClose, @NotNull Camera2ApiManager.ImageCallback listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        CameraHelper.Facing facing = this.facing == 1 ? CameraHelper.Facing.BACK : CameraHelper.Facing.FRONT;
        Collection $this$toTypedArray$iv = this.getCameraResolutions(facing);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Size optimalResolution = Camera2ResolutionCalculator.INSTANCE.getOptimalResolution(new Size(width, height), thisCollection$iv.toArray(new Size[0]));
        ImageAnalysis imageAnalysis = new ImageAnalysis.Builder().setResolutionSelector(new ResolutionSelector.Builder().setResolutionStrategy(new ResolutionStrategy(optimalResolution, 1)).build()).setBackpressureStrategy(1).setOutputImageFormat(format).build();
        Intrinsics.checkNotNullExpressionValue((Object)imageAnalysis, (String)"build(...)");
        ImageAnalysis imageAnalysis2 = imageAnalysis;
        CameraSelector cameraSelector = this.cameraSelectorBuilder.requireLensFacing(this.facing).build();
        Intrinsics.checkNotNullExpressionValue((Object)cameraSelector, (String)"build(...)");
        CameraSelector cameraSelector2 = cameraSelector;
        this.cameraProvider.unbindAll();
        UseCase[] useCaseArray = new UseCase[]{imageAnalysis2, this.preview};
        this.camera = this.cameraProvider.bindToLifecycle((LifecycleOwner)this, cameraSelector2, useCaseArray);
        imageAnalysis2.setAnalyzer((Executor)Executors.newSingleThreadExecutor(), arg_0 -> CameraXSource.addImageListener$lambda$0(listener, autoClose, arg_0));
    }

    public final void removeImageListener() {
        this.cameraProvider.unbindAll();
        CameraSelector cameraSelector = this.cameraSelectorBuilder.requireLensFacing(this.facing).build();
        Intrinsics.checkNotNullExpressionValue((Object)cameraSelector, (String)"build(...)");
        CameraSelector cameraSelector2 = cameraSelector;
        UseCase[] useCaseArray = new UseCase[]{this.preview};
        this.camera = this.cameraProvider.bindToLifecycle((LifecycleOwner)this, cameraSelector2, useCaseArray);
    }

    public final boolean enableAutoWhiteBalance() {
        boolean bl;
        if (this.isRunning()) {
            this.autoWhiteBalanceEnabled = true;
            MeteringPoint meteringPoint = new SurfaceOrientedMeteringPointFactory(1.0f, 1.0f).createPoint(0.5f, 0.5f);
            Intrinsics.checkNotNullExpressionValue((Object)meteringPoint, (String)"createPoint(...)");
            MeteringPoint point = meteringPoint;
            FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(point, this.getMeteringFlag()).build();
            Intrinsics.checkNotNullExpressionValue((Object)focusMeteringAction, (String)"build(...)");
            FocusMeteringAction autoFocusAction = focusMeteringAction;
            Camera camera = this.camera;
            if (camera != null && (camera = camera.getCameraControl()) != null) {
                camera.startFocusAndMetering(autoFocusAction);
            }
            bl = true;
        } else {
            this.autoWhiteBalanceEnabled = false;
            bl = false;
        }
        return bl;
    }

    public final void disableAutoWhiteBalance() {
        block0: {
            block1: {
                if (!this.isRunning()) break block0;
                this.autoWhiteBalanceEnabled = false;
                int flag = this.getMeteringFlag();
                if (flag == 0) break block1;
                MeteringPoint meteringPoint = new SurfaceOrientedMeteringPointFactory(1.0f, 1.0f).createPoint(0.5f, 0.5f);
                Intrinsics.checkNotNullExpressionValue((Object)meteringPoint, (String)"createPoint(...)");
                MeteringPoint point = meteringPoint;
                FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(point, flag).build();
                Intrinsics.checkNotNullExpressionValue((Object)focusMeteringAction, (String)"build(...)");
                FocusMeteringAction autoFocusAction = focusMeteringAction;
                Camera camera = this.camera;
                if (camera == null || (camera = camera.getCameraControl()) == null) break block0;
                camera.startFocusAndMetering(autoFocusAction);
                break block0;
            }
            Camera camera = this.camera;
            if (camera == null || (camera = camera.getCameraControl()) == null) break block0;
            camera.cancelFocusAndMetering();
        }
    }

    public final boolean isAutoWhiteBalanceEnabled() {
        return this.autoWhiteBalanceEnabled;
    }

    private final int getMeteringFlag() {
        int flags = 0;
        if (this.autoFocusEnabled) {
            flags |= 1;
        }
        if (this.autoExposureEnabled) {
            flags |= 2;
        }
        if (this.autoWhiteBalanceEnabled) {
            flags |= 4;
        }
        return flags;
    }

    public final void setRequiredResolution(@Nullable Size size) {
        this.requiredSize = size;
    }

    @JvmOverloads
    public final void setZoom(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CameraXSource.setZoom$default(this, event, 0.0f, 2, null);
    }

    private static final void start$lambda$0(SurfaceTexture $surfaceTexture, CameraXSource this$0, SurfaceRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Surface surface = new Surface($surfaceTexture);
        it.provideSurface(surface, (Executor)Executors.newSingleThreadExecutor(), CameraXSource::start$lambda$0$0);
        this$0.surface = surface;
    }

    private static final void start$lambda$0$0(SurfaceRequest.Result it) {
    }

    /*
     * WARNING - void declaration
     */
    private static final List openCamera$lambda$0$0$0(CameraInfo $info, List cameras) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cameras, (String)"cameras");
        Iterable $this$filter$iv = cameras;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CameraInfo it = (CameraInfo)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)$info)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void addImageListener$lambda$0(Camera2ApiManager.ImageCallback $listener, boolean $autoClose, ImageProxy proxy) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            Image image = proxy.getImage();
            if (image == null) break block1;
            Image it = image;
            boolean bl = false;
            $listener.onImageAvailable(it);
            if ($autoClose) {
                proxy.close();
            }
        }
    }
}

