/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.extrasources;

import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.util.UnstableApi;
import com.pedro.common.ExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/pedro/extrasources/AudioBufferProcessor;", "Landroidx/media3/common/audio/AudioProcessor;", "callback", "Lkotlin/Function1;", "", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "inputEnded", "", "configure", "Landroidx/media3/common/audio/AudioProcessor$AudioFormat;", "inputAudioFormat", "isActive", "queueInput", "inputBuffer", "Ljava/nio/ByteBuffer;", "queueEndOfStream", "getOutput", "isEnded", "flush", "reset", "extra-sources_release"})
@UnstableApi
public final class AudioBufferProcessor
implements AudioProcessor {
    @NotNull
    private final Function1<byte[], Unit> callback;
    private boolean inputEnded;

    public AudioBufferProcessor(@NotNull Function1<? super byte[], Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callback = callback;
    }

    @NotNull
    public AudioProcessor.AudioFormat configure(@NotNull AudioProcessor.AudioFormat inputAudioFormat) {
        AudioProcessor.AudioFormat audioFormat;
        Intrinsics.checkNotNullParameter((Object)inputAudioFormat, (String)"inputAudioFormat");
        if (inputAudioFormat.encoding == 2) {
            audioFormat = inputAudioFormat;
        } else {
            AudioProcessor.AudioFormat audioFormat2 = AudioProcessor.AudioFormat.NOT_SET;
            audioFormat = audioFormat2;
            Intrinsics.checkNotNullExpressionValue((Object)audioFormat2, (String)"NOT_SET");
        }
        return audioFormat;
    }

    public boolean isActive() {
        return true;
    }

    public void queueInput(@NotNull ByteBuffer inputBuffer) {
        Intrinsics.checkNotNullParameter((Object)inputBuffer, (String)"inputBuffer");
        this.callback.invoke((Object)ExtensionsKt.toByteArray((ByteBuffer)inputBuffer));
    }

    public void queueEndOfStream() {
        this.inputEnded = true;
    }

    @NotNull
    public ByteBuffer getOutput() {
        ByteBuffer byteBuffer = AudioProcessor.EMPTY_BUFFER;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"EMPTY_BUFFER");
        return byteBuffer;
    }

    public boolean isEnded() {
        return this.inputEnded;
    }

    public void flush() {
        this.inputEnded = false;
    }

    public void reset() {
        this.inputEnded = false;
    }
}

