/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Build;
import android.view.Surface;
import com.pedro.common.ExtensionsKt;
import com.pedro.encoder.input.decoder.BaseDecoder;
import com.pedro.encoder.input.decoder.DecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import java.nio.ByteBuffer;

public class VideoDecoder
extends BaseDecoder {
    private final VideoDecoderInterface videoDecoderInterface;
    private int width;
    private int height;
    private int fps;

    public VideoDecoder(VideoDecoderInterface videoDecoderInterface2, DecoderInterface decoderInterface2) {
        super(decoderInterface2);
        this.TAG = "VideoDecoder";
        this.videoDecoderInterface = videoDecoderInterface2;
    }

    @Override
    protected boolean extract(MediaExtractor videoExtractor) {
        for (int i = 0; i < videoExtractor.getTrackCount() && !this.mime.startsWith("video/"); ++i) {
            this.mediaFormat = videoExtractor.getTrackFormat(i);
            this.mime = this.mediaFormat.getString("mime");
            if (this.mime.startsWith("video/")) {
                videoExtractor.selectTrack(i);
                continue;
            }
            this.mediaFormat = null;
        }
        if (this.mediaFormat != null) {
            Integer width = ExtensionsKt.getIntegerSafe((MediaFormat)this.mediaFormat, (String)"width");
            Integer height = ExtensionsKt.getIntegerSafe((MediaFormat)this.mediaFormat, (String)"height");
            Long duration = ExtensionsKt.getLongSafe((MediaFormat)this.mediaFormat, (String)"durationUs");
            Integer fps = ExtensionsKt.getIntegerSafe((MediaFormat)this.mediaFormat, (String)"frame-rate");
            if (width == null || height == null) {
                return false;
            }
            this.width = width;
            this.height = height;
            this.duration = duration != null ? duration : -1L;
            this.fps = fps != null ? fps : 30;
            return true;
        }
        this.mime = "";
        return false;
    }

    public boolean prepareVideo(Surface surface) {
        return this.prepare(surface);
    }

    @Override
    protected boolean decodeOutput(ByteBuffer outputBuffer, long timeStamp) {
        return true;
    }

    @Override
    protected void finished() {
        this.videoDecoderInterface.onVideoDecoderFinished();
    }

    public void changeOutputSurface(Surface surface) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.codec.setOutputSurface(surface);
        } else {
            this.resetCodec(surface);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFps() {
        return this.fps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseRender() {
        Object object = this.sync;
        synchronized (object) {
            this.pause.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeRender() {
        Object object = this.sync;
        synchronized (object) {
            this.pause.set(false);
        }
    }
}

