/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.srt.packets;

import com.pedro.srt.srt.packets.ControlPacket;
import com.pedro.srt.srt.packets.DataPacket;
import com.pedro.srt.srt.packets.PacketType;
import com.pedro.srt.srt.packets.control.Ack;
import com.pedro.srt.srt.packets.control.Ack2;
import com.pedro.srt.srt.packets.control.CongestionWarning;
import com.pedro.srt.srt.packets.control.ControlType;
import com.pedro.srt.srt.packets.control.DropReq;
import com.pedro.srt.srt.packets.control.KeepAlive;
import com.pedro.srt.srt.packets.control.Nak;
import com.pedro.srt.srt.packets.control.PeerError;
import com.pedro.srt.srt.packets.control.Shutdown;
import com.pedro.srt.srt.packets.control.handshake.Handshake;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/pedro/srt/srt/packets/SrtPacket;", "", "<init>", "()V", "buffer", "Ljava/io/ByteArrayOutputStream;", "getBuffer", "()Ljava/io/ByteArrayOutputStream;", "setBuffer", "(Ljava/io/ByteArrayOutputStream;)V", "getData", "", "resetBuffer", "", "Companion", "srt_release"})
public abstract class SrtPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    public static final int headerSize = 16;

    @NotNull
    public final ByteArrayOutputStream getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@NotNull ByteArrayOutputStream byteArrayOutputStream) {
        Intrinsics.checkNotNullParameter((Object)byteArrayOutputStream, (String)"<set-?>");
        this.buffer = byteArrayOutputStream;
    }

    @NotNull
    public final byte[] getData() {
        byte[] byArray = this.buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public final void resetBuffer() {
        this.buffer = new ByteArrayOutputStream();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/pedro/srt/srt/packets/SrtPacket$Companion;", "", "<init>", "()V", "headerSize", "", "getSrtPacket", "Lcom/pedro/srt/srt/packets/SrtPacket;", "buffer", "", "srt_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SrtPacket getSrtPacket(@NotNull byte[] buffer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            PacketType packetType = PacketType.Companion.from(buffer[0] >>> 7 & 1);
            switch (WhenMappings.$EnumSwitchMapping$1[packetType.ordinal()]) {
                case 1: {
                    return new DataPacket(0, null, false, null, false, 0, 0, 0, null, 511, null);
                }
                case 2: {
                    byte[] headerData = ArraysKt.sliceArray((byte[])buffer, (IntRange)RangesKt.until((int)0, (int)4));
                    ControlType type = ControlPacket.Companion.getType(new ByteArrayInputStream(headerData));
                    ByteArrayInputStream input = new ByteArrayInputStream(buffer);
                    switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: {
                            Handshake handshake = new Handshake(0, null, 0, 0, 0, 0, null, 0, 0, null, null, 2047, null);
                            handshake.read(input);
                            return handshake;
                        }
                        case 2: {
                            KeepAlive keepAlive = new KeepAlive();
                            keepAlive.read(input);
                            return keepAlive;
                        }
                        case 3: {
                            Ack ack = new Ack(0, 0, 0, 0, 0, 0, 0, 127, null);
                            ack.read(input);
                            return ack;
                        }
                        case 4: {
                            Nak nak = new Nak();
                            nak.read(input);
                            return nak;
                        }
                        case 5: {
                            CongestionWarning congestionWarning = new CongestionWarning();
                            congestionWarning.read(input);
                            return congestionWarning;
                        }
                        case 6: {
                            Shutdown shutdown = new Shutdown();
                            shutdown.read(input);
                            return shutdown;
                        }
                        case 7: {
                            Ack2 ack2 = new Ack2(0, 1, null);
                            ack2.read(input);
                            return ack2;
                        }
                        case 8: {
                            DropReq dropReq = new DropReq(0, 0, 0, 7, null);
                            dropReq.read(input);
                            return dropReq;
                        }
                        case 9: {
                            PeerError peerError = new PeerError(0, 1, null);
                            peerError.read(input);
                            return peerError;
                        }
                        case 10: {
                            throw new IOException("user defined type is not allowed");
                        }
                    }
                    throw new IOException("unknown control type: " + type.name());
                }
            }
            throw new NoWhenBranchMatchedException();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[ControlType.values().length];
                try {
                    nArray[ControlType.HANDSHAKE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlType.KEEP_ALIVE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlType.ACK.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlType.NAK.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlType.CONGESTION_WARNING.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlType.SHUTDOWN.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlType.ACK2.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlType.DROP_REQ.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlType.PEER_ERROR.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlType.USER_DEFINED.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[PacketType.values().length];
                try {
                    nArray[PacketType.DATA.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PacketType.CONTROL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

