/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.psi;

import com.pedro.srt.mpeg2ts.Codec;
import com.pedro.srt.mpeg2ts.psi.Psi;
import com.pedro.srt.mpeg2ts.service.Mpeg2TsService;
import com.pedro.srt.mpeg2ts.service.Track;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/pedro/srt/mpeg2ts/psi/Pmt;", "Lcom/pedro/srt/mpeg2ts/psi/Psi;", "pid", "", "version", "", "service", "Lcom/pedro/srt/mpeg2ts/service/Mpeg2TsService;", "<init>", "(IBLcom/pedro/srt/mpeg2ts/service/Mpeg2TsService;)V", "reserved", "reserved2", "programInfoLengthUnused", "writeData", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "generateProgramDescriptor", "", "codec", "Lcom/pedro/srt/mpeg2ts/Codec;", "getTableDataSize", "srt_release"})
@SourceDebugExtension(value={"SMAP\nPmt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pmt.kt\ncom/pedro/srt/mpeg2ts/psi/Pmt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1869#2,2:111\n1869#2,2:113\n*S KotlinDebug\n*F\n+ 1 Pmt.kt\ncom/pedro/srt/mpeg2ts/psi/Pmt\n*L\n57#1:111,2\n103#1:113,2\n*E\n"})
public final class Pmt
extends Psi {
    @NotNull
    private final Mpeg2TsService service;
    private final byte reserved;
    private final byte reserved2;
    private final byte programInfoLengthUnused;

    public Pmt(int pid, byte version, @NotNull Mpeg2TsService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        super(pid, (byte)2, service.getId(), version, false, false, false, (byte)0, (byte)0, 496, null);
        this.service = service;
        this.reserved = (byte)7;
        this.reserved2 = (byte)15;
    }

    @Override
    public void writeData(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Number number = this.service.getPcrPid();
        if (number == null) {
            number = this.getPid();
        }
        byteBuffer.putShort((short)(this.reserved << 13 | ((Number)number).intValue()));
        byteBuffer.putShort((short)(this.reserved2 << 12 | this.programInfoLengthUnused << 10 | 0));
        Iterable $this$forEach$iv = this.service.getTracks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Track track = (Track)element$iv;
            boolean bl = false;
            byteBuffer.put(track.getCodec().getValue());
            byte[] programDescriptor = this.generateProgramDescriptor(track.getCodec());
            byteBuffer.putShort((short)(this.reserved << 13 | track.getPid()));
            byteBuffer.putShort((short)(this.reserved2 << 12 | this.programInfoLengthUnused << 10 | programDescriptor.length));
            byteBuffer.put(programDescriptor);
        }
    }

    private final byte[] generateProgramDescriptor(Codec codec) {
        return switch (WhenMappings.$EnumSwitchMapping$0[codec.ordinal()]) {
            case 1 -> {
                byte[] bytes = new byte[]{5, 4, 72, 69, 86, 67};
                yield bytes;
            }
            case 2 -> {
                void var2_3;
                byte[] bytes = new byte[]{5, 4, 79, 112, 117, 115, 127, 2, -128, 2};
                yield var2_3;
            }
            default -> new byte[]{};
        };
    }

    @Override
    public int getTableDataSize() {
        int size = 0;
        size = 4;
        Iterable $this$forEach$iv = this.service.getTracks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Track track = (Track)element$iv;
            boolean bl = false;
            size += 5;
            if (track.getCodec() == Codec.HEVC) {
                size += 6;
                continue;
            }
            if (track.getCodec() != Codec.OPUS) continue;
            size += 10;
        }
        return size;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Codec.values().length];
            try {
                nArray[Codec.HEVC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Codec.OPUS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

