/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.srt.packets;

import com.pedro.common.ExtensionsKt;
import com.pedro.srt.srt.packets.PacketType;
import com.pedro.srt.srt.packets.SrtPacket;
import com.pedro.srt.srt.packets.control.ControlType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000  2\u00020\u0001:\u0001 B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0004J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/pedro/srt/srt/packets/ControlPacket;", "Lcom/pedro/srt/srt/packets/SrtPacket;", "controlType", "Lcom/pedro/srt/srt/packets/control/ControlType;", "subtype", "typeSpecificInformation", "", "ts", "socketId", "<init>", "(Lcom/pedro/srt/srt/packets/control/ControlType;Lcom/pedro/srt/srt/packets/control/ControlType;III)V", "getControlType", "()Lcom/pedro/srt/srt/packets/control/ControlType;", "setControlType", "(Lcom/pedro/srt/srt/packets/control/ControlType;)V", "getSubtype", "setSubtype", "getTypeSpecificInformation", "()I", "setTypeSpecificInformation", "(I)V", "getTs", "setTs", "getSocketId", "setSocketId", "writeHeader", "", "readHeader", "input", "Ljava/io/InputStream;", "toString", "", "Companion", "srt_release"})
public abstract class ControlPacket
extends SrtPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ControlType controlType;
    @NotNull
    private ControlType subtype;
    private int typeSpecificInformation;
    private int ts;
    private int socketId;

    public ControlPacket(@NotNull ControlType controlType, @NotNull ControlType subtype, int typeSpecificInformation, int ts, int socketId) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlType), (String)"controlType");
        Intrinsics.checkNotNullParameter((Object)((Object)subtype), (String)"subtype");
        this.controlType = controlType;
        this.subtype = subtype;
        this.typeSpecificInformation = typeSpecificInformation;
        this.ts = ts;
        this.socketId = socketId;
    }

    public /* synthetic */ ControlPacket(ControlType controlType, ControlType controlType2, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            controlType2 = ControlType.SUB_TYPE;
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(controlType, controlType2, n, n2, n3);
    }

    @NotNull
    public final ControlType getControlType() {
        return this.controlType;
    }

    public final void setControlType(@NotNull ControlType controlType) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlType), (String)"<set-?>");
        this.controlType = controlType;
    }

    @NotNull
    public final ControlType getSubtype() {
        return this.subtype;
    }

    public final void setSubtype(@NotNull ControlType controlType) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlType), (String)"<set-?>");
        this.subtype = controlType;
    }

    public final int getTypeSpecificInformation() {
        return this.typeSpecificInformation;
    }

    public final void setTypeSpecificInformation(int n) {
        this.typeSpecificInformation = n;
    }

    public final int getTs() {
        return this.ts;
    }

    public final void setTs(int n) {
        this.ts = n;
    }

    public final int getSocketId() {
        return this.socketId;
    }

    public final void setSocketId(int n) {
        this.socketId = n;
    }

    protected final void writeHeader(int ts, int socketId) {
        int headerData = (PacketType.CONTROL.getValue() & 0xFF) << 31 | (this.controlType.getValue() & 0xFF) << 16 | this.subtype.getValue();
        ExtensionsKt.writeUInt32((OutputStream)this.getBuffer(), (int)headerData);
        ExtensionsKt.writeUInt32((OutputStream)this.getBuffer(), (int)this.typeSpecificInformation);
        ExtensionsKt.writeUInt32((OutputStream)this.getBuffer(), (int)ts);
        ExtensionsKt.writeUInt32((OutputStream)this.getBuffer(), (int)socketId);
    }

    protected final void readHeader(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int headerData = ExtensionsKt.readUInt32((InputStream)input);
        PacketType packetType = PacketType.Companion.from(headerData >>> 31 & 1);
        if (packetType != PacketType.CONTROL) {
            throw new IOException("error, parsing data packet as control packet");
        }
        this.controlType = ControlType.Companion.from(headerData >>> 16 & 0xFF);
        int subtypeValue = headerData & 0xFFFF;
        if (subtypeValue != 0) {
            throw new IOException("unknown subtype: " + subtypeValue);
        }
        this.subtype = ControlType.SUB_TYPE;
        this.typeSpecificInformation = ExtensionsKt.readUInt32((InputStream)input);
        this.ts = ExtensionsKt.readUInt32((InputStream)input);
        this.socketId = ExtensionsKt.readUInt32((InputStream)input);
    }

    @NotNull
    public String toString() {
        return "ControlPacket(controlType=" + this.controlType + ", subtype=" + this.subtype + ", typeSpecificInformation=" + this.typeSpecificInformation + ", ts=" + this.ts + ", socketId=" + this.socketId + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/pedro/srt/srt/packets/ControlPacket$Companion;", "", "<init>", "()V", "getType", "Lcom/pedro/srt/srt/packets/control/ControlType;", "input", "Ljava/io/InputStream;", "srt_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ControlType getType(@NotNull InputStream input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int headerData = ExtensionsKt.readUInt32((InputStream)input);
            return ControlType.Companion.from(headerData >>> 16 & 0xFF);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

