/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.psi;

import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.MpegType;
import com.pedro.srt.mpeg2ts.psi.Pat;
import com.pedro.srt.mpeg2ts.psi.Pmt;
import com.pedro.srt.mpeg2ts.psi.Psi;
import com.pedro.srt.mpeg2ts.psi.Sdt;
import com.pedro.srt.mpeg2ts.service.Mpeg2TsService;
import com.pedro.srt.mpeg2ts.service.Track;
import com.pedro.srt.srt.packets.data.PacketPosition;
import com.pedro.srt.utils.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u0007J\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\u001c\u001a\u00020\fJ\u0006\u0010\u001d\u001a\u00020\u000eJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0006\u0010 \u001a\u00020\u0018J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "", "service", "Lcom/pedro/srt/mpeg2ts/service/Mpeg2TsService;", "<init>", "(Lcom/pedro/srt/mpeg2ts/service/Mpeg2TsService;)V", "idExtension", "", "sdtCount", "", "patCount", "sdt", "Lcom/pedro/srt/mpeg2ts/psi/Sdt;", "pat", "Lcom/pedro/srt/mpeg2ts/psi/Pat;", "checkSendInfo", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "isKey", "", "mpegTsPacketizer", "Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer;", "chunkSize", "upgradeSdtVersion", "", "upgradePatVersion", "getAudioPid", "getVideoPid", "getSdt", "getPat", "getPmt", "Lcom/pedro/srt/mpeg2ts/psi/Pmt;", "reset", "updateService", "Companion", "srt_release"})
@SourceDebugExtension(value={"SMAP\nPsiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiManager.kt\ncom/pedro/srt/mpeg2ts/psi/PsiManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1563#2:105\n1634#2,3:106\n1#3:109\n*S KotlinDebug\n*F\n+ 1 PsiManager.kt\ncom/pedro/srt/mpeg2ts/psi/PsiManager\n*L\n69#1:105\n69#1:106,3\n*E\n"})
public final class PsiManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Mpeg2TsService service;
    private final short idExtension;
    private int sdtCount;
    private int patCount;
    @NotNull
    private Sdt sdt;
    @NotNull
    private Pat pat;
    public static final int sdtPeriod = 200;
    public static final int patPeriod = 40;

    public PsiManager(@NotNull Mpeg2TsService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
        this.idExtension = (short)Random.Default.nextInt(-128, 127);
        this.sdt = new Sdt(this.idExtension, 0, 0, this.service, 4, null);
        this.pat = new Pat(this.idExtension, 0, this.service);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MpegTsPacket> checkSendInfo(boolean isKey, @NotNull MpegTsPacketizer mpegTsPacketizer, int chunkSize) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mpegTsPacketizer, (String)"mpegTsPacketizer");
        Pmt pmt = this.service.getPmt();
        if (pmt == null) {
            return new ArrayList();
        }
        Pmt pmt2 = pmt;
        List psiPackets = new ArrayList();
        if (this.patCount >= 40 || isKey) {
            Object[] objectArray = new Psi[]{this.pat, pmt2};
            psiPackets.addAll(CollectionsKt.listOf((Object[])objectArray));
            this.patCount = 0;
        }
        if (this.sdtCount >= 200) {
            psiPackets.add(this.sdt);
            this.sdtCount = 0;
        }
        int n = this.sdtCount;
        this.sdtCount = n + 1;
        n = this.patCount;
        this.patCount = n + 1;
        Iterable $this$map$iv = ExtensionsKt.chunkPackets(mpegTsPacketizer.write(psiPackets, true), chunkSize);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void b;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MpegTsPacket((byte[])b, MpegType.PSI, PacketPosition.SINGLE, false));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List checkSendInfo$default(PsiManager psiManager, boolean bl, MpegTsPacketizer mpegTsPacketizer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return psiManager.checkSendInfo(bl, mpegTsPacketizer, n);
    }

    public final void upgradeSdtVersion() {
        this.sdt.setVersion((byte)(this.sdt.getVersion() + 1));
    }

    public final void upgradePatVersion() {
        this.pat.setVersion((byte)(this.pat.getVersion() + 1));
    }

    public final short getAudioPid() {
        Object v0;
        block1: {
            Iterable iterable = this.service.getTracks();
            for (Object t : iterable) {
                Track it = (Track)t;
                boolean bl = false;
                if (!it.getCodec().isAudio()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Track track = v0;
        return track != null ? track.getPid() : (short)0;
    }

    public final short getVideoPid() {
        Object v0;
        block1: {
            Iterable iterable = this.service.getTracks();
            for (Object t : iterable) {
                Track it = (Track)t;
                boolean bl = false;
                if (!(!it.getCodec().isAudio())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Track track = v0;
        return track != null ? track.getPid() : (short)0;
    }

    @NotNull
    public final Sdt getSdt() {
        return this.sdt;
    }

    @NotNull
    public final Pat getPat() {
        return this.pat;
    }

    @Nullable
    public final Pmt getPmt() {
        return this.service.getPmt();
    }

    public final void reset() {
        this.sdtCount = 0;
        this.patCount = 0;
    }

    public final void updateService(@NotNull Mpeg2TsService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
        this.sdt.setService(service);
        this.pat.setService(service);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/pedro/srt/mpeg2ts/psi/PsiManager$Companion;", "", "<init>", "()V", "sdtPeriod", "", "patPeriod", "srt_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

