/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.packets;

import com.pedro.common.frame.MediaFrame;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.MpegType;
import com.pedro.srt.mpeg2ts.Pes;
import com.pedro.srt.mpeg2ts.PesType;
import com.pedro.srt.mpeg2ts.packets.BasePacket;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import com.pedro.srt.srt.packets.data.PacketPosition;
import com.pedro.srt.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J@\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2(\u0010\f\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\rH\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/pedro/srt/mpeg2ts/packets/OpusPacket;", "Lcom/pedro/srt/mpeg2ts/packets/BasePacket;", "limitSize", "", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "<init>", "(ILcom/pedro/srt/mpeg2ts/psi/PsiManager;)V", "createAndSendPacket", "", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resetPacket", "resetInfo", "", "createControlHeader", "", "payloadLength", "srt_release"})
@SourceDebugExtension(value={"SMAP\nOpusPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpusPacket.kt\ncom/pedro/srt/mpeg2ts/packets/OpusPacket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1557#2:76\n1628#2,3:77\n*S KotlinDebug\n*F\n+ 1 OpusPacket.kt\ncom/pedro/srt/mpeg2ts/packets/OpusPacket\n*L\n53#1:76\n53#1:77,3\n*E\n"})
public final class OpusPacket
extends BasePacket {
    public OpusPacket(int limitSize, @NotNull PsiManager psiManager) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        super(psiManager, limitSize);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object createAndSendPacket(@NotNull MediaFrame mediaFrame, @NotNull Function2<? super List<MpegTsPacket>, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        void $this$mapTo$iv$iv;
        ByteBuffer fixedBuffer = com.pedro.common.ExtensionsKt.removeInfo((ByteBuffer)mediaFrame.getData(), (MediaFrame.Info)mediaFrame.getInfo());
        int length = fixedBuffer.remaining();
        if (length < 0) {
            return Unit.INSTANCE;
        }
        byte[] header = this.createControlHeader(length);
        byte[] payload = new byte[length + header.length];
        fixedBuffer.get(payload, header.length, length);
        System.arraycopy(header, 0, payload, 0, header.length);
        short s = this.getPsiManager().getAudioPid();
        long l = mediaFrame.getInfo().getTimestamp();
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        Pes pes = new Pes(s, true, PesType.PRIVATE_STREAM_1, l, byteBuffer);
        Iterable $this$map$iv = ExtensionsKt.chunkPackets(MpegTsPacketizer.write$default(this.getMpegTsPacketizer(), CollectionsKt.listOf((Object)pes), false, 2, null), this.getChunkSize());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void buffer;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MpegTsPacket((byte[])buffer, MpegType.AUDIO, PacketPosition.SINGLE, true));
        }
        List mpeg2tsPackets = (List)destination$iv$iv;
        if (!((Collection)mpeg2tsPackets).isEmpty()) {
            Object object = callback.invoke((Object)mpeg2tsPackets, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void resetPacket(boolean resetInfo) {
    }

    private final byte[] createControlHeader(int payloadLength) {
        byte[] bytes = ExtensionsKt.toByteArray(payloadLength);
        byte[] header = new byte[2 + bytes.length];
        header[0] = 127;
        header[1] = -32;
        System.arraycopy(bytes, 0, header, 2, bytes.length);
        return header;
    }
}

