/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.srt.packets;

import com.pedro.srt.srt.packets.PacketType;
import com.pedro.srt.srt.packets.SrtPacket;
import com.pedro.srt.srt.packets.data.KeyBasedEncryption;
import com.pedro.srt.srt.packets.data.PacketPosition;
import com.pedro.srt.utils.ExtensionsKt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u001f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001Ba\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020/2\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u00020\u0003J\b\u00104\u001a\u000205H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0013\"\u0004\b%\u0010\u0015R\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0013\"\u0004\b'\u0010\u0015R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0013\"\u0004\b)\u0010\u0015R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u00066"}, d2={"Lcom/pedro/srt/srt/packets/DataPacket;", "Lcom/pedro/srt/srt/packets/SrtPacket;", "sequenceNumber", "", "packetPosition", "Lcom/pedro/srt/srt/packets/data/PacketPosition;", "order", "", "encryption", "Lcom/pedro/srt/srt/packets/data/KeyBasedEncryption;", "retransmitted", "messageNumber", "ts", "socketId", "payload", "", "<init>", "(ILcom/pedro/srt/srt/packets/data/PacketPosition;ZLcom/pedro/srt/srt/packets/data/KeyBasedEncryption;ZIII[B)V", "getSequenceNumber", "()I", "setSequenceNumber", "(I)V", "getPacketPosition", "()Lcom/pedro/srt/srt/packets/data/PacketPosition;", "setPacketPosition", "(Lcom/pedro/srt/srt/packets/data/PacketPosition;)V", "getOrder", "()Z", "setOrder", "(Z)V", "getEncryption", "()Lcom/pedro/srt/srt/packets/data/KeyBasedEncryption;", "setEncryption", "(Lcom/pedro/srt/srt/packets/data/KeyBasedEncryption;)V", "getRetransmitted", "setRetransmitted", "getMessageNumber", "setMessageNumber", "getTs", "setTs", "getSocketId", "setSocketId", "getPayload", "()[B", "setPayload", "([B)V", "write", "", "read", "input", "Ljava/io/InputStream;", "getSize", "toString", "", "srt_release"})
public final class DataPacket
extends SrtPacket {
    private int sequenceNumber;
    @NotNull
    private PacketPosition packetPosition;
    private boolean order;
    @NotNull
    private KeyBasedEncryption encryption;
    private boolean retransmitted;
    private int messageNumber;
    private int ts;
    private int socketId;
    @NotNull
    private byte[] payload;

    public DataPacket(int sequenceNumber, @NotNull PacketPosition packetPosition, boolean order, @NotNull KeyBasedEncryption encryption, boolean retransmitted, int messageNumber, int ts, int socketId, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)((Object)packetPosition), (String)"packetPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)encryption), (String)"encryption");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.sequenceNumber = sequenceNumber;
        this.packetPosition = packetPosition;
        this.order = order;
        this.encryption = encryption;
        this.retransmitted = retransmitted;
        this.messageNumber = messageNumber;
        this.ts = ts;
        this.socketId = socketId;
        this.payload = payload;
    }

    public /* synthetic */ DataPacket(int n, PacketPosition packetPosition, boolean bl, KeyBasedEncryption keyBasedEncryption, boolean bl2, int n2, int n3, int n4, byte[] byArray, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            packetPosition = PacketPosition.SINGLE;
        }
        if ((n5 & 4) != 0) {
            bl = false;
        }
        if ((n5 & 8) != 0) {
            keyBasedEncryption = KeyBasedEncryption.NONE;
        }
        if ((n5 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n5 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x40) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x80) != 0) {
            n4 = 0;
        }
        if ((n5 & 0x100) != 0) {
            byArray = new byte[]{};
        }
        this(n, packetPosition, bl, keyBasedEncryption, bl2, n2, n3, n4, byArray);
    }

    public final int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber(int n) {
        this.sequenceNumber = n;
    }

    @NotNull
    public final PacketPosition getPacketPosition() {
        return this.packetPosition;
    }

    public final void setPacketPosition(@NotNull PacketPosition packetPosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)packetPosition), (String)"<set-?>");
        this.packetPosition = packetPosition;
    }

    public final boolean getOrder() {
        return this.order;
    }

    public final void setOrder(boolean bl) {
        this.order = bl;
    }

    @NotNull
    public final KeyBasedEncryption getEncryption() {
        return this.encryption;
    }

    public final void setEncryption(@NotNull KeyBasedEncryption keyBasedEncryption) {
        Intrinsics.checkNotNullParameter((Object)((Object)keyBasedEncryption), (String)"<set-?>");
        this.encryption = keyBasedEncryption;
    }

    public final boolean getRetransmitted() {
        return this.retransmitted;
    }

    public final void setRetransmitted(boolean bl) {
        this.retransmitted = bl;
    }

    public final int getMessageNumber() {
        return this.messageNumber;
    }

    public final void setMessageNumber(int n) {
        this.messageNumber = n;
    }

    public final int getTs() {
        return this.ts;
    }

    public final void setTs(int n) {
        this.ts = n;
    }

    public final int getSocketId() {
        return this.socketId;
    }

    public final void setSocketId(int n) {
        this.socketId = n;
    }

    @NotNull
    public final byte[] getPayload() {
        return this.payload;
    }

    public final void setPayload(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.payload = byArray;
    }

    public final void write() {
        this.resetBuffer();
        int headerData = PacketType.DATA.getValue() << 31 | this.sequenceNumber & Integer.MAX_VALUE;
        int info = this.packetPosition.getValue() << 30 | ExtensionsKt.toInt(this.order) << 29 | this.encryption.getValue() << 27 | ExtensionsKt.toInt(this.retransmitted) << 26 | this.messageNumber;
        ExtensionsKt.writeUInt32(this.getBuffer(), headerData);
        ExtensionsKt.writeUInt32(this.getBuffer(), info);
        ExtensionsKt.writeUInt32(this.getBuffer(), this.ts);
        ExtensionsKt.writeUInt32(this.getBuffer(), this.socketId);
        this.getBuffer().write(this.payload);
    }

    public final void read(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.sequenceNumber = ExtensionsKt.readUInt32(input);
        PacketType packetType = PacketType.Companion.from(this.sequenceNumber >>> 31 & 1);
        if (packetType != PacketType.DATA) {
            throw new IOException("error, parsing control packet as data packet");
        }
        int info = ExtensionsKt.readUInt32(input);
        this.packetPosition = PacketPosition.Companion.from(info >>> 30 & 3);
        this.order = ExtensionsKt.toBoolean(info >>> 29 & 1);
        this.encryption = KeyBasedEncryption.Companion.from(info >>> 28 & 3);
        this.retransmitted = ExtensionsKt.toBoolean(info >>> 26 & 1);
        this.messageNumber = info & 0x3FFFFFF;
        this.ts = ExtensionsKt.readUInt32(input);
        this.socketId = ExtensionsKt.readUInt32(input);
        byte[] payload = new byte[input.available()];
        ExtensionsKt.readUntil(input, payload);
        this.payload = payload;
    }

    public final int getSize() {
        return this.getBuffer().size();
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.payload);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "DataPacket(sequenceNumber=" + this.sequenceNumber + ", packetPosition=" + this.packetPosition + ", order=" + this.order + ", encryption=" + this.encryption + ", retransmitted=" + this.retransmitted + ", messageNumber=" + this.messageNumber + ", ts=" + this.ts + ", socketId=" + this.socketId + ", payload=" + string + ")";
    }

    public DataPacket() {
        this(0, null, false, null, false, 0, 0, 0, null, 511, null);
    }
}

