/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.psi;

import com.pedro.srt.mpeg2ts.MpegTsPayload;
import com.pedro.srt.utils.CRC32;
import com.pedro.srt.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&J\b\u0010 \u001a\u00020\u0003H&J\u0006\u0010!\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/pedro/srt/mpeg2ts/psi/Psi;", "Lcom/pedro/srt/mpeg2ts/MpegTsPayload;", "pid", "", "id", "", "idExtension", "", "version", "sectionSyntaxIndicator", "", "privateBit", "indicator", "sectionNumber", "lastSectionNumber", "<init>", "(IBSBZZZBB)V", "getVersion", "()B", "setVersion", "(B)V", "reserved", "sectionLengthUnusedBits", "sectionLength", "write", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "writeCRC", "offset", "size", "writeData", "getTableDataSize", "getSize", "srt_release"})
public abstract class Psi
extends MpegTsPayload {
    private final byte id;
    private final short idExtension;
    private byte version;
    private final boolean sectionSyntaxIndicator;
    private final boolean privateBit;
    private final boolean indicator;
    private final byte sectionNumber;
    private final byte lastSectionNumber;
    private final int reserved;
    private final int sectionLengthUnusedBits;
    private int sectionLength;

    public Psi(int pid, byte id, short idExtension, byte version, boolean sectionSyntaxIndicator, boolean privateBit, boolean indicator, byte sectionNumber, byte lastSectionNumber) {
        super(pid, false);
        this.id = id;
        this.idExtension = idExtension;
        this.version = version;
        this.sectionSyntaxIndicator = sectionSyntaxIndicator;
        this.privateBit = privateBit;
        this.indicator = indicator;
        this.sectionNumber = sectionNumber;
        this.lastSectionNumber = lastSectionNumber;
        this.reserved = 3;
    }

    public /* synthetic */ Psi(int n, byte by, short s, byte by2, boolean bl, boolean bl2, boolean bl3, byte by3, byte by4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x80) != 0) {
            by3 = 0;
        }
        if ((n2 & 0x100) != 0) {
            by4 = 0;
        }
        this(n, by, s, by2, bl, bl2, bl3, by3, by4);
    }

    public final byte getVersion() {
        return this.version;
    }

    public final void setVersion(byte by) {
        this.version = by;
    }

    public final void write(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        byteBuffer.put((byte)0);
        int crc32InitialPosition = byteBuffer.position();
        byteBuffer.put(this.id);
        this.sectionLength = 9 + this.getTableDataSize();
        int combined = ExtensionsKt.toInt(this.sectionSyntaxIndicator) << 15 | ExtensionsKt.toInt(this.privateBit) << 14 | this.reserved << 12 | this.sectionLengthUnusedBits << 10 | this.sectionLength & 0x3FF;
        byteBuffer.putShort((short)combined);
        byteBuffer.putShort(this.idExtension);
        int combined2 = this.reserved << 6 | this.version << 1 | ExtensionsKt.toInt(this.indicator);
        byteBuffer.put((byte)combined2);
        byteBuffer.put(this.sectionNumber);
        byteBuffer.put(this.lastSectionNumber);
        this.writeData(byteBuffer);
        int crc32 = this.writeCRC(byteBuffer, crc32InitialPosition, byteBuffer.position());
        byteBuffer.putInt(crc32);
    }

    private final int writeCRC(ByteBuffer byteBuffer, int offset, int size) {
        byte[] byArray = byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return CRC32.INSTANCE.getCRC32(byArray, offset, size);
    }

    public abstract void writeData(@NotNull ByteBuffer var1);

    public abstract int getTableDataSize();

    public final int getSize() {
        return 13 + this.getTableDataSize();
    }
}

