/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.packets;

import android.media.MediaCodec;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J2\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\u0004\u0012\u00020\u00140\u001aH&J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH&J\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/pedro/srt/mpeg2ts/packets/BasePacket;", "", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "limitSize", "", "<init>", "(Lcom/pedro/srt/mpeg2ts/psi/PsiManager;I)V", "getPsiManager", "()Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "mpegTsPacketizer", "Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer;", "getMpegTsPacketizer", "()Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer;", "chunkSize", "getChunkSize", "()I", "setChunkSize", "(I)V", "createAndSendPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "callback", "Lkotlin/Function1;", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "resetPacket", "resetInfo", "", "reset", "setLimitSize", "srt_release"})
public abstract class BasePacket {
    @NotNull
    private final PsiManager psiManager;
    private int limitSize;
    @NotNull
    private final MpegTsPacketizer mpegTsPacketizer;
    private int chunkSize;

    public BasePacket(@NotNull PsiManager psiManager, int limitSize) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        this.psiManager = psiManager;
        this.limitSize = limitSize;
        this.mpegTsPacketizer = new MpegTsPacketizer(this.psiManager);
        this.chunkSize = this.limitSize / 188;
    }

    @NotNull
    public final PsiManager getPsiManager() {
        return this.psiManager;
    }

    @NotNull
    protected final MpegTsPacketizer getMpegTsPacketizer() {
        return this.mpegTsPacketizer;
    }

    protected final int getChunkSize() {
        return this.chunkSize;
    }

    protected final void setChunkSize(int n) {
        this.chunkSize = n;
    }

    public abstract void createAndSendPacket(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2, @NotNull Function1<? super List<MpegTsPacket>, Unit> var3);

    public abstract void resetPacket(boolean var1);

    public final void reset(boolean resetInfo) {
        this.mpegTsPacketizer.reset();
        this.resetPacket(resetInfo);
    }

    public final void setLimitSize(int limitSize) {
        this.limitSize = limitSize;
        this.chunkSize = limitSize / 188;
    }
}

