/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.srt;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.common.BitrateManager;
import com.pedro.common.ConnectChecker;
import com.pedro.srt.mpeg2ts.Codec;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.MpegType;
import com.pedro.srt.mpeg2ts.Pid;
import com.pedro.srt.mpeg2ts.packets.AacPacket;
import com.pedro.srt.mpeg2ts.packets.H26XPacket;
import com.pedro.srt.mpeg2ts.psi.Psi;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import com.pedro.srt.mpeg2ts.psi.TableToSend;
import com.pedro.srt.mpeg2ts.service.Mpeg2TsService;
import com.pedro.srt.mpeg2ts.service.Track;
import com.pedro.srt.srt.CommandsManager;
import com.pedro.srt.srt.SrtSender;
import com.pedro.srt.srt.packets.data.PacketPosition;
import com.pedro.srt.utils.SrtSocket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 b2\u00020\u0001:\u0001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020\u001eH\u0002J\u0006\u0010=\u001a\u00020;J\u0006\u0010>\u001a\u00020\u0014J\u0006\u0010?\u001a\u00020\u0014J\u0006\u0010@\u001a\u00020\u0010J\u0006\u0010A\u001a\u00020\u0010J\u0010\u0010B\u001a\u00020\u001e2\b\b\u0002\u0010C\u001a\u00020DJ\u0006\u0010E\u001a\u00020;J\u0006\u0010F\u001a\u00020;J\u0006\u0010G\u001a\u00020;J\u0006\u0010H\u001a\u00020;J\u000e\u0010I\u001a\u00020;2\u0006\u0010J\u001a\u00020\u0014J\u0016\u0010K\u001a\u00020;2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0016\u0010P\u001a\u00020;2\u0006\u0010Q\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0016\u0010R\u001a\u00020;2\u0006\u0010S\u001a\u00020\u00142\u0006\u0010T\u001a\u00020\u001eJ\u000e\u0010U\u001a\u00020;2\u0006\u0010V\u001a\u00020\u001eJ\u0018\u0010W\u001a\u00020;2\u0006\u0010X\u001a\u00020\u001e2\u0006\u0010Y\u001a\u00020\u001eH\u0002J\"\u0010Z\u001a\u00020;2\u0006\u0010[\u001a\u00020M2\b\u0010\\\u001a\u0004\u0018\u00010M2\b\u0010]\u001a\u0004\u0018\u00010MJ\u0006\u0010^\u001a\u00020;J\u0016\u0010_\u001a\u00020;2\u0006\u0010`\u001a\u00020\u001eH\u0086@\u00a2\u0006\u0002\u0010aR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00106\u001a\u00020\n2\u0006\u00105\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\f\"\u0004\b8\u0010\u000eR\u000e\u00109\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/pedro/srt/srt/SrtSender;", "", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "commandsManager", "Lcom/pedro/srt/srt/CommandsManager;", "(Lcom/pedro/common/ConnectChecker;Lcom/pedro/srt/srt/CommandsManager;)V", "aacPacket", "Lcom/pedro/srt/mpeg2ts/packets/AacPacket;", "audioCodec", "Lcom/pedro/srt/mpeg2ts/Codec;", "getAudioCodec", "()Lcom/pedro/srt/mpeg2ts/Codec;", "setAudioCodec", "(Lcom/pedro/srt/mpeg2ts/Codec;)V", "audioFramesSent", "", "bitrateManager", "Lcom/pedro/common/BitrateManager;", "cacheSize", "", "<set-?>", "droppedAudioFrames", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "h26XPacket", "Lcom/pedro/srt/mpeg2ts/packets/H26XPacket;", "isEnableLogs", "", "job", "Lkotlinx/coroutines/Job;", "limitSize", "mpegTsPacketizer", "Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer;", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "queue", "Ljava/util/concurrent/BlockingQueue;", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "running", "scope", "Lkotlinx/coroutines/CoroutineScope;", "service", "Lcom/pedro/srt/mpeg2ts/service/Mpeg2TsService;", "socket", "Lcom/pedro/srt/utils/SrtSocket;", "getSocket", "()Lcom/pedro/srt/utils/SrtSocket;", "setSocket", "(Lcom/pedro/srt/utils/SrtSocket;)V", "value", "videoCodec", "getVideoCodec", "setVideoCodec", "videoFramesSent", "checkSendInfo", "", "isKey", "clearCache", "getCacheSize", "getItemsInCache", "getSentAudioFrames", "getSentVideoFrames", "hasCongestion", "percentUsed", "", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudioFrame", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideoFrame", "h264Buffer", "setAudioInfo", "sampleRate", "isStereo", "setLogs", "enable", "setTrackConfig", "videoEnabled", "audioEnabled", "setVideoInfo", "sps", "pps", "vps", "start", "stop", "clear", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "srt_release"})
@SourceDebugExtension(value={"SMAP\nSrtSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SrtSender.kt\ncom/pedro/srt/srt/SrtSender\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Extensions.kt\ncom/pedro/common/ExtensionsKt\n*L\n1#1,286:1\n1#2:287\n1549#3:288\n1620#3,3:289\n1549#3:297\n1620#3,3:298\n1549#3:306\n1620#3,3:307\n58#4,5:292\n58#4,5:301\n58#4,5:310\n*S KotlinDebug\n*F\n+ 1 SrtSender.kt\ncom/pedro/srt/srt/SrtSender\n*L\n194#1:288\n194#1:289,3\n200#1:297\n200#1:298,3\n207#1:306\n207#1:307,3\n197#1:292,5\n203#1:301,5\n210#1:310,5\n*E\n"})
public final class SrtSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectChecker connectChecker;
    @NotNull
    private final CommandsManager commandsManager;
    @NotNull
    private final Mpeg2TsService service;
    @NotNull
    private final PsiManager psiManager;
    private final int limitSize;
    @NotNull
    private final MpegTsPacketizer mpegTsPacketizer;
    @NotNull
    private final AacPacket aacPacket;
    @NotNull
    private final H26XPacket h26XPacket;
    private volatile boolean running;
    private int cacheSize;
    @Nullable
    private Job job;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private volatile BlockingQueue<List<MpegTsPacket>> queue;
    private long audioFramesSent;
    private long videoFramesSent;
    @Nullable
    private SrtSocket socket;
    private long droppedAudioFrames;
    private long droppedVideoFrames;
    @NotNull
    private Codec videoCodec;
    @NotNull
    private Codec audioCodec;
    @NotNull
    private final BitrateManager bitrateManager;
    private boolean isEnableLogs;
    @NotNull
    private static final String TAG = "SrtSender";

    /*
     * WARNING - void declaration
     */
    public SrtSender(@NotNull ConnectChecker connectChecker, @NotNull CommandsManager commandsManager) {
        void $this$psiManager_u24lambda_u240;
        PsiManager psiManager;
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)commandsManager, (String)"commandsManager");
        this.connectChecker = connectChecker;
        this.commandsManager = commandsManager;
        this.service = new Mpeg2TsService(0, 0, null, null, null, null, null, 127, null);
        PsiManager psiManager2 = psiManager = new PsiManager(this.service);
        SrtSender srtSender = this;
        boolean bl = false;
        $this$psiManager_u24lambda_u240.upgradePatVersion();
        $this$psiManager_u24lambda_u240.upgradeSdtVersion();
        srtSender.psiManager = psiManager;
        this.limitSize = this.commandsManager.getMTU() - 16;
        this.mpegTsPacketizer = new MpegTsPacketizer(this.psiManager);
        this.aacPacket = new AacPacket(this.limitSize, this.psiManager);
        this.h26XPacket = new H26XPacket(this.limitSize, this.psiManager);
        this.cacheSize = 200;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.queue = new LinkedBlockingQueue(this.cacheSize);
        this.videoCodec = Codec.AVC;
        this.audioCodec = Codec.AAC;
        this.bitrateManager = new BitrateManager(this.connectChecker);
        this.isEnableLogs = true;
    }

    @Nullable
    public final SrtSocket getSocket() {
        return this.socket;
    }

    public final void setSocket(@Nullable SrtSocket srtSocket) {
        this.socket = srtSocket;
    }

    public final long getDroppedAudioFrames() {
        return this.droppedAudioFrames;
    }

    public final long getDroppedVideoFrames() {
        return this.droppedVideoFrames;
    }

    @NotNull
    public final Codec getVideoCodec() {
        return this.videoCodec;
    }

    public final void setVideoCodec(@NotNull Codec value) {
        Track videoTrack;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            Iterable iterable = this.service.getTracks();
            for (Object t : iterable) {
                Track it = (Track)t;
                boolean bl = false;
                if (!(it.getCodec() != Codec.AAC)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Track track = videoTrack = (Track)v0;
        if (track != null) {
            Track it = track;
            boolean bl = false;
            this.service.getTracks().remove(it);
        }
        this.h26XPacket.setVideoCodec(value);
        this.videoCodec = value;
    }

    @NotNull
    public final Codec getAudioCodec() {
        return this.audioCodec;
    }

    public final void setAudioCodec(@NotNull Codec codec) {
        Intrinsics.checkNotNullParameter((Object)((Object)codec), (String)"<set-?>");
        this.audioCodec = codec;
    }

    private final void setTrackConfig(boolean videoEnabled, boolean audioEnabled) {
        Pid.reset();
        if (audioEnabled) {
            this.service.addTrack(this.audioCodec);
        }
        if (videoEnabled) {
            this.service.addTrack(this.videoCodec);
        }
        this.service.generatePmt();
        this.psiManager.updateService(this.service);
    }

    public final void setVideoInfo(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        this.h26XPacket.sendVideoInfo(sps, pps, vps);
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.aacPacket.sendAudioInfo(sampleRate, isStereo);
    }

    public final void sendVideoFrame(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running) {
            this.h26XPacket.createAndSendPacket(h264Buffer, info, (Function1<? super List<MpegTsPacket>, Unit>)((Function1)new Function1<List<? extends MpegTsPacket>, Unit>(this){
                final /* synthetic */ SrtSender this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull List<MpegTsPacket> mpegTsPackets2) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(mpegTsPackets2, (String)"mpegTsPackets");
                    boolean isKey = mpegTsPackets2.get(0).isKey();
                    SrtSender.access$checkSendInfo(this.this$0, isKey);
                    BlockingQueue $this$trySend$iv = SrtSender.access$getQueue$p(this.this$0);
                    boolean $i$f$trySend = false;
                    try {
                        $this$trySend$iv.add(mpegTsPackets2);
                        bl = true;
                    }
                    catch (IllegalStateException e$iv) {
                        bl = false;
                    }
                    boolean result = bl;
                    if (!result) {
                        Log.i((String)"SrtSender", (String)"Video frame discarded");
                        SrtSender srtSender = this.this$0;
                        long l = srtSender.getDroppedVideoFrames();
                        SrtSender.access$setDroppedVideoFrames$p(srtSender, l + 1L);
                    }
                }
            }));
        }
    }

    public final void sendAudioFrame(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running) {
            this.aacPacket.createAndSendPacket(aacBuffer, info, (Function1<? super List<MpegTsPacket>, Unit>)((Function1)new Function1<List<? extends MpegTsPacket>, Unit>(this){
                final /* synthetic */ SrtSender this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull List<MpegTsPacket> mpegTsPackets2) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(mpegTsPackets2, (String)"mpegTsPackets");
                    SrtSender.checkSendInfo$default(this.this$0, false, 1, null);
                    BlockingQueue $this$trySend$iv = SrtSender.access$getQueue$p(this.this$0);
                    boolean $i$f$trySend = false;
                    try {
                        $this$trySend$iv.add(mpegTsPackets2);
                        bl = true;
                    }
                    catch (IllegalStateException e$iv) {
                        bl = false;
                    }
                    boolean result = bl;
                    if (!result) {
                        Log.i((String)"SrtSender", (String)"Audio frame discarded");
                        SrtSender srtSender = this.this$0;
                        long l = srtSender.getDroppedAudioFrames();
                        SrtSender.access$setDroppedAudioFrames$p(srtSender, l + 1L);
                    }
                }
            }));
        }
    }

    public final void start() {
        this.queue.clear();
        this.setTrackConfig(!this.commandsManager.getVideoDisabled(), !this.commandsManager.getAudioDisabled());
        this.running = true;
        this.job = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SrtSender this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 14[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSendInfo(boolean isKey) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.psiManager.shouldSend(isKey).ordinal()]) {
            case 1: {
                void $this$mapTo$iv$iv2;
                Object[] objectArray = new Psi[]{this.psiManager.getPat(), this.psiManager.getPmt()};
                Iterable $this$map$iv = this.mpegTsPacketizer.write(CollectionsKt.listOf((Object[])objectArray), true);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void b;
                    byte[] byArray = (byte[])item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new MpegTsPacket((byte[])b, MpegType.PSI, PacketPosition.SINGLE, false));
                }
                List psiPackets = (List)destination$iv$iv;
                BlockingQueue<List<MpegTsPacket>> $this$trySend$iv = this.queue;
                boolean $i$f$trySend = false;
                try {
                    $this$trySend$iv.add(psiPackets);
                    boolean $this$mapTo$iv$iv2 = true;
                }
                catch (IllegalStateException e$iv) {
                    boolean $this$mapTo$iv$iv2 = false;
                }
                break;
            }
            case 2: {
                Iterable $this$map$iv = this.mpegTsPacketizer.write(CollectionsKt.listOf((Object)this.psiManager.getSdt()), true);
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    byte[] b = (byte[])item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new MpegTsPacket(b, MpegType.PSI, PacketPosition.SINGLE, false));
                }
                List psiPackets = (List)destination$iv$iv;
                BlockingQueue<List<MpegTsPacket>> $this$trySend$iv = this.queue;
                boolean $i$f$trySend = false;
                try {
                    $this$trySend$iv.add(psiPackets);
                    boolean $this$mapTo$iv$iv = true;
                }
                catch (IllegalStateException e$iv) {
                    boolean $this$mapTo$iv$iv = false;
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                Object $this$trySend$iv = new Psi[]{this.psiManager.getPmt(), this.psiManager.getSdt(), this.psiManager.getPat()};
                Iterable $this$map$iv = this.mpegTsPacketizer.write(CollectionsKt.listOf((Object[])$this$trySend$iv), true);
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    byte[] b = (byte[])item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new MpegTsPacket(b, MpegType.PSI, PacketPosition.SINGLE, false));
                }
                List psiPackets = (List)destination$iv$iv;
                $this$trySend$iv = this.queue;
                boolean $i$f$trySend = false;
                try {
                    $this$trySend$iv.add(psiPackets);
                    boolean bl = true;
                    break;
                }
                catch (IllegalStateException e$iv) {
                    boolean bl = false;
                }
            }
        }
    }

    static /* synthetic */ void checkSendInfo$default(SrtSender srtSender, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        srtSender.checkSendInfo(bl);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object stop(boolean var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof stop.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SrtSender this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stop(false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.running = false;
                this.psiManager.reset();
                this.service.clear();
                this.mpegTsPacketizer.reset();
                this.aacPacket.reset(clear != false);
                this.h26XPacket.reset(clear != false);
                this.resetSentAudioFrames();
                this.resetSentVideoFrames();
                this.resetDroppedAudioFrames();
                this.resetDroppedVideoFrames();
                v0 = this.job;
                if (v0 == null) break;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = JobKt.cancelAndJoin((Job)v0, (Continuation)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                break;
            }
            case 1: {
                this = (SrtSender)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        this.job = null;
        this.queue.clear();
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean hasCongestion(float percentUsed) throws IllegalArgumentException {
        float remaining;
        float capacity;
        if (percentUsed < 0.0f || percentUsed > 100.0f) {
            throw new IllegalArgumentException("the value must be in range 0 to 100");
        }
        float size = this.queue.size();
        return size >= (capacity = size + (remaining = (float)this.queue.remainingCapacity())) * (percentUsed / 100.0f);
    }

    public static /* synthetic */ boolean hasCongestion$default(SrtSender srtSender, float f, int n, Object object) throws IllegalArgumentException {
        if ((n & 1) != 0) {
            f = 20.0f;
        }
        return srtSender.hasCongestion(f);
    }

    public final void resizeCache(int newSize) {
        if (newSize < this.queue.size() - this.queue.remainingCapacity()) {
            throw new RuntimeException("Can't fit current cache inside new cache size");
        }
        BlockingQueue tempQueue = new LinkedBlockingQueue(newSize);
        this.queue.drainTo(tempQueue);
        this.queue = tempQueue;
    }

    public final int getCacheSize() {
        return this.cacheSize;
    }

    public final int getItemsInCache() {
        return this.queue.size();
    }

    public final void clearCache() {
        this.queue.clear();
    }

    public final long getSentAudioFrames() {
        return this.audioFramesSent;
    }

    public final long getSentVideoFrames() {
        return this.videoFramesSent;
    }

    public final void resetSentAudioFrames() {
        this.audioFramesSent = 0L;
    }

    public final void resetSentVideoFrames() {
        this.videoFramesSent = 0L;
    }

    public final void resetDroppedAudioFrames() {
        this.droppedAudioFrames = 0L;
    }

    public final void resetDroppedVideoFrames() {
        this.droppedVideoFrames = 0L;
    }

    public final void setLogs(boolean enable) {
        this.isEnableLogs = enable;
    }

    public static final /* synthetic */ void access$checkSendInfo(SrtSender $this, boolean isKey) {
        $this.checkSendInfo(isKey);
    }

    public static final /* synthetic */ BlockingQueue access$getQueue$p(SrtSender $this) {
        return $this.queue;
    }

    public static final /* synthetic */ void access$setDroppedVideoFrames$p(SrtSender $this, long l) {
        $this.droppedVideoFrames = l;
    }

    public static final /* synthetic */ void access$setDroppedAudioFrames$p(SrtSender $this, long l) {
        $this.droppedAudioFrames = l;
    }

    public static final /* synthetic */ MpegTsPacketizer access$getMpegTsPacketizer$p(SrtSender $this) {
        return $this.mpegTsPacketizer;
    }

    public static final /* synthetic */ PsiManager access$getPsiManager$p(SrtSender $this) {
        return $this.psiManager;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(SrtSender $this) {
        return $this.scope;
    }

    public static final /* synthetic */ boolean access$getRunning$p(SrtSender $this) {
        return $this.running;
    }

    public static final /* synthetic */ BitrateManager access$getBitrateManager$p(SrtSender $this) {
        return $this.bitrateManager;
    }

    public static final /* synthetic */ ConnectChecker access$getConnectChecker$p(SrtSender $this) {
        return $this.connectChecker;
    }

    public static final /* synthetic */ CommandsManager access$getCommandsManager$p(SrtSender $this) {
        return $this.commandsManager;
    }

    public static final /* synthetic */ boolean access$isEnableLogs$p(SrtSender $this) {
        return $this.isEnableLogs;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pedro/srt/srt/SrtSender$Companion;", "", "()V", "TAG", "", "srt_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TableToSend.values().length];
            try {
                nArray[TableToSend.PAT_PMT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableToSend.SDT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableToSend.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableToSend.ALL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

