/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.srt;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.VideoCodec;
import com.pedro.srt.mpeg2ts.Codec;
import com.pedro.srt.srt.CommandsManager;
import com.pedro.srt.srt.SrtClient;
import com.pedro.srt.srt.SrtSender;
import com.pedro.srt.srt.packets.ControlPacket;
import com.pedro.srt.srt.packets.DataPacket;
import com.pedro.srt.srt.packets.SrtPacket;
import com.pedro.srt.srt.packets.control.Ack;
import com.pedro.srt.srt.packets.control.Ack2;
import com.pedro.srt.srt.packets.control.CongestionWarning;
import com.pedro.srt.srt.packets.control.DropReq;
import com.pedro.srt.srt.packets.control.KeepAlive;
import com.pedro.srt.srt.packets.control.Nak;
import com.pedro.srt.srt.packets.control.PeerError;
import com.pedro.srt.srt.packets.control.Shutdown;
import com.pedro.srt.srt.packets.control.handshake.EncryptionType;
import com.pedro.srt.srt.packets.control.handshake.Handshake;
import com.pedro.srt.utils.SrtSocket;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010,\u001a\u00020-J\u001c\u0010.\u001a\u00020-2\b\u0010)\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010/\u001a\u00020\fH\u0007J\u0006\u00100\u001a\u00020-J\u0016\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u00102J\u0006\u00103\u001a\u00020\bJ\u000e\u00104\u001a\u00020-H\u0082@\u00a2\u0006\u0002\u00105J\u000e\u00106\u001a\u00020-H\u0082@\u00a2\u0006\u0002\u00105J\u0006\u00107\u001a\u00020\fJ\u000e\u00107\u001a\u00020\f2\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u00020\fH\u0002J\u000e\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020\u0011J\u0018\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020\u00112\b\u0010=\u001a\u0004\u0018\u00010\u0006J\u0006\u0010>\u001a\u00020-J\u0006\u0010?\u001a\u00020-J\u0006\u0010@\u001a\u00020-J\u0006\u0010A\u001a\u00020-J\u000e\u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020\bJ\u0016\u0010D\u001a\u00020-2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HJ\u0016\u0010I\u001a\u00020-2\u0006\u0010J\u001a\u00020F2\u0006\u0010G\u001a\u00020HJ\u000e\u0010K\u001a\u00020-2\u0006\u0010L\u001a\u00020MJ\u0016\u0010N\u001a\u00020-2\u0006\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020\fJ\u001a\u0010Q\u001a\u00020-2\b\u0010R\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0006J\u000e\u0010T\u001a\u00020-2\u0006\u0010U\u001a\u00020\fJ\u000e\u0010V\u001a\u00020-2\u0006\u0010W\u001a\u00020\fJ\u000e\u0010X\u001a\u00020-2\u0006\u0010Y\u001a\u00020\fJ\u000e\u0010Z\u001a\u00020-2\u0006\u0010[\u001a\u00020\fJ\u0016\u0010\\\u001a\u00020-2\u0006\u0010]\u001a\u00020\u00062\u0006\u0010^\u001a\u00020_J\u000e\u0010`\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010a\u001a\u00020-2\u0006\u0010b\u001a\u00020cJ\"\u0010d\u001a\u00020-2\u0006\u0010e\u001a\u00020F2\b\u0010f\u001a\u0004\u0018\u00010F2\b\u0010g\u001a\u0004\u0018\u00010FJ\u000e\u0010h\u001a\u00020\f2\u0006\u0010i\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013R\u0011\u0010#\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0013R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lcom/pedro/srt/srt/SrtClient;", "", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "(Lcom/pedro/common/ConnectChecker;)V", "TAG", "", "cacheSize", "", "getCacheSize", "()I", "checkServerAlive", "", "commandsManager", "Lcom/pedro/srt/srt/CommandsManager;", "doingRetry", "droppedAudioFrames", "", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "<set-?>", "isStreaming", "()Z", "job", "Lkotlinx/coroutines/Job;", "jobRetry", "numRetry", "reTries", "scope", "Lkotlinx/coroutines/CoroutineScope;", "scopeRetry", "sentAudioFrames", "getSentAudioFrames", "sentVideoFrames", "getSentVideoFrames", "socket", "Lcom/pedro/srt/utils/SrtSocket;", "srtSender", "Lcom/pedro/srt/srt/SrtSender;", "url", "urlPattern", "Ljava/util/regex/Pattern;", "clearCache", "", "connect", "isRetry", "disconnect", "clear", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getItemsInCache", "handleMessages", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleServerPackets", "hasCongestion", "percentUsed", "", "isAlive", "reConnect", "delay", "backupUrl", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudio", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideo", "h264Buffer", "setAudioCodec", "audioCodec", "Lcom/pedro/common/AudioCodec;", "setAudioInfo", "sampleRate", "isStereo", "setAuthorization", "user", "password", "setCheckServerAlive", "enabled", "setLogs", "enable", "setOnlyAudio", "onlyAudio", "setOnlyVideo", "onlyVideo", "setPassphrase", "passphrase", "type", "Lcom/pedro/srt/srt/packets/control/handshake/EncryptionType;", "setReTries", "setVideoCodec", "videoCodec", "Lcom/pedro/common/VideoCodec;", "setVideoInfo", "sps", "pps", "vps", "shouldRetry", "reason", "srt_release"})
public final class SrtClient {
    @NotNull
    private final ConnectChecker connectChecker;
    @NotNull
    private final String TAG;
    @NotNull
    private final Pattern urlPattern;
    @NotNull
    private final CommandsManager commandsManager;
    @NotNull
    private final SrtSender srtSender;
    @Nullable
    private SrtSocket socket;
    @NotNull
    private CoroutineScope scope;
    @Nullable
    private Job job;
    @NotNull
    private CoroutineScope scopeRetry;
    @Nullable
    private Job jobRetry;
    private boolean checkServerAlive;
    private volatile boolean isStreaming;
    @Nullable
    private String url;
    private boolean doingRetry;
    private int numRetry;
    private int reTries;

    public SrtClient(@NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        this.connectChecker = connectChecker;
        this.TAG = "SrtClient";
        Pattern pattern = Pattern.compile("^srt://([^/:]+)(?::(\\d+))*/([^/]+)/?([^*]*)$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.urlPattern = pattern;
        this.commandsManager = new CommandsManager();
        this.srtSender = new SrtSender(this.connectChecker, this.commandsManager);
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.scopeRetry = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
    }

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final long getDroppedAudioFrames() {
        return this.srtSender.getDroppedAudioFrames();
    }

    public final long getDroppedVideoFrames() {
        return this.srtSender.getDroppedVideoFrames();
    }

    public final int getCacheSize() {
        return this.srtSender.getCacheSize();
    }

    public final long getSentAudioFrames() {
        return this.srtSender.getSentAudioFrames();
    }

    public final long getSentVideoFrames() {
        return this.srtSender.getSentVideoFrames();
    }

    public final void setVideoCodec(@NotNull VideoCodec videoCodec) {
        Intrinsics.checkNotNullParameter((Object)videoCodec, (String)"videoCodec");
        if (!this.isStreaming) {
            this.srtSender.setVideoCodec(switch (WhenMappings.$EnumSwitchMapping$0[videoCodec.ordinal()]) {
                case 1 -> Codec.AVC;
                case 2 -> Codec.HEVC;
                default -> throw new IllegalArgumentException("Unsupported codec: " + videoCodec.name());
            });
        }
    }

    public final void setAudioCodec(@NotNull AudioCodec audioCodec) {
        Intrinsics.checkNotNullParameter((Object)audioCodec, (String)"audioCodec");
        if (!this.isStreaming) {
            if (WhenMappings.$EnumSwitchMapping$1[audioCodec.ordinal()] != 1) {
                throw new IllegalArgumentException("Unsupported codec: " + audioCodec.name());
            }
            this.srtSender.setAudioCodec(Codec.AAC);
        }
    }

    public final void setAuthorization(@Nullable String user, @Nullable String password) {
        String string = "unimplemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public final void setPassphrase(@NotNull String passphrase, @NotNull EncryptionType type) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.isStreaming) {
            if (passphrase.length() < 10 || passphrase.length() > 79) {
                throw new IllegalArgumentException("passphrase must between 10 and 79 length");
            }
            this.commandsManager.setPassphrase(passphrase, type);
        }
    }

    public final void setOnlyAudio(boolean onlyAudio) {
        this.commandsManager.setAudioDisabled(false);
        this.commandsManager.setVideoDisabled(onlyAudio);
    }

    public final void setOnlyVideo(boolean onlyVideo) {
        this.commandsManager.setVideoDisabled(false);
        this.commandsManager.setAudioDisabled(onlyVideo);
    }

    public final void setCheckServerAlive(boolean enabled) {
        this.checkServerAlive = enabled;
    }

    public final void setReTries(int reTries) {
        this.numRetry = reTries;
        this.reTries = reTries;
    }

    public final boolean shouldRetry(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        boolean validReason = this.doingRetry && !StringsKt.contains$default((CharSequence)reason, (CharSequence)"Endpoint malformed", (boolean)false, (int)2, null);
        return validReason && this.reTries > 0;
    }

    @JvmOverloads
    public final void connect(@Nullable String url, boolean isRetry) {
        if (!isRetry) {
            this.doingRetry = true;
        }
        if (!this.isStreaming || isRetry) {
            this.isStreaming = true;
            this.job = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(url, this, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ String $url;
                final /* synthetic */ SrtClient this$0;
                {
                    this.$url = $url;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Exception decompiling
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[SWITCH], 13[CASE]], but top level block is 3[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.dump(StructuredIf.java:61)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public static /* synthetic */ void connect$default(SrtClient srtClient, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        srtClient.connect(string, bl);
    }

    public final void disconnect() {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SrtClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SrtClient.access$disconnect(this.this$0, true, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object disconnect(boolean var1_1, Continuation<? super Unit> var2_2) {
        block21: {
            block20: {
                if (!(var2_2 instanceof disconnect.2)) ** GOTO lbl-1000
                var7_3 = var2_2;
                if ((var7_3.label & -2147483648) != 0) {
                    var7_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var2_2){
                        Object L$0;
                        boolean Z$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ SrtClient this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return SrtClient.access$disconnect(this.this$0, false, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.isStreaming) {
                            $continuation.L$0 = this;
                            $continuation.Z$0 = clear;
                            $continuation.label = 1;
                            v0 = this.srtSender.stop(clear != false, (Continuation<? super Unit>)$continuation);
                            if (v0 == var8_5) {
                                return var8_5;
                            }
                        }
                        ** GOTO lbl25
                    }
                    case 1: {
                        clear = $continuation.Z$0;
                        this = (SrtClient)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 2 sources

                        var3_6 = this;
                        $this$disconnect_u24lambda_u240 = var3_6;
                        $i$a$-runCatching-SrtClient$disconnect$3 = false;
                        $continuation.L$0 = this;
                        $continuation.Z$0 = clear;
                        $continuation.label = 2;
                        v1 = $this$disconnect_u24lambda_u240.commandsManager.writeShutdown($this$disconnect_u24lambda_u240.socket, (Continuation<? super Unit>)$continuation);
                        ** if (v1 != var8_5) goto lbl37
lbl36:
                        // 1 sources

                        return var8_5;
lbl37:
                        // 1 sources

                        ** GOTO lbl46
                    }
                    case 2: {
                        $i$a$-runCatching-SrtClient$disconnect$3 = false;
                        clear = $continuation.Z$0;
                        this = (SrtClient)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl46:
                            // 2 sources

                            var4_7 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable var5_11) {
                            var4_8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var5_11));
                        }
                        v2 = this.socket;
                        if (v2 != null) {
                            v2.close();
                        }
                        if (!clear) break block20;
                        this.reTries = this.numRetry;
                        this.doingRetry = false;
                        this.isStreaming = false;
                        $continuation.L$0 = this;
                        $continuation.label = 3;
                        v3 = ExtensionsKt.onMainThread((Function0)((Function0)new Function0<Unit>(this){
                            final /* synthetic */ SrtClient this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                SrtClient.access$getConnectChecker$p(this.this$0).onDisconnect();
                            }
                        }), (Continuation)$continuation);
                        if (v3 == var8_5) {
                            return var8_5;
                        }
                        ** GOTO lbl68
                    }
                    case 3: {
                        this = (SrtClient)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl68:
                        // 2 sources

                        v4 = this.jobRetry;
                        if (v4 == null) break;
                        $continuation.L$0 = this;
                        $continuation.label = 4;
                        v5 = JobKt.cancelAndJoin((Job)v4, (Continuation)$continuation);
                        if (v5 == var8_5) {
                            return var8_5;
                        }
                        break;
                    }
                    case 4: {
                        this = (SrtClient)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
                        break;
                    }
                }
                this.jobRetry = null;
                CoroutineScopeKt.cancel$default((CoroutineScope)this.scopeRetry, null, (int)1, null);
                this.scopeRetry = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
            }
            this.commandsManager.reset();
            v6 = this.job;
            if (v6 == null) break block21;
            $continuation.L$0 = this;
            $continuation.label = 5;
            v7 = JobKt.cancelAndJoin((Job)v6, (Continuation)$continuation);
            if (v7 == var8_5) {
                return var8_5;
            }
            break block21;
            {
                case 5: {
                    this = (SrtClient)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
                    break;
                }
            }
        }
        this.job = null;
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void reConnect(long delay) {
        this.reConnect(delay, null);
    }

    public final void reConnect(long delay, @Nullable String backupUrl) {
        this.jobRetry = BuildersKt.launch$default((CoroutineScope)this.scopeRetry, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, delay, backupUrl, null){
            int label;
            final /* synthetic */ SrtClient this$0;
            final /* synthetic */ long $delay;
            final /* synthetic */ String $backupUrl;
            {
                this.this$0 = $receiver;
                this.$delay = $delay;
                this.$backupUrl = $backupUrl;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = this.this$0;
                        var3_4 = SrtClient.access$getReTries$p(var2_3);
                        SrtClient.access$setReTries$p(var2_3, var3_4 + -1);
                        this.label = 1;
                        v0 = SrtClient.access$disconnect(this.this$0, false, (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.label = 2;
                        v1 = DelayKt.delay((long)this.$delay, (Continuation)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        if ((v2 = this.$backupUrl) == null) {
                            v2 = SrtClient.access$getUrl$p(this.this$0);
                        }
                        reconnectUrl = v2;
                        this.this$0.connect(reconnectUrl, true);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object handleServerPackets(Continuation<? super Unit> var1_1) throws IOException {
        if (!(var1_1 instanceof handleServerPackets.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SrtClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SrtClient.access$handleServerPackets(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ** break;
            }
            case 1: {
                $i$a$-runCatching-SrtClient$handleServerPackets$error$1 = false;
                this = (SrtClient)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl57
                }
                catch (Throwable var5_9) {
                    var4_7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var5_9));
lbl24:
                    // 2 sources

                    ** while ((error = Result.exceptionOrNull-impl((Object)var4_7)) == null || error instanceof SocketTimeoutException)
                }
            }
lbl-1000:
            // 3 sources

            {
                while (CoroutineScopeKt.isActive((CoroutineScope)this.scope) && this.isStreaming) {
                    var3_6 = this;
                    {
                        $this$handleServerPackets_u24lambda_u241 = var3_6;
                        $i$a$-runCatching-SrtClient$handleServerPackets$error$1 = false;
                        if (!$this$handleServerPackets_u24lambda_u241.isAlive()) ** GOTO lbl39
                        $continuation.L$0 = this;
                        $continuation.L$1 = null;
                        $continuation.label = 1;
                        v0 = $this$handleServerPackets_u24lambda_u241.handleMessages((Continuation<? super Unit>)$continuation);
                        ** if (v0 != var8_4) goto lbl38
                    }
lbl37:
                    // 1 sources

                    return var8_4;
lbl38:
                    // 1 sources

                    ** GOTO lbl57
lbl39:
                    // 1 sources

                    $continuation.L$0 = this;
                    $continuation.L$1 = $this$handleServerPackets_u24lambda_u241;
                    $continuation.label = 2;
                    v1 = ExtensionsKt.onMainThread((Function0)((Function0)new Function0<Unit>($this$handleServerPackets_u24lambda_u241){
                        final /* synthetic */ SrtClient $this_runCatching;
                        {
                            this.$this_runCatching = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            SrtClient.access$getConnectChecker$p(this.$this_runCatching).onConnectionFailed("No response from server");
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var8_4) {
                        return var8_4;
                    }
                    ** GOTO lbl55
                }
                return Unit.INSTANCE;
lbl47:
                // 1 sources

                ** GOTO lbl59
            }
            case 2: {
                $i$a$-runCatching-SrtClient$handleServerPackets$error$1 = false;
                $this$handleServerPackets_u24lambda_u241 = (SrtClient)$continuation.L$1;
                this = (SrtClient)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl55:
                    // 2 sources

                    CoroutineScopeKt.cancel$default((CoroutineScope)$this$handleServerPackets_u24lambda_u241.scope, null, (int)1, null);
lbl57:
                    // 3 sources

                    var4_7 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                ** GOTO lbl24
lbl59:
                // 1 sources

                CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
                ** break;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isAlive() {
        boolean connected;
        SrtSocket srtSocket = this.socket;
        boolean bl = connected = srtSocket != null ? srtSocket.isConnected() : false;
        if (!this.checkServerAlive) {
            return connected;
        }
        SrtSocket srtSocket2 = this.socket;
        boolean reachable = srtSocket2 != null ? srtSocket2.isReachable() : false;
        return connected && !reachable ? false : connected;
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleMessages(Continuation<? super Unit> var1_1) throws IOException {
        block20: {
            block23: {
                block22: {
                    block21: {
                        if (!(var1_1 instanceof handleMessages.1)) ** GOTO lbl-1000
                        var9_2 = var1_1;
                        if ((var9_2.label & -2147483648) != 0) {
                            var9_2.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var1_1){
                                Object L$0;
                                int I$0;
                                /* synthetic */ Object result;
                                final /* synthetic */ SrtClient this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return SrtClient.access$handleMessages(this.this$0, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = this.socket;
                                if (v0 == null) ** GOTO lbl17
                                v1 = v0.readBuffer();
                                v0 = v1;
                                if (v1 != null) ** GOTO lbl18
lbl17:
                                // 2 sources

                                throw new IOException("read buffer failed, socket disconnected");
lbl18:
                                // 1 sources

                                responseBufferConclusion = v0;
                                srtPacket = SrtPacket.Companion.getSrtPacket((byte[])responseBufferConclusion);
                                var4_7 = srtPacket;
                                if (var4_7 instanceof DataPacket || !(var4_7 instanceof ControlPacket) || (var5_8 = srtPacket) instanceof Handshake) break block20;
                                if (!(var5_8 instanceof KeepAlive)) break;
                                $continuation.label = 1;
                                v2 = this.commandsManager.writeKeepAlive(this.socket, (Continuation<? super Unit>)$continuation);
                                if (v2 == var10_4) {
                                    return var10_4;
                                }
                                ** GOTO lbl31
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl31:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        if (!(var5_8 instanceof Ack)) break block21;
                        ackSequence = ((ControlPacket)srtPacket).getTypeSpecificInformation();
                        lastPacketSequence = ((Ack)srtPacket).getLastAcknowledgedPacketSequenceNumber();
                        $continuation.L$0 = this;
                        $continuation.I$0 = ackSequence;
                        $continuation.label = 2;
                        v3 = this.commandsManager.updateHandlingQueue(lastPacketSequence, (Continuation<? super Unit>)$continuation);
                        if (v3 == var10_4) {
                            return var10_4;
                        }
                        ** GOTO lbl47
                        {
                            case 2: {
                                ackSequence = $continuation.I$0;
                                this = (SrtClient)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl47:
                                // 2 sources

                                $continuation.L$0 = null;
                                $continuation.label = 3;
                                v4 = this.commandsManager.writeAck2(ackSequence, this.socket, (Continuation<? super Unit>)$continuation);
                                if (v4 == var10_4) {
                                    return var10_4;
                                }
                                ** GOTO lbl56
                            }
                            case 3: {
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl56:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                    }
                    if (!(var5_8 instanceof Nak)) break block22;
                    packetsLost = ((Nak)srtPacket).getNakPacketsLostList();
                    $continuation.label = 4;
                    v5 = this.commandsManager.reSendPackets(packetsLost, this.socket, (Continuation<? super Unit>)$continuation);
                    if (v5 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl68
                    {
                        case 4: {
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl68:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                }
                if (var5_8 instanceof CongestionWarning) break block20;
                if (!(var5_8 instanceof Shutdown)) break block23;
                $continuation.label = 5;
                v6 = ExtensionsKt.onMainThread((Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ SrtClient this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        SrtClient.access$getConnectChecker$p(this.this$0).onConnectionFailed("Shutdown received from server");
                    }
                }), (Continuation)$continuation);
                if (v6 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl80
                {
                    case 5: {
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl80:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
            }
            if (!(var5_8 instanceof Ack2) && !(var5_8 instanceof DropReq) && var5_8 instanceof PeerError) {
                reason = ((PeerError)srtPacket).getErrorCode();
                this.connectChecker.onConnectionFailed("PeerError: " + reason);
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.srtSender.setAudioInfo(sampleRate, isStereo);
    }

    public final void setVideoInfo(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Log.i((String)this.TAG, (String)"send sps and pps");
        this.srtSender.setVideoInfo(sps, pps, vps);
    }

    public final void sendVideo(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!this.commandsManager.getVideoDisabled()) {
            this.srtSender.sendVideoFrame(h264Buffer, info);
        }
    }

    public final void sendAudio(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!this.commandsManager.getAudioDisabled()) {
            this.srtSender.sendAudioFrame(aacBuffer, info);
        }
    }

    public final boolean hasCongestion() throws IllegalArgumentException {
        return this.hasCongestion(20.0f);
    }

    public final boolean hasCongestion(float percentUsed) throws IllegalArgumentException {
        return this.srtSender.hasCongestion(percentUsed);
    }

    public final void resetSentAudioFrames() {
        this.srtSender.resetSentAudioFrames();
    }

    public final void resetSentVideoFrames() {
        this.srtSender.resetSentVideoFrames();
    }

    public final void resetDroppedAudioFrames() {
        this.srtSender.resetDroppedAudioFrames();
    }

    public final void resetDroppedVideoFrames() {
        this.srtSender.resetDroppedVideoFrames();
    }

    public final void resizeCache(int newSize) throws RuntimeException {
        this.srtSender.resizeCache(newSize);
    }

    public final void setLogs(boolean enable) {
        this.srtSender.setLogs(enable);
    }

    public final void clearCache() {
        this.srtSender.clearCache();
    }

    public final int getItemsInCache() {
        return this.srtSender.getItemsInCache();
    }

    @JvmOverloads
    public final void connect(@Nullable String url) {
        SrtClient.connect$default(this, url, false, 2, null);
    }

    public static final /* synthetic */ void access$setStreaming$p(SrtClient $this, boolean bl) {
        $this.isStreaming = bl;
    }

    public static final /* synthetic */ ConnectChecker access$getConnectChecker$p(SrtClient $this) {
        return $this.connectChecker;
    }

    public static final /* synthetic */ void access$setUrl$p(SrtClient $this, String string) {
        $this.url = string;
    }

    public static final /* synthetic */ Pattern access$getUrlPattern$p(SrtClient $this) {
        return $this.urlPattern;
    }

    public static final /* synthetic */ CommandsManager access$getCommandsManager$p(SrtClient $this) {
        return $this.commandsManager;
    }

    public static final /* synthetic */ String access$getTAG$p(SrtClient $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ void access$setSocket$p(SrtClient $this, SrtSocket srtSocket) {
        $this.socket = srtSocket;
    }

    public static final /* synthetic */ SrtSocket access$getSocket$p(SrtClient $this) {
        return $this.socket;
    }

    public static final /* synthetic */ SrtSender access$getSrtSender$p(SrtClient $this) {
        return $this.srtSender;
    }

    public static final /* synthetic */ Object access$handleServerPackets(SrtClient $this, Continuation $completion) {
        return $this.handleServerPackets((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$disconnect(SrtClient $this, boolean clear, Continuation $completion) {
        return $this.disconnect(clear, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ int access$getReTries$p(SrtClient $this) {
        return $this.reTries;
    }

    public static final /* synthetic */ void access$setReTries$p(SrtClient $this, int n) {
        $this.reTries = n;
    }

    public static final /* synthetic */ String access$getUrl$p(SrtClient $this) {
        return $this.url;
    }

    public static final /* synthetic */ Object access$handleMessages(SrtClient $this, Continuation $completion) {
        return $this.handleMessages((Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H264.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.H265.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.AAC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

