/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.psi;

import com.pedro.srt.mpeg2ts.Codec;
import com.pedro.srt.mpeg2ts.psi.Pat;
import com.pedro.srt.mpeg2ts.psi.Pmt;
import com.pedro.srt.mpeg2ts.psi.Sdt;
import com.pedro.srt.mpeg2ts.psi.TableToSend;
import com.pedro.srt.mpeg2ts.service.Mpeg2TsService;
import com.pedro.srt.mpeg2ts.service.Track;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "", "service", "Lcom/pedro/srt/mpeg2ts/service/Mpeg2TsService;", "(Lcom/pedro/srt/mpeg2ts/service/Mpeg2TsService;)V", "idExtension", "", "pat", "Lcom/pedro/srt/mpeg2ts/psi/Pat;", "patCount", "", "sdt", "Lcom/pedro/srt/mpeg2ts/psi/Sdt;", "sdtCount", "getAudioPid", "getPat", "getPmt", "Lcom/pedro/srt/mpeg2ts/psi/Pmt;", "getSdt", "getVideoPid", "reset", "", "shouldSend", "Lcom/pedro/srt/mpeg2ts/psi/TableToSend;", "isKey", "", "updateService", "upgradePatVersion", "upgradeSdtVersion", "Companion", "srt_release"})
@SourceDebugExtension(value={"SMAP\nPsiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiManager.kt\ncom/pedro/srt/mpeg2ts/psi/PsiManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class PsiManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Mpeg2TsService service;
    private final short idExtension;
    private int sdtCount;
    private int patCount;
    @NotNull
    private Sdt sdt;
    @NotNull
    private Pat pat;
    public static final int sdtPeriod = 200;
    public static final int patPeriod = 40;

    public PsiManager(@NotNull Mpeg2TsService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
        this.idExtension = (short)Random.Default.nextInt(-128, 127);
        this.sdt = new Sdt(this.idExtension, 0, 0, this.service, 4, null);
        this.pat = new Pat(this.idExtension, 0, this.service);
    }

    @NotNull
    public final TableToSend shouldSend(boolean isKey) {
        TableToSend value = TableToSend.NONE;
        if (this.sdtCount >= 200 && this.patCount >= 40) {
            value = TableToSend.ALL;
            this.sdtCount = 0;
            this.patCount = 0;
        } else if (this.patCount >= 40 || isKey) {
            value = TableToSend.PAT_PMT;
            this.patCount = 0;
        } else if (this.sdtCount >= 200) {
            value = TableToSend.SDT;
            this.sdtCount = 0;
        }
        int n = this.sdtCount;
        this.sdtCount = n + 1;
        n = this.patCount;
        this.patCount = n + 1;
        return value;
    }

    public static /* synthetic */ TableToSend shouldSend$default(PsiManager psiManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return psiManager.shouldSend(bl);
    }

    public final void upgradeSdtVersion() {
        this.sdt.setVersion((byte)(this.sdt.getVersion() + 1));
    }

    public final void upgradePatVersion() {
        this.pat.setVersion((byte)(this.pat.getVersion() + 1));
    }

    public final short getAudioPid() {
        Object v0;
        block1: {
            Iterable iterable = this.service.getTracks();
            for (Object t : iterable) {
                Track it = (Track)t;
                boolean bl = false;
                if (!(it.getCodec() == Codec.AAC)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Track track = v0;
        return track != null ? track.getPid() : (short)0;
    }

    public final short getVideoPid() {
        Object v0;
        block1: {
            Iterable iterable = this.service.getTracks();
            for (Object t : iterable) {
                Track it = (Track)t;
                boolean bl = false;
                if (!(it.getCodec() != Codec.AAC)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Track track = v0;
        return track != null ? track.getPid() : (short)0;
    }

    @NotNull
    public final Sdt getSdt() {
        return this.sdt;
    }

    @NotNull
    public final Pat getPat() {
        return this.pat;
    }

    @NotNull
    public final Pmt getPmt() {
        Pmt pmt = this.service.getPmt();
        Intrinsics.checkNotNull((Object)pmt);
        return pmt;
    }

    public final void reset() {
        this.sdtCount = 0;
        this.patCount = 0;
    }

    public final void updateService(@NotNull Mpeg2TsService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
        this.sdt.setService(service);
        this.pat.setService(service);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pedro/srt/mpeg2ts/psi/PsiManager$Companion;", "", "()V", "patPeriod", "", "sdtPeriod", "srt_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

