/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J>\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J8\u0010\u0018\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/pedro/rtsp/rtcp/SenderReportTcp;", "Lcom/pedro/rtsp/rtcp/BaseSenderReport;", "<init>", "()V", "outputStream", "Ljava/io/OutputStream;", "tcpHeader", "", "setDataStream", "", "host", "", "sendReport", "buffer", "rtpFrame", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "type", "packetCount", "", "octetCount", "isEnableLogs", "", "([BLcom/pedro/rtsp/rtsp/RtpFrame;Ljava/lang/String;JJZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "sendReportTCP", "channelIdentifier", "", "packet", "octet", "rtsp_release"})
public final class SenderReportTcp
extends BaseSenderReport {
    @Nullable
    private OutputStream outputStream;
    @NotNull
    private final byte[] tcpHeader;

    public SenderReportTcp() {
        byte[] byArray = new byte[]{36, 0, 0, (byte)this.getPACKET_LENGTH()};
        this.tcpHeader = byArray;
    }

    @Override
    public void setDataStream(@NotNull OutputStream outputStream, @NotNull String host) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.outputStream = outputStream;
    }

    @Override
    @Nullable
    public Object sendReport(@NotNull byte[] buffer, @NotNull RtpFrame rtpFrame, @NotNull String type, long packetCount, long octetCount, boolean isEnableLogs, @NotNull Continuation<? super Unit> $completion) throws IOException {
        this.sendReportTCP(buffer, rtpFrame.getChannelIdentifier(), type, packetCount, octetCount, isEnableLogs);
        return Unit.INSTANCE;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendReportTCP(byte[] buffer, int channelIdentifier, String type, long packet, long octet, boolean isEnableLogs) throws IOException {
        Object object = RtpConstants.lock;
        synchronized (object) {
            boolean bl = false;
            this.tcpHeader[1] = (byte)(2 * channelIdentifier + 1);
            OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                outputStream.write(this.tcpHeader);
            }
            OutputStream outputStream2 = this.outputStream;
            if (outputStream2 != null) {
                outputStream2.write(buffer, 0, this.getPACKET_LENGTH());
            }
            OutputStream outputStream3 = this.outputStream;
            if (outputStream3 != null) {
                outputStream3.flush();
            }
            if (isEnableLogs) {
                Log.i((String)this.getTAG(), (String)("wrote report: " + type + ", packets: " + packet + ", octet: " + octet));
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

