/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.av1.Av1Parser;
import com.pedro.common.av1.Obu;
import com.pedro.common.av1.ObuType;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\fH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/pedro/rtsp/rtp/packets/Av1Packet;", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "()V", "parser", "Lcom/pedro/common/av1/Av1Parser;", "createAndSendPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "callback", "Lkotlin/Function1;", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "generateAv1AggregationHeader", "", "isKeyFrame", "", "isFirstPacket", "isLastPacket", "numObu", "", "reset", "rtsp_release"})
@SourceDebugExtension(value={"SMAP\nAv1Packet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1Packet.kt\ncom/pedro/rtsp/rtp/packets/Av1Packet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1864#2,3:116\n*S KotlinDebug\n*F\n+ 1 Av1Packet.kt\ncom/pedro/rtsp/rtp/packets/Av1Packet\n*L\n67#1:116,3\n*E\n"})
public final class Av1Packet
extends BasePacket {
    @NotNull
    private final Av1Parser parser = new Av1Parser();

    public Av1Packet() {
        super(90000L, 96 + RtpConstants.INSTANCE.getTrackVideo());
        this.setChannelIdentifier(RtpConstants.INSTANCE.getTrackVideo());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createAndSendPacket(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo bufferInfo, @NotNull Function1<? super RtpFrame, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)byteBuffer, (MediaCodec.BufferInfo)bufferInfo);
        if (this.parser.getObuType(fixedBuffer.get(0)) == ObuType.TEMPORAL_DELIMITER) {
            fixedBuffer.position(2);
            ByteBuffer byteBuffer2 = fixedBuffer.slice();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"slice(...)");
            fixedBuffer = byteBuffer2;
        }
        ByteBuffer byteBuffer3 = fixedBuffer.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"duplicate(...)");
        List obuList = this.parser.getObus(ExtensionsKt.toByteArray((ByteBuffer)byteBuffer3));
        long ts = bufferInfo.presentationTimeUs * 1000L;
        if (obuList.isEmpty()) {
            return;
        }
        byte[] data = null;
        data = new byte[]{};
        Iterable $this$forEachIndexed$iv = obuList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void obu;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Obu obu2 = (Obu)item$iv;
            int index = n;
            boolean bl = false;
            byte[] obuData = obu.getFullData();
            data = index == obuList.size() - 1 ? ArraysKt.plus((byte[])data, (byte[])obuData) : ArraysKt.plus((byte[])data, (byte[])ArraysKt.plus((byte[])this.parser.writeLeb128((long)obuData.length), (byte[])obuData));
        }
        ByteBuffer byteBuffer4 = ByteBuffer.wrap(data);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer4, (String)"wrap(...)");
        fixedBuffer = byteBuffer4;
        int size = fixedBuffer.remaining();
        int sum = 0;
        while (sum < size) {
            boolean isFirstPacket = sum == 0;
            boolean isLastPacket = false;
            int length = size - sum > this.getMaxPacketSize() - 12 - 1 ? this.getMaxPacketSize() - 12 - 1 : fixedBuffer.remaining();
            byte[] buffer = this.getBuffer(length + 12 + 1);
            long rtpTs = this.updateTimeStamp(buffer, ts);
            fixedBuffer.get(buffer, 13, length);
            if ((sum += length) >= size) {
                isLastPacket = true;
                this.markPacket(buffer);
            }
            int oSize = isFirstPacket ? obuList.size() : 1;
            buffer[12] = this.generateAv1AggregationHeader(ExtensionsKt.isKeyframe((MediaCodec.BufferInfo)bufferInfo), isFirstPacket, isLastPacket, oSize);
            this.updateSeq(buffer);
            RtpFrame rtpFrame2 = new RtpFrame(buffer, rtpTs, buffer.length, this.getRtpPort(), this.getRtcpPort(), this.getChannelIdentifier());
            callback.invoke((Object)rtpFrame2);
        }
    }

    @Override
    public void reset() {
        super.reset();
    }

    private final byte generateAv1AggregationHeader(boolean isKeyFrame, boolean isFirstPacket, boolean isLastPacket, int numObu) {
        int z = isFirstPacket ? 0 : 1;
        int y = isLastPacket ? 0 : 1;
        int w = numObu;
        int n = isKeyFrame && isFirstPacket ? 1 : 0;
        return (byte)(z << 7 | y << 6 | w << 4 | n << 3 | 0);
    }
}

