/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J!\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcom/pedro/rtsp/rtp/sockets/RtpSocketUdp;", "Lcom/pedro/rtsp/rtp/sockets/BaseRtpSocket;", "videoSourcePort", "", "audioSourcePort", "multicastSocketVideo", "Ljava/net/MulticastSocket;", "multicastSocketAudio", "(IILjava/net/MulticastSocket;Ljava/net/MulticastSocket;)V", "datagramPacket", "Ljava/net/DatagramPacket;", "close", "", "sendFrame", "rtpFrame", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "isEnableLogs", "", "(Lcom/pedro/rtsp/rtsp/RtpFrame;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendFrameUDP", "setDataStream", "outputStream", "Ljava/io/OutputStream;", "host", "", "rtsp_release"})
public final class RtpSocketUdp
extends BaseRtpSocket {
    @Nullable
    private MulticastSocket multicastSocketVideo;
    @Nullable
    private MulticastSocket multicastSocketAudio;
    @NotNull
    private final DatagramPacket datagramPacket;

    public RtpSocketUdp(int videoSourcePort, int audioSourcePort, @Nullable MulticastSocket multicastSocketVideo, @Nullable MulticastSocket multicastSocketAudio) {
        this.multicastSocketVideo = multicastSocketVideo;
        this.multicastSocketAudio = multicastSocketAudio;
        byte[] byArray = new byte[]{0};
        this.datagramPacket = new DatagramPacket(byArray, 1);
        if (this.multicastSocketVideo == null) {
            this.multicastSocketVideo = new MulticastSocket(videoSourcePort);
        }
        MulticastSocket multicastSocket = this.multicastSocketVideo;
        if (multicastSocket != null) {
            multicastSocket.setTimeToLive(64);
        }
        if (this.multicastSocketAudio == null) {
            this.multicastSocketAudio = new MulticastSocket(audioSourcePort);
        }
        MulticastSocket multicastSocket2 = this.multicastSocketAudio;
        if (multicastSocket2 != null) {
            multicastSocket2.setTimeToLive(64);
        }
    }

    public /* synthetic */ RtpSocketUdp(int n, int n2, MulticastSocket multicastSocket, MulticastSocket multicastSocket2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            multicastSocket = null;
        }
        if ((n3 & 8) != 0) {
            multicastSocket2 = null;
        }
        this(n, n2, multicastSocket, multicastSocket2);
    }

    @Override
    public void setDataStream(@NotNull OutputStream outputStream, @NotNull String host) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.datagramPacket.setAddress(InetAddress.getByName(host));
    }

    @Override
    @Nullable
    public Object sendFrame(@NotNull RtpFrame rtpFrame2, boolean isEnableLogs, @NotNull Continuation<? super Unit> $completion) throws IOException {
        this.sendFrameUDP(rtpFrame2, isEnableLogs);
        return Unit.INSTANCE;
    }

    @Override
    public void close() {
        block1: {
            MulticastSocket multicastSocket = this.multicastSocketVideo;
            if (multicastSocket != null) {
                multicastSocket.close();
            }
            MulticastSocket multicastSocket2 = this.multicastSocketAudio;
            if (multicastSocket2 == null) break block1;
            multicastSocket2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendFrameUDP(RtpFrame rtpFrame2, boolean isEnableLogs) throws IOException {
        Object object = RtpConstants.lock;
        synchronized (object) {
            boolean bl = false;
            this.datagramPacket.setData(rtpFrame2.getBuffer());
            this.datagramPacket.setPort(rtpFrame2.getRtpPort());
            this.datagramPacket.setLength(rtpFrame2.getLength());
            if (rtpFrame2.isVideoFrame()) {
                MulticastSocket multicastSocket = this.multicastSocketVideo;
                if (multicastSocket != null) {
                    multicastSocket.send(this.datagramPacket);
                }
            } else {
                MulticastSocket multicastSocket = this.multicastSocketAudio;
                if (multicastSocket != null) {
                    multicastSocket.send(this.datagramPacket);
                }
            }
            if (isEnableLogs) {
                Log.i((String)this.getTAG(), (String)("wrote packet: " + (rtpFrame2.isVideoFrame() ? "Video" : "Audio") + ", size: " + rtpFrame2.getLength() + ", port: " + rtpFrame2.getRtpPort()));
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

