/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp.commands;

import android.util.Log;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.commands.Command;
import com.pedro.rtsp.rtsp.commands.CommandParser;
import com.pedro.rtsp.rtsp.commands.Method;
import com.pedro.rtsp.rtsp.commands.SdpBody;
import com.pedro.rtsp.utils.AuthUtil;
import com.pedro.rtsp.utils.ExtensionsKt;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 c2\u00020\u0001:\u0001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010E\u001a\u00020\u0014H\u0002J\u0006\u0010F\u001a\u00020GJ\u0006\u0010H\u001a\u00020\u0014J\u000e\u0010I\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u0014J\u0010\u0010K\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u0014H\u0002J\b\u0010L\u001a\u00020\u0014H\u0002J\u0006\u0010M\u001a\u00020\u0014J\u0006\u0010N\u001a\u00020\u0014J\u0006\u0010O\u001a\u00020\u0014J\u0006\u0010P\u001a\u00020\u0014J\u0006\u0010Q\u001a\u00020\u0014J\u0006\u0010R\u001a\u00020\u0014J\u0006\u0010S\u001a\u00020\u0014J\u0010\u0010T\u001a\u00020\u00142\u0006\u0010U\u001a\u00020\u0010H\u0016J\u0006\u0010V\u001a\u00020\u0014J\u0018\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\b\b\u0002\u0010[\u001a\u00020\\J\u0006\u0010]\u001a\u00020GJ\u0016\u0010^\u001a\u00020G2\u0006\u0010-\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\bJ\u001a\u0010_\u001a\u00020G2\b\u00108\u001a\u0004\u0018\u00010\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014J\"\u0010`\u001a\u00020G2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014J \u0010a\u001a\u00020G2\u0006\u00102\u001a\u00020b2\u0006\u0010\"\u001a\u00020b2\b\u0010A\u001a\u0004\u0018\u00010bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\n\"\u0004\b\u0019\u0010\fR\"\u0010\u001a\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\"\u0010\u001c\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u001e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u0013\u001a\u0004\u0018\u00010!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0017R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010 \"\u0004\b/\u00100R\u0010\u00101\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00102\u001a\u0004\u0018\u00010!2\b\u0010\u0013\u001a\u0004\u0018\u00010!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010$R\u0014\u00104\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0017R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00108\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0017R\u0011\u0010:\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0006R\u001a\u0010<\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\n\"\u0004\b>\u0010\fR\u0011\u0010?\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0006R\"\u0010A\u001a\u0004\u0018\u00010!2\b\u0010\u0013\u001a\u0004\u0018\u00010!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010$R\u0014\u0010C\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u0017\u00a8\u0006d"}, d2={"Lcom/pedro/rtsp/rtsp/commands/CommandsManager;", "", "()V", "audioClientPorts", "", "getAudioClientPorts", "()[I", "audioDisabled", "", "getAudioDisabled", "()Z", "setAudioDisabled", "(Z)V", "audioServerPorts", "getAudioServerPorts", "cSeq", "", "commandParser", "Lcom/pedro/rtsp/rtsp/commands/CommandParser;", "<set-?>", "", "host", "getHost", "()Ljava/lang/String;", "isStereo", "setStereo", "password", "getPassword", "path", "getPath", "port", "getPort", "()I", "", "pps", "getPps", "()[B", "ppsString", "getPpsString", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "getProtocol", "()Lcom/pedro/rtsp/rtsp/Protocol;", "setProtocol", "(Lcom/pedro/rtsp/rtsp/Protocol;)V", "sampleRate", "getSampleRate", "setSampleRate", "(I)V", "sessionId", "sps", "getSps", "spsString", "getSpsString", "timeStamp", "", "user", "getUser", "videoClientPorts", "getVideoClientPorts", "videoDisabled", "getVideoDisabled", "setVideoDisabled", "videoServerPorts", "getVideoServerPorts", "vps", "getVps", "vpsString", "getVpsString", "addHeaders", "clear", "", "createAnnounce", "createAnnounceWithAuth", "authResponse", "createAuth", "createBody", "createGetParameter", "createOptions", "createPause", "createPlay", "createRecord", "createRedirect", "createSetParameter", "createSetup", "track", "createTeardown", "getResponse", "Lcom/pedro/rtsp/rtsp/commands/Command;", "reader", "Ljava/io/BufferedReader;", "method", "Lcom/pedro/rtsp/rtsp/commands/Method;", "retryClear", "setAudioInfo", "setAuth", "setUrl", "setVideoInfo", "Ljava/nio/ByteBuffer;", "Companion", "rtsp_release"})
public class CommandsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String host;
    private int port;
    @Nullable
    private String path;
    @Nullable
    private byte[] sps;
    @Nullable
    private byte[] pps;
    private int cSeq;
    @Nullable
    private String sessionId;
    private final long timeStamp;
    private int sampleRate = 32000;
    private boolean isStereo = true;
    @NotNull
    private Protocol protocol = Protocol.TCP;
    private boolean videoDisabled;
    private boolean audioDisabled;
    @NotNull
    private final CommandParser commandParser = new CommandParser();
    @NotNull
    private final int[] audioClientPorts;
    @NotNull
    private final int[] videoClientPorts;
    @NotNull
    private final int[] audioServerPorts;
    @NotNull
    private final int[] videoServerPorts;
    @Nullable
    private byte[] vps;
    @Nullable
    private String user;
    @Nullable
    private String password;
    @NotNull
    private static final String TAG = "CommandsManager";
    @Nullable
    private static String authorization;

    public CommandsManager() {
        int[] nArray = new int[]{5000, 5001};
        this.audioClientPorts = nArray;
        nArray = new int[]{5002, 5003};
        this.videoClientPorts = nArray;
        nArray = new int[]{5004, 5005};
        this.audioServerPorts = nArray;
        nArray = new int[]{5006, 5007};
        this.videoServerPorts = nArray;
        long uptime = System.currentTimeMillis();
        this.timeStamp = uptime / (long)1000 << 32 & (uptime - uptime / (long)1000 * (long)1000 >> 32) / (long)1000;
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final byte[] getSps() {
        return this.sps;
    }

    @Nullable
    public final byte[] getPps() {
        return this.pps;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public final boolean isStereo() {
        return this.isStereo;
    }

    public final void setStereo(boolean bl) {
        this.isStereo = bl;
    }

    @NotNull
    public final Protocol getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"<set-?>");
        this.protocol = protocol;
    }

    public final boolean getVideoDisabled() {
        return this.videoDisabled;
    }

    public final void setVideoDisabled(boolean bl) {
        this.videoDisabled = bl;
    }

    public final boolean getAudioDisabled() {
        return this.audioDisabled;
    }

    public final void setAudioDisabled(boolean bl) {
        this.audioDisabled = bl;
    }

    @NotNull
    public final int[] getAudioClientPorts() {
        return this.audioClientPorts;
    }

    @NotNull
    public final int[] getVideoClientPorts() {
        return this.videoClientPorts;
    }

    @NotNull
    public final int[] getAudioServerPorts() {
        return this.audioServerPorts;
    }

    @NotNull
    public final int[] getVideoServerPorts() {
        return this.videoServerPorts;
    }

    @Nullable
    public final byte[] getVps() {
        return this.vps;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final void setVideoInfo(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        this.sps = ExtensionsKt.getData(sps);
        this.pps = ExtensionsKt.getData(pps);
        ByteBuffer byteBuffer = vps;
        this.vps = (byte[])(byteBuffer != null ? ExtensionsKt.getData(byteBuffer) : null);
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.isStereo = isStereo;
        this.sampleRate = sampleRate;
    }

    public final void setAuth(@Nullable String user, @Nullable String password) {
        this.user = user;
        this.password = password;
    }

    public final void setUrl(@Nullable String host, int port, @Nullable String path) {
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public final void clear() {
        this.sps = null;
        this.pps = null;
        this.vps = null;
        this.retryClear();
    }

    public final void retryClear() {
        this.cSeq = 0;
        this.sessionId = null;
    }

    private final String getSpsString() {
        Object object;
        block3: {
            block2: {
                object = this.sps;
                if (this.sps == null) break block2;
                String string = ExtensionsKt.encodeToString$default(object, 0, 1, null);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String getPpsString() {
        Object object;
        block3: {
            block2: {
                object = this.pps;
                if (this.pps == null) break block2;
                String string = ExtensionsKt.encodeToString$default(object, 0, 1, null);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String getVpsString() {
        Object object;
        block3: {
            block2: {
                object = this.vps;
                if (this.vps == null) break block2;
                String string = ExtensionsKt.encodeToString$default(object, 0, 1, null);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String addHeaders() {
        ++this.cSeq;
        return "CSeq: " + this.cSeq + "\r\nUser-Agent: com.pedro.rtsp 2.1.9\r\n" + (this.sessionId == null ? "" : "Session: " + this.sessionId + "\r\n") + (authorization == null ? "" : "Authorization: " + authorization + "\r\n");
    }

    private final String createBody() {
        String videoBody = "";
        if (!this.videoDisabled) {
            videoBody = this.vps == null ? SdpBody.INSTANCE.createH264Body(RtpConstants.INSTANCE.getTrackVideo(), this.getSpsString(), this.getPpsString()) : SdpBody.INSTANCE.createH265Body(RtpConstants.INSTANCE.getTrackVideo(), this.getSpsString(), this.getPpsString(), this.getVpsString());
        }
        String audioBody = "";
        if (!this.audioDisabled) {
            audioBody = SdpBody.INSTANCE.createAacBody(RtpConstants.INSTANCE.getTrackAudio(), this.sampleRate, this.isStereo);
        }
        return "v=0\r\no=- " + this.timeStamp + ' ' + this.timeStamp + " IN IP4 127.0.0.1\r\ns=Unnamed\r\ni=N/A\r\nc=IN IP4 " + this.host + "\r\nt=0 0\r\na=recvonly\r\n" + videoBody + audioBody;
    }

    private final String createAuth(String authResponse) {
        String string;
        Pattern authPattern = Pattern.compile("realm=\"(.+)\",\\s+nonce=\"(\\w+)\"", 2);
        Matcher matcher = authPattern.matcher(authResponse);
        if (matcher.find()) {
            Log.i((String)TAG, (String)"using digest auth");
            String realm = matcher.group(1);
            String nonce = matcher.group(2);
            String hash1 = AuthUtil.getMd5Hash(this.user + ':' + realm + ':' + this.password);
            String hash2 = AuthUtil.getMd5Hash("ANNOUNCE:rtsp://" + this.host + ':' + this.port + this.path);
            String hash3 = AuthUtil.getMd5Hash(hash1 + ':' + nonce + ':' + hash2);
            string = "Digest username=\"" + this.user + "\", realm=\"" + realm + "\", nonce=\"" + nonce + "\", uri=\"rtsp://" + this.host + ':' + this.port + this.path + "\", response=\"" + hash3 + '\"';
        } else {
            String data;
            Log.i((String)TAG, (String)"using basic auth");
            String string2 = data = this.user + ':' + this.password;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            String base64Data = ExtensionsKt.encodeToString(byArray, 0);
            string = "Basic " + base64Data;
        }
        return string;
    }

    @NotNull
    public final String createOptions() {
        String options = "OPTIONS rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)options);
        return options;
    }

    @NotNull
    public String createSetup(int track) {
        int[] udpPorts = track == RtpConstants.INSTANCE.getTrackVideo() ? this.videoClientPorts : this.audioClientPorts;
        String params = this.protocol == Protocol.UDP ? "UDP;unicast;client_port=" + udpPorts[0] + '-' + udpPorts[1] + ";mode=record" : "TCP;unicast;interleaved=" + 2 * track + '-' + (2 * track + 1) + ";mode=record";
        String setup = "SETUP rtsp://" + this.host + ':' + this.port + this.path + "/streamid=" + track + " RTSP/1.0\r\nTransport: RTP/AVP/" + params + "\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)setup);
        return setup;
    }

    @NotNull
    public final String createRecord() {
        String record = "RECORD rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\nRange: npt=0.000-\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)record);
        return record;
    }

    @NotNull
    public final String createAnnounce() {
        String body = this.createBody();
        String announce = "ANNOUNCE rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\nContent-Type: application/sdp\r\n" + this.addHeaders() + "Content-Length: " + body.length() + "\r\n\r\n" + body;
        Log.i((String)TAG, (String)announce);
        return announce;
    }

    @NotNull
    public final String createAnnounceWithAuth(@NotNull String authResponse) {
        Intrinsics.checkNotNullParameter((Object)authResponse, (String)"authResponse");
        authorization = this.createAuth(authResponse);
        Log.i((String)"Auth", (String)String.valueOf(authorization));
        return this.createAnnounce();
    }

    @NotNull
    public final String createTeardown() {
        String teardown = "TEARDOWN rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)teardown);
        return teardown;
    }

    @NotNull
    public final Command getResponse(@NotNull BufferedReader reader, @NotNull Method method) throws IOException {
        Command command;
        String string;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        String response = "";
        String line = null;
        do {
            String string2;
            String it = string2 = reader.readLine();
            boolean bl = false;
            line = it;
            if (string2 == null) break;
            StringBuilder stringBuilder = new StringBuilder().append(response);
            String string3 = line;
            if (string3 == null) {
                string3 = "";
            }
            response = stringBuilder.append(string3).append('\n').toString();
            string = line;
        } while ((string != null ? string.length() : 0) >= 3);
        Log.i((String)TAG, (String)response);
        if (method == Method.UNKNOWN) {
            command = this.commandParser.parseCommand(response);
        } else {
            Command command2 = this.commandParser.parseResponse(method, response);
            this.sessionId = this.commandParser.getSessionId(command2);
            if (command2.getMethod() == Method.SETUP && this.protocol == Protocol.UDP) {
                this.commandParser.loadServerPorts(command2, this.protocol, this.audioClientPorts, this.videoClientPorts, this.audioServerPorts, this.videoServerPorts);
            }
            command = command2;
        }
        return command;
    }

    public static /* synthetic */ Command getResponse$default(CommandsManager commandsManager, BufferedReader bufferedReader, Method method, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getResponse");
        }
        if ((n & 2) != 0) {
            method = Method.UNKNOWN;
        }
        return commandsManager.getResponse(bufferedReader, method);
    }

    @NotNull
    public final String createPause() {
        return "";
    }

    @NotNull
    public final String createPlay() {
        return "";
    }

    @NotNull
    public final String createGetParameter() {
        return "";
    }

    @NotNull
    public final String createSetParameter() {
        return "";
    }

    @NotNull
    public final String createRedirect() {
        return "";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pedro/rtsp/rtsp/commands/CommandsManager$Companion;", "", "()V", "TAG", "", "authorization", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

