/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.util.Base64;
import android.util.Log;
import com.pedro.rtsp.rtsp.Body;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.utils.AuthUtil;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 c2\u00020\u0001:\u0001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010A\u001a\u00020\u000eH\u0002J\u0006\u0010B\u001a\u00020CJ\u0006\u0010D\u001a\u00020\u000eJ\u000e\u0010E\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u000eJ\u0010\u0010G\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u000eH\u0002J\b\u0010H\u001a\u00020\u000eH\u0002J\u0006\u0010I\u001a\u00020\u000eJ\u0006\u0010J\u001a\u00020\u000eJ\u0006\u0010K\u001a\u00020\u000eJ\u0006\u0010L\u001a\u00020\u000eJ\u0006\u0010M\u001a\u00020\u000eJ\u0006\u0010N\u001a\u00020\u000eJ\u0006\u0010O\u001a\u00020\u000eJ\u0010\u0010P\u001a\u00020\u000e2\u0006\u0010Q\u001a\u00020\fH\u0016J\u0006\u0010R\u001a\u00020\u000eJ\u0012\u0010S\u001a\u00020\u000e2\b\u0010T\u001a\u0004\u0018\u00010 H\u0002J\u0014\u0010U\u001a\u0004\u0018\u00010 2\b\u0010V\u001a\u0004\u0018\u00010WH\u0002J \u0010X\u001a\u00020\u000e2\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020\u00132\u0006\u0010\\\u001a\u00020\u0013J\u000e\u0010]\u001a\u00020\f2\u0006\u0010^\u001a\u00020\u000eJ\u0006\u0010_\u001a\u00020CJ\u001a\u0010`\u001a\u00020C2\b\u00107\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eJ\"\u0010a\u001a\u00020C2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eJ$\u0010b\u001a\u00020C2\b\u00101\u001a\u0004\u0018\u00010W2\b\u0010!\u001a\u0004\u0018\u00010W2\b\u0010=\u001a\u0004\u0018\u00010WR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\"\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\"\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u001e\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\"\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\r\u001a\u0004\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0011R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001f\"\u0004\b.\u0010/R\u0010\u00100\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00101\u001a\u0004\u0018\u00010 2\b\u0010\r\u001a\u0004\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010#R\u0014\u00103\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0011R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00107\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0011R\u0011\u00109\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\bR\u0011\u0010;\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\bR\"\u0010=\u001a\u0004\u0018\u00010 2\b\u0010\r\u001a\u0004\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010#R\u0014\u0010?\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0011\u00a8\u0006d"}, d2={"Lcom/pedro/rtsp/rtsp/CommandsManager;", "", "connectCheckerRtsp", "Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;", "(Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;)V", "audioClientPorts", "", "getAudioClientPorts", "()[I", "audioServerPorts", "getAudioServerPorts", "cSeq", "", "<set-?>", "", "host", "getHost", "()Ljava/lang/String;", "isOnlyAudio", "", "()Z", "setOnlyAudio", "(Z)V", "isStereo", "setStereo", "password", "getPassword", "path", "getPath", "port", "getPort", "()I", "", "pps", "getPps", "()[B", "ppsString", "getPpsString", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "getProtocol", "()Lcom/pedro/rtsp/rtsp/Protocol;", "setProtocol", "(Lcom/pedro/rtsp/rtsp/Protocol;)V", "sampleRate", "getSampleRate", "setSampleRate", "(I)V", "sessionId", "sps", "getSps", "spsString", "getSpsString", "timeStamp", "", "user", "getUser", "videoClientPorts", "getVideoClientPorts", "videoServerPorts", "getVideoServerPorts", "vps", "getVps", "vpsString", "getVpsString", "addHeaders", "clear", "", "createAnnounce", "createAnnounceWithAuth", "authResponse", "createAuth", "createBody", "createGetParameter", "createOptions", "createPause", "createPlay", "createRecord", "createRedirect", "createSetParameter", "createSetup", "track", "createTeardown", "encodeToString", "bytes", "getData", "byteBuffer", "Ljava/nio/ByteBuffer;", "getResponse", "reader", "Ljava/io/BufferedReader;", "isAudio", "checkStatus", "getResponseStatus", "response", "retryClear", "setAuth", "setUrl", "setVideoInfo", "Companion", "rtsp_release"})
public class CommandsManager {
    @Nullable
    private String host;
    private int port;
    @Nullable
    private String path;
    @Nullable
    private byte[] sps;
    @Nullable
    private byte[] pps;
    private int cSeq;
    private String sessionId;
    private final long timeStamp;
    private int sampleRate;
    private boolean isStereo;
    @NotNull
    private Protocol protocol;
    private boolean isOnlyAudio;
    @NotNull
    private final int[] audioClientPorts;
    @NotNull
    private final int[] videoClientPorts;
    @NotNull
    private final int[] audioServerPorts;
    @NotNull
    private final int[] videoServerPorts;
    @Nullable
    private byte[] vps;
    @Nullable
    private String user;
    @Nullable
    private String password;
    private final ConnectCheckerRtsp connectCheckerRtsp;
    private static final String TAG = "CommandsManager";
    private static String authorization;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final byte[] getSps() {
        return this.sps;
    }

    @Nullable
    public final byte[] getPps() {
        return this.pps;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public final boolean isStereo() {
        return this.isStereo;
    }

    public final void setStereo(boolean bl) {
        this.isStereo = bl;
    }

    @NotNull
    public final Protocol getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"<set-?>");
        this.protocol = protocol;
    }

    public final boolean isOnlyAudio() {
        return this.isOnlyAudio;
    }

    public final void setOnlyAudio(boolean bl) {
        this.isOnlyAudio = bl;
    }

    @NotNull
    public final int[] getAudioClientPorts() {
        return this.audioClientPorts;
    }

    @NotNull
    public final int[] getVideoClientPorts() {
        return this.videoClientPorts;
    }

    @NotNull
    public final int[] getAudioServerPorts() {
        return this.audioServerPorts;
    }

    @NotNull
    public final int[] getVideoServerPorts() {
        return this.videoServerPorts;
    }

    @Nullable
    public final byte[] getVps() {
        return this.vps;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] getData(ByteBuffer byteBuffer) {
        byte[] byArray;
        if (byteBuffer != null) {
            void var2_2;
            byte[] bytes = new byte[byteBuffer.capacity() - 4];
            byteBuffer.position(4);
            byteBuffer.get(bytes, 0, bytes.length);
            byArray = var2_2;
        } else {
            byArray = null;
        }
        return byArray;
    }

    private final String encodeToString(byte[] bytes) {
        if (bytes != null) {
            byte[] byArray = bytes;
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray;
            boolean bl3 = false;
            String string = Base64.encodeToString((byte[])it, (int)0, (int)it.length, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Base64.encodeToString(it\u2026 it.size, Base64.NO_WRAP)");
            return string;
        }
        return "";
    }

    public final void setVideoInfo(@Nullable ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        this.sps = this.getData(sps);
        this.pps = this.getData(pps);
        this.vps = this.getData(vps);
    }

    public final void setAuth(@Nullable String user, @Nullable String password) {
        this.user = user;
        this.password = password;
    }

    public final void setUrl(@Nullable String host, int port, @Nullable String path) {
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public final void clear() {
        this.sps = null;
        this.pps = null;
        this.vps = null;
        this.retryClear();
    }

    public final void retryClear() {
        this.cSeq = 0;
        this.sessionId = null;
    }

    private final String getSpsString() {
        return this.encodeToString(this.sps);
    }

    private final String getPpsString() {
        return this.encodeToString(this.pps);
    }

    private final String getVpsString() {
        return this.encodeToString(this.vps);
    }

    private final String addHeaders() {
        CommandsManager commandsManager = this;
        ++commandsManager.cSeq;
        return "CSeq: " + commandsManager.cSeq + "\r\n" + (this.sessionId == null ? "" : "Session: " + this.sessionId + "\r\n") + (authorization == null ? "" : "Authorization: " + authorization + "\r\n");
    }

    private final String createBody() {
        String videoBody = "";
        if (!this.isOnlyAudio) {
            videoBody = this.vps == null ? Body.INSTANCE.createH264Body(RtpConstants.INSTANCE.getTrackVideo(), this.getSpsString(), this.getPpsString()) : Body.INSTANCE.createH265Body(RtpConstants.INSTANCE.getTrackVideo(), this.getSpsString(), this.getPpsString(), this.getVpsString());
        }
        return "v=0\r\n" + "o=- " + this.timeStamp + ' ' + this.timeStamp + " IN IP4 127.0.0.1\r\n" + "s=Unnamed\r\n" + "i=N/A\r\n" + "c=IN IP4 " + this.host + "\r\n" + "t=0 0\r\n" + "a=recvonly\r\n" + videoBody + Body.INSTANCE.createAacBody(RtpConstants.INSTANCE.getTrackAudio(), this.sampleRate, this.isStereo);
    }

    private final String createAuth(String authResponse) {
        String string;
        Pattern authPattern = Pattern.compile("realm=\"(.+)\",\\s+nonce=\"(\\w+)\"", 2);
        Matcher matcher = authPattern.matcher(authResponse);
        if (matcher.find()) {
            Log.i((String)TAG, (String)"using digest auth");
            String realm = matcher.group(1);
            String nonce = matcher.group(2);
            String hash1 = AuthUtil.getMd5Hash(this.user + ':' + realm + ':' + this.password);
            String hash2 = AuthUtil.getMd5Hash("ANNOUNCE:rtsp://" + this.host + ':' + this.port + this.path);
            String hash3 = AuthUtil.getMd5Hash(hash1 + ':' + nonce + ':' + hash2);
            string = "Digest username=\"" + this.user + "\", realm=\"" + realm + "\", nonce=\"" + nonce + "\", uri=\"rtsp://" + this.host + ':' + this.port + this.path + "\", response=\"" + hash3 + '\"';
        } else {
            String data;
            Log.i((String)TAG, (String)"using basic auth");
            String string2 = data = this.user + ':' + this.password;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            String base64Data = Base64.encodeToString((byte[])byArray, (int)0);
            string = "Basic " + base64Data;
        }
        return string;
    }

    @NotNull
    public final String createOptions() {
        String options = "OPTIONS rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)options);
        return options;
    }

    @NotNull
    public String createSetup(int track) {
        int[] udpPorts = track == RtpConstants.INSTANCE.getTrackVideo() ? this.videoClientPorts : this.audioClientPorts;
        String params = this.protocol == Protocol.UDP ? "UDP;unicast;client_port=" + udpPorts[0] + '-' + udpPorts[1] + ";mode=record" : "TCP;unicast;interleaved=" + 2 * track + '-' + (2 * track + 1) + ";mode=record";
        String setup = "SETUP rtsp://" + this.host + ':' + this.port + this.path + "/trackID=" + track + " RTSP/1.0\r\n" + "Transport: RTP/AVP/" + params + "\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)setup);
        return setup;
    }

    @NotNull
    public final String createRecord() {
        String record = "RECORD rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\n" + "Range: npt=0.000-\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)record);
        return record;
    }

    @NotNull
    public final String createAnnounce() {
        String body = this.createBody();
        String announce = "ANNOUNCE rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders() + "Content-Length: " + body.length() + "\r\n" + "Content-Type: application/sdp\r\n\r\n" + body;
        Log.i((String)TAG, (String)announce);
        return announce;
    }

    @NotNull
    public final String createAnnounceWithAuth(@NotNull String authResponse) {
        Intrinsics.checkNotNullParameter((Object)authResponse, (String)"authResponse");
        authorization = this.createAuth(authResponse);
        Log.i((String)"Auth", (String)String.valueOf(authorization));
        return this.createAnnounce();
    }

    @NotNull
    public final String createTeardown() {
        String teardown = "TEARDOWN rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)teardown);
        return teardown;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getResponse(@Nullable BufferedReader reader, boolean isAudio, boolean checkStatus) {
        BufferedReader bufferedReader = reader;
        if (bufferedReader != null) {
            String string;
            BufferedReader bufferedReader2 = bufferedReader;
            boolean bl = false;
            boolean bl2 = false;
            BufferedReader br = bufferedReader2;
            boolean bl3 = false;
            try {
                String response = "";
                String line = null;
                do {
                    Matcher matcher;
                    Pattern rtspPattern;
                    String string2 = br.readLine();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object it = string2;
                    boolean bl62 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (string2 == null) break;
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Session", (boolean)false, (int)2, null)) {
                        String[] arrSplit;
                        Object $this$toTypedArray$iv;
                        rtspPattern = Pattern.compile("Session: (\\w+)");
                        Matcher matcher2 = rtspPattern.matcher(line);
                        if (matcher2.find()) {
                            this.sessionId = matcher2.group(1);
                        }
                        it = line;
                        String bl62 = ";";
                        int n = 0;
                        bl62 = new Regex(bl62);
                        n = 0;
                        boolean bl7 = false;
                        it = bl62.split((CharSequence)it, n);
                        boolean $i$f$toTypedArray22 = false;
                        void thisCollection$iv22 = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv22.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        $this$toTypedArray$iv = stringArray[0];
                        String $i$f$toTypedArray22 = ":";
                        int thisCollection$iv22 = 0;
                        $i$f$toTypedArray22 = new Regex($i$f$toTypedArray22);
                        thisCollection$iv22 = 0;
                        bl7 = false;
                        $this$toTypedArray$iv = $i$f$toTypedArray22.split((CharSequence)$this$toTypedArray$iv, thisCollection$iv22);
                        boolean $i$f$toTypedArray = false;
                        Object thisCollection$iv = $this$toTypedArray$iv;
                        if (thisCollection$iv.toArray(new String[0]) == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        if (arrSplit.length > 1) {
                            String string3;
                            void $this$trim$iv;
                            $this$toTypedArray$iv = arrSplit[1];
                            CommandsManager commandsManager = this;
                            boolean $i$f$trim = false;
                            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                            boolean $i$f$trim2 = false;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl8 = false;
                                boolean bl9 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            commandsManager.sessionId = string3 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                        }
                    }
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"server_port", (boolean)false, (int)2, null) && (matcher = (rtspPattern = Pattern.compile("server_port=([0-9]+)-([0-9]+)")).matcher(line)).find()) {
                        if (isAudio) {
                            String string4 = matcher.group(1);
                            if (string4 == null) {
                                string4 = String.valueOf(this.audioClientPorts[0]);
                            }
                            String string5 = string4;
                            boolean bl10 = false;
                            this.audioServerPorts[0] = Integer.parseInt(string5);
                            String string6 = matcher.group(2);
                            if (string6 == null) {
                                string6 = String.valueOf(this.audioClientPorts[1]);
                            }
                            string5 = string6;
                            bl10 = false;
                            this.audioServerPorts[1] = Integer.parseInt(string5);
                        } else {
                            String string7 = matcher.group(1);
                            if (string7 == null) {
                                string7 = String.valueOf(this.videoClientPorts[0]);
                            }
                            String string8 = string7;
                            boolean bl11 = false;
                            this.videoServerPorts[0] = Integer.parseInt(string8);
                            String string9 = matcher.group(2);
                            if (string9 == null) {
                                string9 = String.valueOf(this.videoClientPorts[1]);
                            }
                            string8 = string9;
                            bl11 = false;
                            this.videoServerPorts[1] = Integer.parseInt(string8);
                        }
                    }
                    response = response + line + '\n';
                } while (line.length() >= 3);
                if (checkStatus && this.getResponseStatus(response) != 200) {
                    this.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, " + response);
                    return "";
                }
                Log.i((String)TAG, (String)response);
                string = response;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"read error", (Throwable)e);
                string = "";
            }
            return string;
        }
        return "";
    }

    public final int getResponseStatus(@NotNull String response) {
        int n;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Matcher matcher = Pattern.compile("RTSP/\\d.\\d (\\d+) (\\w+)", 2).matcher(response);
        if (matcher.find()) {
            String string = matcher.group(1);
            if (string == null) {
                string = "-1";
            }
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = -1;
        }
        return n;
    }

    @NotNull
    public final String createPause() {
        return "";
    }

    @NotNull
    public final String createPlay() {
        return "";
    }

    @NotNull
    public final String createGetParameter() {
        return "";
    }

    @NotNull
    public final String createSetParameter() {
        return "";
    }

    @NotNull
    public final String createRedirect() {
        return "";
    }

    public CommandsManager(@NotNull ConnectCheckerRtsp connectCheckerRtsp) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtsp, (String)"connectCheckerRtsp");
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.sampleRate = 32000;
        this.isStereo = true;
        this.protocol = Protocol.TCP;
        this.audioClientPorts = new int[]{5000, 5001};
        this.videoClientPorts = new int[]{5002, 5003};
        this.audioServerPorts = new int[]{5004, 5005};
        this.videoServerPorts = new int[]{5006, 5007};
        long uptime = System.currentTimeMillis();
        this.timeStamp = uptime / (long)1000 << 32 & (uptime - uptime / (long)1000 * (long)1000 >> 32) / (long)1000;
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pedro/rtsp/rtsp/CommandsManager$Companion;", "", "()V", "TAG", "", "authorization", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

