/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtcp.SenderReportTcp;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;

public class RtpSocketTcp
extends BaseRtpSocket
implements Runnable {
    private SenderReportTcp senderReportTcp;
    private byte[] tcpHeader;
    private int[] lengths;
    private OutputStream outputStream = null;
    private ConnectCheckerRtsp connectCheckerRtsp;

    public RtpSocketTcp(ConnectCheckerRtsp connectCheckerRtsp) {
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.lengths = new int[this.bufferCount];
        this.senderReportTcp = new SenderReportTcp(connectCheckerRtsp);
        this.senderReportTcp.reset();
        this.tcpHeader = new byte[]{36, 0, 0, 0};
    }

    @Override
    public void setSSRC(int ssrc) {
        this.setLongSSRC(ssrc);
        this.senderReportTcp.setSSRC(ssrc);
    }

    public void setOutputStream(OutputStream outputStream, byte channelIdentifier) {
        if (outputStream != null) {
            this.outputStream = outputStream;
            this.tcpHeader[1] = channelIdentifier;
            this.senderReportTcp.setOutputStream(outputStream, (byte)(channelIdentifier + 1));
        }
    }

    @Override
    public void implementCommitBuffer(int length) {
        this.lengths[this.bufferIn] = length;
    }

    @Override
    public void run() {
        try {
            while (this.bufferCommitted.tryAcquire(4L, TimeUnit.SECONDS)) {
                this.senderReportTcp.update(this.lengths[this.bufferOut], this.timestamps[this.bufferOut]);
                this.sendTCP();
                if (++this.bufferOut >= this.bufferCount) {
                    this.bufferOut = 0;
                }
                this.bufferRequested.release();
            }
        }
        catch (IOException | InterruptedException e) {
            Log.e((String)"RtpSocket", (String)"TCP send error: ", (Throwable)e);
            this.connectCheckerRtsp.onConnectionFailedRtsp("Error send packet, " + e.getMessage());
        }
        this.thread = null;
        this.resetFifo();
        this.senderReportTcp.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTCP() throws IOException {
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            if (this.running) {
                int len = this.lengths[this.bufferOut];
                this.tcpHeader[2] = (byte)(len >> 8);
                this.tcpHeader[3] = (byte)(len & 0xFF);
                this.outputStream.write(this.tcpHeader);
                this.outputStream.write(this.buffers[this.bufferOut], 0, len);
                this.outputStream.flush();
                Log.i((String)"RtpSocket", (String)("send packet, " + len + " Size"));
            }
        }
    }
}

