/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.sockets.RtpSocketTcp;
import com.pedro.rtsp.rtp.sockets.RtpSocketUdp;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspClient;
import java.io.IOException;
import java.nio.ByteBuffer;

public class H264Packet
extends BasePacket {
    private final String TAG = "H264Packet";
    private byte[] header = new byte[5];
    private byte[] stapA;

    public H264Packet(RtspClient rtspClient, Protocol protocol) {
        super(rtspClient, protocol);
        this.socket.setClockFrequency(90000L);
    }

    public void updateDestinationVideo() {
        if (this.socket instanceof RtpSocketUdp) {
            ((RtpSocketUdp)this.socket).setDestination(this.rtspClient.getHost(), this.rtspClient.getVideoPorts()[0], this.rtspClient.getVideoPorts()[1]);
        } else {
            ((RtpSocketTcp)this.socket).setOutputStream(this.rtspClient.getOutputStream(), (byte)2);
        }
    }

    public void createAndSendPacket(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        try {
            byteBuffer.get(this.header, 0, 5);
            this.ts = bufferInfo.presentationTimeUs * 1000L;
            int naluLength = bufferInfo.size - byteBuffer.position() + 1;
            int type = this.header[4] & 0x1F;
            if (type == 5) {
                this.buffer = this.socket.requestBuffer();
                this.socket.markNextPacket();
                this.socket.updateTimestamp(this.ts);
                System.arraycopy(this.stapA, 0, this.buffer, 12, this.stapA.length);
                this.socket.commitBuffer(this.stapA.length + 12);
            }
            if (naluLength <= 1258) {
                this.buffer = this.socket.requestBuffer();
                this.buffer[12] = this.header[4];
                int cont = naluLength - 1;
                int length = cont < bufferInfo.size - byteBuffer.position() ? cont : bufferInfo.size - byteBuffer.position();
                byteBuffer.get(this.buffer, 13, length);
                this.socket.updateTimestamp(this.ts);
                this.socket.markNextPacket();
                this.socket.commitBuffer(naluLength + 12);
            } else {
                this.header[1] = (byte)(this.header[4] & 0x1F);
                this.header[1] = (byte)(this.header[1] + 128);
                this.header[0] = (byte)(this.header[4] & 0x60 & 0xFF);
                this.header[0] = (byte)(this.header[0] + 28);
                int sum = 1;
                while (sum < naluLength) {
                    this.buffer = this.socket.requestBuffer();
                    this.buffer[12] = this.header[0];
                    this.buffer[13] = this.header[1];
                    this.socket.updateTimestamp(this.ts);
                    int cont = naluLength - sum > 1258 ? 1258 : naluLength - sum;
                    int length = cont < bufferInfo.size - byteBuffer.position() ? cont : bufferInfo.size - byteBuffer.position();
                    byteBuffer.get(this.buffer, 14, length);
                    if (length < 0) {
                        return;
                    }
                    if ((sum += length) >= naluLength) {
                        this.buffer[13] = (byte)(this.buffer[13] + 64);
                        this.socket.markNextPacket();
                    }
                    this.socket.commitBuffer(length + 12 + 2);
                    this.header[1] = (byte)(this.header[1] & 0x7F);
                }
            }
        }
        catch (IOException | IndexOutOfBoundsException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setSPSandPPS(byte[] sps, byte[] pps) {
        this.stapA = new byte[sps.length + pps.length + 5];
        this.stapA[0] = 24;
        this.stapA[1] = (byte)(sps.length >> 8);
        this.stapA[2] = (byte)(sps.length & 0xFF);
        this.stapA[sps.length + 3] = (byte)(pps.length >> 8);
        this.stapA[sps.length + 4] = (byte)(pps.length & 0xFF);
        System.arraycopy(sps, 0, this.stapA, 3, sps.length);
        System.arraycopy(pps, 0, this.stapA, 5 + sps.length, pps.length);
    }
}

