/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.video.packet;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.av1.Av1Parser;
import com.pedro.common.av1.ObuType;
import com.pedro.rtmp.flv.BasePacket;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.video.FourCCPacketType;
import com.pedro.rtmp.flv.video.VideoDataType;
import com.pedro.rtmp.flv.video.VideoFormat;
import com.pedro.rtmp.flv.video.config.VideoSpecificConfigAV1;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000fJ,\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pedro/rtmp/flv/video/packet/Av1Packet;", "Lcom/pedro/rtmp/flv/BasePacket;", "<init>", "()V", "TAG", "", "parser", "Lcom/pedro/common/av1/Av1Parser;", "header", "", "configSend", "", "obuSequence", "sendVideoInfo", "", "Ljava/nio/ByteBuffer;", "createFlvPacket", "byteBuffer", "info", "Landroid/media/MediaCodec$BufferInfo;", "callback", "Lkotlin/Function1;", "Lcom/pedro/rtmp/flv/FlvPacket;", "reset", "resetInfo", "rtmp_release"})
public final class Av1Packet
extends BasePacket {
    @NotNull
    private final String TAG;
    @NotNull
    private final Av1Parser parser = new Av1Parser();
    @NotNull
    private final byte[] header = new byte[5];
    private boolean configSend;
    @Nullable
    private byte[] obuSequence;

    public Av1Packet() {
        this.TAG = "AV1Packet";
    }

    public final void sendVideoInfo(@NotNull ByteBuffer obuSequence) {
        Intrinsics.checkNotNullParameter((Object)obuSequence, (String)"obuSequence");
        this.obuSequence = ExtensionsKt.toByteArray((ByteBuffer)obuSequence);
    }

    @Override
    public void createFlvPacket(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo info, @NotNull Function1<? super FlvPacket, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"duplicate(...)");
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)byteBuffer2, (MediaCodec.BufferInfo)info);
        long ts = info.presentationTimeUs / (long)1000;
        int codec = VideoFormat.AV1.getValue();
        this.header[1] = (byte)(codec >> 24);
        this.header[2] = (byte)(codec >> 16);
        this.header[3] = (byte)(codec >> 8);
        this.header[4] = (byte)codec;
        byte[] buffer = null;
        if (!this.configSend) {
            this.header[0] = (byte)(0x80 | VideoDataType.KEYFRAME.getValue() << 4 | FourCCPacketType.SEQUENCE_START.getValue());
            byte[] obuSequence = this.obuSequence;
            if (obuSequence == null) {
                Log.e((String)this.TAG, (String)"waiting for a valid av1ConfigurationRecord");
                return;
            }
            VideoSpecificConfigAV1 config = new VideoSpecificConfigAV1(obuSequence);
            buffer = new byte[config.getSize() + this.header.length];
            config.write(buffer, this.header.length);
            System.arraycopy(this.header, 0, buffer, 0, this.header.length);
            callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.VIDEO));
            this.configSend = true;
        }
        if (this.parser.getObuType(fixedBuffer.get(0)) == ObuType.TEMPORAL_DELIMITER) {
            fixedBuffer.position(2);
            fixedBuffer = fixedBuffer.slice();
        }
        fixedBuffer.rewind();
        int size = fixedBuffer.remaining();
        buffer = new byte[this.header.length + size];
        int nalType = ExtensionsKt.isKeyframe((MediaCodec.BufferInfo)info) ? VideoDataType.KEYFRAME.getValue() : VideoDataType.INTER_FRAME.getValue();
        this.header[0] = (byte)(0x80 | nalType << 4 | FourCCPacketType.CODED_FRAMES.getValue());
        fixedBuffer.get(buffer, this.header.length, size);
        System.arraycopy(this.header, 0, buffer, 0, this.header.length);
        callback.invoke((Object)new FlvPacket(buffer, ts, buffer.length, FlvType.VIDEO));
    }

    @Override
    public void reset(boolean resetInfo) {
        if (resetInfo) {
            this.obuSequence = null;
        }
        this.configSend = false;
    }
}

