/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.utils.socket;

import com.pedro.rtmp.utils.TLSSocketFactory;
import com.pedro.rtmp.utils.socket.RtmpSocket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/pedro/rtmp/utils/socket/TcpSocket;", "Lcom/pedro/rtmp/utils/socket/RtmpSocket;", "host", "", "port", "", "secured", "", "(Ljava/lang/String;IZ)V", "input", "Ljava/io/BufferedInputStream;", "output", "Ljava/io/BufferedOutputStream;", "socket", "Ljava/net/Socket;", "close", "", "connect", "flush", "isPacket", "getInputStream", "Ljava/io/InputStream;", "getOutStream", "Ljava/io/OutputStream;", "isConnected", "isReachable", "rtmp_release"})
public final class TcpSocket
extends RtmpSocket {
    @NotNull
    private final String host;
    private final int port;
    private final boolean secured;
    @NotNull
    private Socket socket;
    @NotNull
    private BufferedInputStream input;
    @NotNull
    private BufferedOutputStream output;

    public TcpSocket(@NotNull String host, int port, boolean secured) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.secured = secured;
        this.socket = new Socket();
        Closeable closeable = new ByteArrayInputStream(new byte[0]);
        int n = 8192;
        this.input = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        closeable = new ByteArrayOutputStream();
        n = 8192;
        this.output = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
    }

    @Override
    @NotNull
    public OutputStream getOutStream() {
        return this.output;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return this.input;
    }

    @Override
    public void flush(boolean isPacket) {
        this.getOutStream().flush();
    }

    @Override
    public void connect() {
        if (this.secured) {
            try {
                TLSSocketFactory socketFactory = new TLSSocketFactory();
                this.socket = socketFactory.createSocket(this.host, this.port);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Create SSL socket failed: " + e.getMessage());
            }
        } else {
            this.socket = new Socket();
            SocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
            this.socket.connect(socketAddress, this.getTimeout());
        }
        OutputStream outputStream = this.socket.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        Closeable closeable = outputStream;
        int n = 8192;
        this.output = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        InputStream inputStream = this.socket.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        closeable = inputStream;
        n = 8192;
        this.input = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        this.socket.setSoTimeout(this.getTimeout());
    }

    @Override
    public void close() {
        try {
            if (this.socket.isConnected()) {
                this.socket.getInputStream().close();
                this.input.close();
                this.output.close();
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public boolean isReachable() {
        InetAddress inetAddress = this.socket.getInetAddress();
        return inetAddress != null ? inetAddress.isReachable(5000) : false;
    }
}

