/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.BitrateChecker;
import com.pedro.common.BitrateManager;
import com.pedro.common.ExtensionsKt;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public class AndroidMuxerRecordController
extends BaseRecordController {
    private MediaMuxer mediaMuxer;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;
    private final int outputFormat = 0;

    @Override
    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener, RecordController.RecordTracks tracks) throws IOException {
        this.tracks = tracks;
        if (this.audioCodec != AudioCodec.AAC) {
            throw new IOException("Unsupported AudioCodec: " + this.audioCodec.name());
        }
        this.mediaMuxer = new MediaMuxer(path, 0);
        this.listener = listener;
        this.status = RecordController.Status.STARTED;
        if (listener != null) {
            this.bitrateManager = new BitrateManager((BitrateChecker)listener);
            listener.onStatusChange(this.status);
        } else {
            this.bitrateManager = null;
        }
        if (tracks == RecordController.RecordTracks.AUDIO && this.audioFormat != null) {
            this.init();
        }
    }

    @Override
    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener, RecordController.RecordTracks tracks) throws IOException {
        this.tracks = tracks;
        if (this.audioCodec != AudioCodec.AAC) {
            throw new IOException("Unsupported AudioCodec: " + this.audioCodec.name());
        }
        this.mediaMuxer = new MediaMuxer(fd, 0);
        this.listener = listener;
        this.status = RecordController.Status.STARTED;
        if (listener != null) {
            this.bitrateManager = new BitrateManager((BitrateChecker)listener);
            listener.onStatusChange(this.status);
        } else {
            this.bitrateManager = null;
        }
        if (tracks == RecordController.RecordTracks.AUDIO && this.audioFormat != null) {
            this.init();
        }
    }

    @Override
    public void stopRecord() {
        this.videoTrack = -1;
        this.audioTrack = -1;
        this.status = RecordController.Status.STOPPED;
        if (this.mediaMuxer != null) {
            try {
                this.mediaMuxer.stop();
                this.mediaMuxer.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mediaMuxer = null;
        this.pauseMoment = 0L;
        this.pauseTime = 0L;
        this.startTs = 0L;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    @Override
    public void recordVideo(ByteBuffer videoBuffer, MediaCodec.BufferInfo videoInfo) {
        if (this.status == RecordController.Status.STARTED && this.videoFormat != null && (this.audioFormat != null || this.tracks == RecordController.RecordTracks.VIDEO)) {
            if (videoInfo.flags == 1 || this.isKeyFrame(videoBuffer)) {
                this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
                this.init();
            }
        } else if (this.status == RecordController.Status.RESUMED && (videoInfo.flags == 1 || this.isKeyFrame(videoBuffer))) {
            this.status = RecordController.Status.RECORDING;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
        if (this.status == RecordController.Status.RECORDING && this.tracks != RecordController.RecordTracks.AUDIO) {
            this.updateFormat(this.videoInfo, videoInfo);
            this.write(this.videoTrack, videoBuffer, this.videoInfo);
        }
    }

    @Override
    public void recordAudio(ByteBuffer audioBuffer, MediaCodec.BufferInfo audioInfo) {
        if (this.status == RecordController.Status.RECORDING && this.tracks != RecordController.RecordTracks.VIDEO) {
            this.updateFormat(this.audioInfo, audioInfo);
            this.write(this.audioTrack, audioBuffer, this.audioInfo);
        }
    }

    @Override
    public void setVideoFormat(MediaFormat videoFormat) {
        this.videoFormat = videoFormat;
    }

    @Override
    public void setAudioFormat(MediaFormat audioFormat) {
        this.audioFormat = audioFormat;
        if (this.tracks == RecordController.RecordTracks.AUDIO && this.status == RecordController.Status.STARTED) {
            this.init();
        }
    }

    @Override
    public void resetFormats() {
        this.videoFormat = null;
        this.audioFormat = null;
    }

    private void init() {
        if (this.tracks != RecordController.RecordTracks.VIDEO) {
            this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
        }
        this.mediaMuxer.start();
        this.status = RecordController.Status.RECORDING;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    private void write(int track, ByteBuffer byteBuffer, MediaCodec.BufferInfo info) {
        block4: {
            if (track == -1) {
                return;
            }
            try {
                this.mediaMuxer.writeSampleData(track, byteBuffer, info);
                if (this.bitrateManager != null) {
                    this.bitrateManager.calculateBitrate((long)info.size * 8L, ExtensionsKt.getSuspendContext());
                }
            }
            catch (Exception e) {
                if (this.listener == null) break block4;
                this.listener.onError(e);
            }
        }
    }
}

