/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.pedro.common.AudioCodec;
import com.pedro.common.BitrateChecker;
import com.pedro.common.BitrateManager;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.VideoCodec;
import com.pedro.common.frame.MediaFrame;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.FlvMuxerRecordController;
import com.pedro.rtmp.amf.v0.AmfEcmaArray;
import com.pedro.rtmp.amf.v0.AmfString;
import com.pedro.rtmp.flv.BasePacket;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.FlvType;
import com.pedro.rtmp.flv.audio.AudioFormat;
import com.pedro.rtmp.flv.audio.packet.AacPacket;
import com.pedro.rtmp.flv.audio.packet.G711Packet;
import com.pedro.rtmp.flv.video.VideoFormat;
import com.pedro.rtmp.flv.video.packet.H264Packet;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001e\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020$H\u0016J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0015H\u0016J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0015H\u0016J\b\u0010/\u001a\u00020\u0017H\u0016J\b\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u00103\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00104\u001a\u000205H\u0002J \u00106\u001a\u0002012\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/pedro/library/util/FlvMuxerRecordController;", "Lcom/pedro/library/base/recording/BaseRecordController;", "<init>", "()V", "outputStream", "Ljava/io/OutputStream;", "videoPacket", "Lcom/pedro/rtmp/flv/video/packet/H264Packet;", "audioPacket", "Lcom/pedro/rtmp/flv/BasePacket;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/pedro/common/frame/MediaFrame;", "job", "Lkotlinx/coroutines/Job;", "width", "", "height", "fps", "sampleRate", "isStereo", "", "startRecord", "", "path", "", "listener", "Lcom/pedro/library/base/recording/RecordController$Listener;", "fd", "Ljava/io/FileDescriptor;", "start", "stopRecord", "recordVideo", "videoBuffer", "Ljava/nio/ByteBuffer;", "videoInfo", "Landroid/media/MediaCodec$BufferInfo;", "recordAudio", "audioBuffer", "audioInfo", "setVideoFormat", "videoFormat", "Landroid/media/MediaFormat;", "isOnlyVideo", "setAudioFormat", "audioFormat", "isOnlyAudio", "resetFormats", "createFlvFileHeader", "", "writeFlvFileMetadata", "writeFlvPacket", "flvPacket", "Lcom/pedro/rtmp/flv/FlvPacket;", "createHeaderTag", "type", "", "length", "timeStamp", "", "library_release"})
@SourceDebugExtension(value={"SMAP\nFlvMuxerRecordController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlvMuxerRecordController.kt\ncom/pedro/library/util/FlvMuxerRecordController\n+ 2 Extensions.kt\ncom/pedro/common/ExtensionsKt\n*L\n1#1,241:1\n76#2,5:242\n76#2,5:247\n*S KotlinDebug\n*F\n+ 1 FlvMuxerRecordController.kt\ncom/pedro/library/util/FlvMuxerRecordController\n*L\n132#1:242,5\n139#1:247,5\n*E\n"})
public final class FlvMuxerRecordController
extends BaseRecordController {
    @Nullable
    private OutputStream outputStream;
    @NotNull
    private H264Packet videoPacket = new H264Packet();
    @NotNull
    private BasePacket audioPacket = (BasePacket)new AacPacket();
    @NotNull
    private final LinkedBlockingQueue<MediaFrame> queue = new LinkedBlockingQueue(200);
    @Nullable
    private Job job;
    private int width;
    private int height;
    private int fps;
    private int sampleRate;
    private boolean isStereo = true;

    @Override
    public void startRecord(@NotNull String path, @Nullable RecordController.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.outputStream = new FileOutputStream(path);
        this.start(listener);
    }

    @Override
    public void startRecord(@NotNull FileDescriptor fd, @Nullable RecordController.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)fd, (String)"fd");
        this.outputStream = new FileOutputStream(fd);
        this.start(listener);
    }

    /*
     * WARNING - void declaration
     */
    private final void start(RecordController.Listener listener) {
        if (this.audioCodec == AudioCodec.OPUS) {
            throw new IOException("Unsupported AudioCodec: " + this.audioCodec.name());
        }
        if (this.videoCodec != VideoCodec.H264) {
            throw new IOException("Unsupported VideoCodec: " + this.videoCodec.name());
        }
        AudioCodec audioCodec = this.audioCodec;
        switch (audioCodec == null ? -1 : WhenMappings.$EnumSwitchMapping$0[audioCodec.ordinal()]) {
            case 1: {
                this.audioPacket = (BasePacket)new G711Packet();
                break;
            }
            case 2: {
                void $this$start_u24lambda_u240;
                AacPacket aacPacket;
                AacPacket aacPacket2 = aacPacket = new AacPacket();
                FlvMuxerRecordController flvMuxerRecordController = this;
                boolean bl = false;
                AacPacket.sendAudioInfo$default((AacPacket)$this$start_u24lambda_u240, (int)this.sampleRate, (boolean)this.isStereo, null, (int)4, null);
                flvMuxerRecordController.audioPacket = (BasePacket)aacPacket;
            }
        }
        this.listener = listener;
        this.status = RecordController.Status.STARTED;
        if (listener != null) {
            this.bitrateManager = new BitrateManager((BitrateChecker)listener);
            listener.onStatusChange(this.status);
        } else {
            this.bitrateManager = null;
        }
        this.queue.clear();
        OutputStream outputStream = this.outputStream;
        if (outputStream != null) {
            OutputStream it = outputStream;
            boolean bl = false;
            try {
                it.write(this.createFlvFileHeader());
                this.writeFlvFileMetadata(it);
            }
            catch (Exception exception) {
            }
        }
        this.status = RecordController.Status.RECORDING;
        RecordController.Listener listener2 = listener;
        if (listener2 != null) {
            listener2.onStatusChange(this.status);
        }
        this.job = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FlvMuxerRecordController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
             * Unable to fully structure code
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        ** GOTO lbl21
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl27
                    }
                    case 2: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl21
                    }
                    case 3: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl21:
                        // 5 sources

                        block10: while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = InterruptibleKt.runInterruptible$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.pedro.library.util.FlvMuxerRecordController ), ()Lcom/pedro/common/frame/MediaFrame;)((FlvMuxerRecordController)this.this$0), (Continuation)((Continuation)this), (int)1, null);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
lbl27:
                            // 3 sources

                            mediaFrame = (MediaFrame)v0;
                            switch (start.WhenMappings.$EnumSwitchMapping$0[mediaFrame.getType().ordinal()]) {
                                case 1: {
                                    v3 = FlvMuxerRecordController.access$getVideoPacket$p(this.this$0);
                                    Intrinsics.checkNotNull((Object)mediaFrame);
                                    this.L$0 = $this$launch;
                                    this.label = 2;
                                    v1 = v3.createFlvPacket(mediaFrame, (Function2)new Function2<FlvPacket, Continuation<? super Unit>, Object>(this.this$0, null){
                                        int label;
                                        /* synthetic */ Object L$0;
                                        final /* synthetic */ FlvMuxerRecordController this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    FlvPacket packet = (FlvPacket)this.L$0;
                                                    OutputStream outputStream = FlvMuxerRecordController.access$getOutputStream$p(this.this$0);
                                                    if (outputStream != null) {
                                                        OutputStream outputStream2 = outputStream;
                                                        FlvMuxerRecordController flvMuxerRecordController = this.this$0;
                                                        OutputStream it = outputStream2;
                                                        boolean bl = false;
                                                        FlvMuxerRecordController.access$writeFlvPacket(flvMuxerRecordController, it, packet);
                                                    }
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                            var3_3.L$0 = value;
                                            return (Continuation)var3_3;
                                        }

                                        public final Object invoke(FlvPacket p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, (Continuation)this);
                                    if (v1 != var4_2) continue block10;
                                    return var4_2;
                                }
                                case 2: {
                                    v4 = FlvMuxerRecordController.access$getAudioPacket$p(this.this$0);
                                    Intrinsics.checkNotNull((Object)mediaFrame);
                                    this.L$0 = $this$launch;
                                    this.label = 3;
                                    v2 = v4.createFlvPacket(mediaFrame, (Function2)new Function2<FlvPacket, Continuation<? super Unit>, Object>(this.this$0, null){
                                        int label;
                                        /* synthetic */ Object L$0;
                                        final /* synthetic */ FlvMuxerRecordController this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    FlvPacket packet = (FlvPacket)this.L$0;
                                                    OutputStream outputStream = FlvMuxerRecordController.access$getOutputStream$p(this.this$0);
                                                    if (outputStream != null) {
                                                        OutputStream outputStream2 = outputStream;
                                                        FlvMuxerRecordController flvMuxerRecordController = this.this$0;
                                                        OutputStream it = outputStream2;
                                                        boolean bl = false;
                                                        FlvMuxerRecordController.access$writeFlvPacket(flvMuxerRecordController, it, packet);
                                                    }
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                            var3_3.L$0 = value;
                                            return (Continuation)var3_3;
                                        }

                                        public final Object invoke(FlvPacket p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, (Continuation)this);
                                    if (v2 != var4_2) continue block10;
                                    return var4_2;
                                }
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final MediaFrame invokeSuspend$lambda$0(FlvMuxerRecordController this$0) {
                return (MediaFrame)FlvMuxerRecordController.access$getQueue$p(this$0).take();
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRecord() {
        this.status = RecordController.Status.STOPPED;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FlvMuxerRecordController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block5: {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = FlvMuxerRecordController.access$getJob$p(this.this$0);
                            if (v0 == null) break;
                            this.label = 1;
                            v1 = JobKt.cancelAndJoin((Job)v0, (Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl15:
                            // 2 sources

                            v2 = Unit.INSTANCE;
                            break block5;
                        }
                    }
                    v2 = null;
                }
                return v2;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.pauseMoment = 0L;
        this.pauseTime = 0L;
        this.startTs = 0L;
        this.queue.clear();
        this.videoPacket.reset(false);
        this.audioPacket.reset(false);
        try {
            OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.outputStream = null;
        }
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    @Override
    public void recordVideo(@NotNull ByteBuffer videoBuffer, @NotNull MediaCodec.BufferInfo videoInfo) {
        Intrinsics.checkNotNullParameter((Object)videoBuffer, (String)"videoBuffer");
        Intrinsics.checkNotNullParameter((Object)videoInfo, (String)"videoInfo");
        if (this.status == RecordController.Status.RECORDING) {
            MediaFrame frame = new MediaFrame(ExtensionsKt.clone((ByteBuffer)videoBuffer), ExtensionsKt.toMediaFrameInfo((MediaCodec.BufferInfo)videoInfo), MediaFrame.Type.VIDEO);
            BlockingQueue $this$trySend$iv = this.queue;
            boolean $i$f$trySend = false;
            try {
                $this$trySend$iv.add(frame);
                boolean bl = true;
            }
            catch (IllegalStateException e$iv) {
                boolean bl = false;
            }
        }
    }

    @Override
    public void recordAudio(@NotNull ByteBuffer audioBuffer, @NotNull MediaCodec.BufferInfo audioInfo) {
        Intrinsics.checkNotNullParameter((Object)audioBuffer, (String)"audioBuffer");
        Intrinsics.checkNotNullParameter((Object)audioInfo, (String)"audioInfo");
        if (this.status == RecordController.Status.RECORDING) {
            MediaFrame frame = new MediaFrame(ExtensionsKt.clone((ByteBuffer)audioBuffer), ExtensionsKt.toMediaFrameInfo((MediaCodec.BufferInfo)audioInfo), MediaFrame.Type.AUDIO);
            BlockingQueue $this$trySend$iv = this.queue;
            boolean $i$f$trySend = false;
            try {
                $this$trySend$iv.add(frame);
                boolean bl = true;
            }
            catch (IllegalStateException e$iv) {
                boolean bl = false;
            }
        }
    }

    @Override
    public void setVideoFormat(@NotNull MediaFormat videoFormat, boolean isOnlyVideo) {
        Intrinsics.checkNotNullParameter((Object)videoFormat, (String)"videoFormat");
        this.isOnlyVideo = isOnlyVideo;
        int width = videoFormat.getInteger("width");
        int height = videoFormat.getInteger("height");
        int fps = videoFormat.getInteger("frame-rate");
        this.width = width;
        this.height = height;
        this.fps = fps;
        ByteBuffer sps = videoFormat.getByteBuffer("csd-0");
        ByteBuffer pps = videoFormat.getByteBuffer("csd-1");
        if (sps != null && pps != null) {
            this.videoPacket.sendVideoInfo(sps, pps);
        }
    }

    @Override
    public void setAudioFormat(@NotNull MediaFormat audioFormat, boolean isOnlyAudio) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)audioFormat, (String)"audioFormat");
            this.isOnlyAudio = isOnlyAudio;
            int sampleRate = audioFormat.getInteger("sample-rate");
            int channels = audioFormat.getInteger("channel-count");
            this.sampleRate = sampleRate;
            this.isStereo = channels > 1;
            BasePacket basePacket = this.audioPacket;
            AacPacket aacPacket = basePacket instanceof AacPacket ? (AacPacket)basePacket : null;
            if (aacPacket == null) break block0;
            AacPacket.sendAudioInfo$default((AacPacket)aacPacket, (int)sampleRate, (boolean)this.isStereo, null, (int)4, null);
        }
    }

    @Override
    public void resetFormats() {
    }

    private final byte[] createFlvFileHeader() {
        byte flag = this.isOnlyAudio ? (byte)4 : (this.isOnlyVideo ? (byte)1 : 5);
        byte[] byArray = new byte[]{70, 76, 86, 1, flag, 0, 0, 0, 9, 0, 0, 0, 0};
        return byArray;
    }

    private final void writeFlvFileMetadata(OutputStream outputStream) {
        AmfString head = new AmfString("onMetaData");
        AmfEcmaArray info = new AmfEcmaArray(null, 1, null);
        info.setProperty("width", (double)this.width);
        info.setProperty("height", (double)this.height);
        VideoCodec videoCodec = this.videoCodec;
        int videoCodecValue = switch (videoCodec == null ? -1 : WhenMappings.$EnumSwitchMapping$1[videoCodec.ordinal()]) {
            case 1 -> VideoFormat.AVC.getValue();
            case 2 -> VideoFormat.HEVC.getValue();
            case 3 -> VideoFormat.AV1.getValue();
            default -> throw new IllegalArgumentException("unsupported null codec");
        };
        info.setProperty("videocodecid", (double)videoCodecValue);
        info.setProperty("framerate", (double)this.fps);
        AudioCodec audioCodec = this.audioCodec;
        int audioCodecValue = switch (audioCodec == null ? -1 : WhenMappings.$EnumSwitchMapping$0[audioCodec.ordinal()]) {
            case 2 -> AudioFormat.AAC.getValue();
            case 1 -> AudioFormat.G711_A.getValue();
            default -> throw new IllegalArgumentException("unsupported null codec");
        };
        info.setProperty("audiocodecid", (double)audioCodecValue);
        info.setProperty("audiosamplerate", (double)this.sampleRate);
        info.setProperty("audiosamplesize", 16.0);
        info.setProperty("stereo", this.isStereo);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        head.writeHeader((OutputStream)output);
        head.writeBody((OutputStream)output);
        info.writeHeader((OutputStream)output);
        info.writeBody((OutputStream)output);
        byte[] data = output.toByteArray();
        byte[] flvHeaderTag = this.createHeaderTag((byte)18, data.length, 0L);
        byte[] flvTagSize = ExtensionsKt.toUInt32((int)(flvHeaderTag.length + data.length));
        try {
            outputStream.write(flvHeaderTag);
            outputStream.write(data);
            outputStream.write(flvTagSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void writeFlvPacket(OutputStream outputStream, FlvPacket flvPacket) {
        byte type = switch (WhenMappings.$EnumSwitchMapping$2[flvPacket.getType().ordinal()]) {
            case 1 -> 8;
            case 2 -> 9;
            default -> throw new NoWhenBranchMatchedException();
        };
        byte[] flvHeaderTag = this.createHeaderTag(type, flvPacket.getLength(), flvPacket.getTimeStamp());
        byte[] flvTagSize = ExtensionsKt.toUInt32((int)(flvHeaderTag.length + flvPacket.getLength()));
        try {
            outputStream.write(flvHeaderTag);
            outputStream.write(flvPacket.getBuffer());
            outputStream.write(flvTagSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final byte[] createHeaderTag(byte type, int length, long timeStamp) {
        byte[] byArray = new byte[]{type};
        byte[] byArray2 = ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])byArray, (byte[])ExtensionsKt.toUInt24((int)length)), (byte[])ExtensionsKt.toUInt24((int)((int)timeStamp))), (byte)((byte)(timeStamp >> 24)));
        byArray = new byte[]{0, 0, 0};
        return ArraysKt.plus((byte[])byArray2, (byte[])byArray);
    }

    public static final /* synthetic */ H264Packet access$getVideoPacket$p(FlvMuxerRecordController $this) {
        return $this.videoPacket;
    }

    public static final /* synthetic */ OutputStream access$getOutputStream$p(FlvMuxerRecordController $this) {
        return $this.outputStream;
    }

    public static final /* synthetic */ void access$writeFlvPacket(FlvMuxerRecordController $this, OutputStream outputStream, FlvPacket flvPacket) {
        $this.writeFlvPacket(outputStream, flvPacket);
    }

    public static final /* synthetic */ BasePacket access$getAudioPacket$p(FlvMuxerRecordController $this) {
        return $this.audioPacket;
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getQueue$p(FlvMuxerRecordController $this) {
        return $this.queue;
    }

    public static final /* synthetic */ Job access$getJob$p(FlvMuxerRecordController $this) {
        return $this.job;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.G711.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.AAC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H264.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.H265.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.AV1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[FlvType.values().length];
            try {
                nArray[FlvType.AUDIO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FlvType.VIDEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

