/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util;

public class BitrateAdapter {
    private int maxBitrate;
    private int oldBitrate;
    private int averageBitrate;
    private int cont;
    private final Listener listener;
    private float decreaseRange = 0.8f;
    private float increaseRange = 1.2f;

    public BitrateAdapter(Listener listener) {
        this.listener = listener;
        this.reset();
    }

    public void setMaxBitrate(int bitrate) {
        this.maxBitrate = bitrate;
        this.oldBitrate = bitrate;
        this.reset();
    }

    public void adaptBitrate(long actualBitrate) {
        this.averageBitrate = (int)((long)this.averageBitrate + actualBitrate);
        this.averageBitrate /= 2;
        ++this.cont;
        if (this.cont >= 5 && this.listener != null && this.maxBitrate != 0) {
            this.listener.onBitrateAdapted(this.getBitrateAdapted(this.averageBitrate));
            this.reset();
        }
    }

    public void adaptBitrate(long actualBitrate, boolean hasCongestion) {
        this.averageBitrate = (int)((long)this.averageBitrate + actualBitrate);
        this.averageBitrate /= 2;
        ++this.cont;
        if (this.cont >= 5 && this.listener != null && this.maxBitrate != 0) {
            this.listener.onBitrateAdapted(this.getBitrateAdapted(this.averageBitrate, hasCongestion));
            this.reset();
        }
    }

    private int getBitrateAdapted(int bitrate) {
        if (bitrate >= this.maxBitrate) {
            this.oldBitrate = this.maxBitrate;
        } else if ((float)bitrate <= (float)this.oldBitrate * 0.9f) {
            this.oldBitrate = (int)((float)bitrate * this.decreaseRange);
        } else {
            this.oldBitrate = (int)((float)bitrate * this.increaseRange);
            if (this.oldBitrate > this.maxBitrate) {
                this.oldBitrate = this.maxBitrate;
            }
        }
        return this.oldBitrate;
    }

    private int getBitrateAdapted(int bitrate, boolean hasCongestion) {
        if (bitrate >= this.maxBitrate) {
            this.oldBitrate = this.maxBitrate;
        } else if (hasCongestion) {
            this.oldBitrate = (int)((float)bitrate * this.decreaseRange);
        } else {
            this.oldBitrate = (int)((float)bitrate * this.increaseRange);
            if (this.oldBitrate > this.maxBitrate) {
                this.oldBitrate = this.maxBitrate;
            }
        }
        return this.oldBitrate;
    }

    public void reset() {
        this.averageBitrate = 0;
        this.cont = 0;
    }

    public float getDecreaseRange() {
        return this.decreaseRange;
    }

    public void setDecreaseRange(float decreaseRange) {
        if (decreaseRange > 0.0f && decreaseRange < 100.0f) {
            this.decreaseRange = 1.0f - decreaseRange / 100.0f;
        }
    }

    public float getIncreaseRange() {
        return this.increaseRange;
    }

    public void setIncreaseRange(float increaseRange) {
        if (increaseRange > 0.0f && increaseRange < 100.0f) {
            this.increaseRange = 1.0f + increaseRange / 100.0f;
        }
    }

    public static interface Listener {
        public void onBitrateAdapted(int var1);
    }
}

