/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtmp;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.Camera2Base;
import com.pedro.library.rtmp.RtmpCamera2;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtmp.rtmp.RtmpClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000m\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\f\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\u0013H\u0014J\u0018\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J$\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020%2\b\u0010*\u001a\u0004\u0018\u00010%2\b\u0010+\u001a\u0004\u0018\u00010%H\u0014J\u0018\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/pedro/library/rtmp/RtmpCamera2;", "Lcom/pedro/library/base/Camera2Base;", "openGlView", "Lcom/pedro/library/view/OpenGlView;", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "<init>", "(Lcom/pedro/library/view/OpenGlView;Lcom/pedro/common/ConnectChecker;)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;)V", "streamClientListener", "com/pedro/library/rtmp/RtmpCamera2$streamClientListener$1", "Lcom/pedro/library/rtmp/RtmpCamera2$streamClientListener$1;", "rtmpClient", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "streamClient", "Lcom/pedro/library/util/streamclient/RtmpStreamClient;", "init", "", "getStreamClient", "setVideoCodecImp", "codec", "Lcom/pedro/common/VideoCodec;", "setAudioCodecImp", "Lcom/pedro/common/AudioCodec;", "onAudioInfoImp", "isStereo", "", "sampleRate", "", "startStreamImp", "url", "", "stopStreamImp", "getAudioDataImp", "audioBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "onVideoInfoImp", "sps", "pps", "vps", "getVideoDataImp", "videoBuffer", "library_release"})
@RequiresApi(api=21)
public final class RtmpCamera2
extends Camera2Base {
    @NotNull
    private final streamClientListener.1 streamClientListener;
    private RtmpClient rtmpClient;
    private RtmpStreamClient streamClient;

    public RtmpCamera2(@NotNull OpenGlView openGlView, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)openGlView, (String)"openGlView");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(openGlView);
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ RtmpCamera2 this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyFrame();
            }
        };
        this.init(connectChecker);
    }

    public RtmpCamera2(@NotNull Context context, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(context);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.init(connectChecker);
    }

    private final void init(ConnectChecker connectChecker) {
        this.rtmpClient = new RtmpClient(connectChecker);
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        this.streamClient = new RtmpStreamClient(rtmpClient, this.streamClientListener);
    }

    @Override
    @NotNull
    public RtmpStreamClient getStreamClient() {
        RtmpStreamClient rtmpStreamClient = this.streamClient;
        if (rtmpStreamClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streamClient");
            rtmpStreamClient = null;
        }
        return rtmpStreamClient;
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setAudioCodec(codec);
    }

    @Override
    protected void onAudioInfoImp(boolean isStereo, int sampleRate) {
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamImp(@NotNull String url) {
        RtmpClient rtmpClient;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            RtmpClient rtmpClient2 = this.rtmpClient;
            if (rtmpClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                rtmpClient2 = null;
            }
            rtmpClient2.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            RtmpClient rtmpClient3 = this.rtmpClient;
            if (rtmpClient3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                rtmpClient3 = null;
            }
            rtmpClient3.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        if ((rtmpClient = this.rtmpClient) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setFps(this.videoEncoder.getFps());
        RtmpClient rtmpClient4 = this.rtmpClient;
        if (rtmpClient4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient4 = null;
        }
        rtmpClient4.connect(url);
    }

    @Override
    protected void stopStreamImp() {
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.disconnect();
    }

    @Override
    protected void getAudioDataImp(@NotNull ByteBuffer audioBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)audioBuffer, (String)"audioBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.sendAudio(audioBuffer, info);
    }

    @Override
    protected void onVideoInfoImp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getVideoDataImp(@NotNull ByteBuffer videoBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)videoBuffer, (String)"videoBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.sendVideo(videoBuffer, info);
    }
}

