/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util.sources.audio;

import android.content.Context;
import android.media.AudioTrack;
import android.net.Uri;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.decoder.AudioDecoder;
import com.pedro.encoder.input.decoder.DecoderInterface;
import com.pedro.library.util.sources.audio.AudioFileSource;
import com.pedro.library.util.sources.audio.AudioSource;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\n*\u0002\u0011\u0016\u0018\u00002\u00020\u0001BF\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012#\b\u0002\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ(\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0014J\u0010\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\rH\u0016J\b\u0010(\u001a\u00020\u0007H\u0016J\b\u0010)\u001a\u00020\rH\u0016J\b\u0010*\u001a\u00020 H\u0016J\u0010\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020 H\u0016J\u0006\u0010-\u001a\u00020\rJ\u0006\u0010.\u001a\u00020\rJ\u0006\u0010/\u001a\u00020\u0007J\u000e\u00100\u001a\u00020\r2\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000202J\u0006\u00104\u001a\u000202J\u000e\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\u0007J\u0016\u00107\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0005J\u0006\u00109\u001a\u00020\rJ\u0006\u0010:\u001a\u00020\rJ\u0006\u0010;\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/pedro/library/util/sources/audio/AudioFileSource;", "Lcom/pedro/library/util/sources/audio/AudioSource;", "context", "Landroid/content/Context;", "path", "Landroid/net/Uri;", "loopMode", "", "onFinish", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "isLoop", "", "<init>", "(Landroid/content/Context;Landroid/net/Uri;ZLkotlin/jvm/functions/Function1;)V", "getMicrophoneDataCallback", "com/pedro/library/util/sources/audio/AudioFileSource$getMicrophoneDataCallback$1", "Lcom/pedro/library/util/sources/audio/AudioFileSource$getMicrophoneDataCallback$1;", "audioDecoderInterface", "Lkotlin/Function0;", "decoderInterface", "com/pedro/library/util/sources/audio/AudioFileSource$decoderInterface$1", "Lcom/pedro/library/util/sources/audio/AudioFileSource$decoderInterface$1;", "running", "audioDecoder", "Lcom/pedro/encoder/input/decoder/AudioDecoder;", "audioTrackPlayer", "Landroid/media/AudioTrack;", "playingAudio", "create", "sampleRate", "", "isStereo", "echoCanceler", "noiseSuppressor", "start", "getMicrophoneData", "Lcom/pedro/encoder/input/audio/GetMicrophoneData;", "stop", "isRunning", "release", "getMaxInputSize", "setMaxInputSize", "size", "mute", "unMute", "isMuted", "moveTo", "time", "", "getDuration", "getTime", "setLoopMode", "enabled", "replaceFile", "uri", "playAudioDevice", "stopAudioDevice", "isAudioDeviceEnabled", "library_release"})
public final class AudioFileSource
extends AudioSource {
    @NotNull
    private final Context context;
    @NotNull
    private final Uri path;
    @NotNull
    private final getMicrophoneDataCallback.1 getMicrophoneDataCallback;
    @NotNull
    private final Function0<Unit> audioDecoderInterface;
    @NotNull
    private final decoderInterface.1 decoderInterface;
    private boolean running;
    @NotNull
    private AudioDecoder audioDecoder;
    @Nullable
    private AudioTrack audioTrackPlayer;
    private boolean playingAudio;

    public AudioFileSource(@NotNull Context context, @NotNull Uri path, boolean loopMode, @NotNull Function1<? super Boolean, Unit> onFinish) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
        this.context = context;
        this.path = path;
        this.getMicrophoneDataCallback = new GetMicrophoneData(this){
            final /* synthetic */ AudioFileSource this$0;
            {
                this.this$0 = $receiver;
            }

            public void inputPCMData(Frame frame) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                    AudioTrack audioTrack = AudioFileSource.access$getAudioTrackPlayer$p(this.this$0);
                    if (audioTrack != null) {
                        audioTrack.write(frame.getBuffer(), frame.getOffset(), frame.getSize());
                    }
                    GetMicrophoneData getMicrophoneData2 = this.this$0.getGetMicrophoneData();
                    if (getMicrophoneData2 == null) break block1;
                    getMicrophoneData2.inputPCMData(frame);
                }
            }
        };
        this.audioDecoderInterface = () -> AudioFileSource.audioDecoderInterface$lambda$1(onFinish);
        this.decoderInterface = new DecoderInterface(onFinish){
            final /* synthetic */ Function1<Boolean, Unit> $onFinish;
            {
                this.$onFinish = $onFinish;
            }

            public void onLoop() {
                this.$onFinish.invoke((Object)true);
            }
        };
        this.audioDecoder = new AudioDecoder((GetMicrophoneData)this.getMicrophoneDataCallback, () -> AudioFileSource.audioDecoder$lambda$2(this.audioDecoderInterface), (DecoderInterface)this.decoderInterface);
        this.setLoopMode(loopMode);
    }

    public /* synthetic */ AudioFileSource(Context context, Uri uri, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            function1 = AudioFileSource::_init_$lambda$0;
        }
        this(context, uri, bl, (Function1<? super Boolean, Unit>)function1);
    }

    @Override
    protected boolean create(int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        boolean result = this.audioDecoder.initExtractor(this.context, this.path, null);
        if (!result) {
            throw new IllegalArgumentException("Audio file track not found");
        }
        if (this.audioDecoder.getSampleRate() != sampleRate) {
            throw new IllegalArgumentException("Audio file sample rate (" + this.audioDecoder.getSampleRate() + ") is different than the configured: " + sampleRate);
        }
        if (this.audioDecoder.isStereo() != isStereo) {
            throw new IllegalArgumentException("Audio file isStereo (" + this.audioDecoder.isStereo() + ") is different than the configured: " + isStereo);
        }
        return true;
    }

    @Override
    public void start(@NotNull GetMicrophoneData getMicrophoneData2) {
        Intrinsics.checkNotNullParameter((Object)getMicrophoneData2, (String)"getMicrophoneData");
        this.setGetMicrophoneData(getMicrophoneData2);
        this.audioDecoder.prepareAudio();
        this.audioDecoder.start();
        this.running = true;
        if (this.playingAudio) {
            this.stopAudioDevice();
            this.playAudioDevice();
        }
    }

    @Override
    public void stop() {
        this.running = false;
        this.audioDecoder.stop();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void release() {
        if (this.running) {
            this.stop();
        }
    }

    @Override
    public int getMaxInputSize() {
        return this.audioDecoder.getSize();
    }

    @Override
    public void setMaxInputSize(int size) {
    }

    public final void mute() {
        this.audioDecoder.mute();
    }

    public final void unMute() {
        this.audioDecoder.unMute();
    }

    public final boolean isMuted() {
        return this.audioDecoder.isMuted();
    }

    public final void moveTo(double time) {
        this.audioDecoder.moveTo(time);
    }

    public final double getDuration() {
        return this.audioDecoder.getDuration();
    }

    public final double getTime() {
        return this.audioDecoder.getTime();
    }

    public final void setLoopMode(boolean enabled) {
        this.audioDecoder.setLoopMode(enabled);
    }

    public final void replaceFile(@NotNull Context context, @NotNull Uri uri) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        int sampleRate = this.audioDecoder.getSampleRate();
        boolean isStereo = this.audioDecoder.isStereo();
        boolean wasRunning = this.audioDecoder.isRunning();
        AudioDecoder audioDecoder = new AudioDecoder(this.getGetMicrophoneData(), () -> AudioFileSource.replaceFile$lambda$3(this.audioDecoderInterface), (DecoderInterface)this.decoderInterface);
        if (!audioDecoder.initExtractor(context, uri, null)) {
            throw new IOException("Extraction failed");
        }
        if (sampleRate != audioDecoder.getSampleRate()) {
            throw new IOException("SampleRate must be the same that the previous file");
        }
        if (isStereo != audioDecoder.isStereo()) {
            throw new IOException("Channels must be the same that the previous file");
        }
        this.audioDecoder.stop();
        this.audioDecoder = audioDecoder;
        if (wasRunning) {
            audioDecoder.prepareAudio();
            audioDecoder.start();
        }
    }

    public final void playAudioDevice() {
        block3: {
            this.playingAudio = true;
            if (!this.running) {
                return;
            }
            if (this.isAudioDeviceEnabled()) {
                AudioTrack audioTrack = this.audioTrackPlayer;
                if (audioTrack != null) {
                    audioTrack.stop();
                }
                this.audioTrackPlayer = null;
            }
            int channel = this.isStereo() ? 12 : 4;
            int buffSize = AudioTrack.getMinBufferSize((int)this.getSampleRate(), (int)channel, (int)2);
            AudioTrack audioTrack = this.audioTrackPlayer = new AudioTrack(3, this.getSampleRate(), channel, 2, buffSize, 1);
            if (audioTrack == null) break block3;
            audioTrack.play();
        }
    }

    public final void stopAudioDevice() {
        this.playingAudio = false;
        if (this.isAudioDeviceEnabled()) {
            AudioTrack audioTrack = this.audioTrackPlayer;
            if (audioTrack != null) {
                audioTrack.stop();
            }
            this.audioTrackPlayer = null;
        }
    }

    public final boolean isAudioDeviceEnabled() {
        AudioTrack audioTrack = this.audioTrackPlayer;
        return audioTrack != null ? audioTrack.getPlayState() == 3 : false;
    }

    private static final Unit _init_$lambda$0(boolean it) {
        return Unit.INSTANCE;
    }

    private static final Unit audioDecoderInterface$lambda$1(Function1 $onFinish) {
        $onFinish.invoke((Object)false);
        return Unit.INSTANCE;
    }

    private static final void audioDecoder$lambda$2(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void replaceFile$lambda$3(Function0 $tmp0) {
        $tmp0.invoke();
    }

    public static final /* synthetic */ AudioTrack access$getAudioTrackPlayer$p(AudioFileSource $this) {
        return $this.audioTrackPlayer;
    }
}

