/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util.streamclient;

import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.rtmp.rtmp.RtmpClient;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001b\u0010\f\u001a\u00020\t2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u0016J\u001c\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0016H\u0016J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010%\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0016H\u0016J\b\u0010(\u001a\u00020\tH\u0016J\b\u0010)\u001a\u00020\u0016H\u0016J\b\u0010*\u001a\u00020\u0016H\u0016J\b\u0010+\u001a\u00020\u0019H\u0016J\b\u0010,\u001a\u00020\u0019H\u0016J\b\u0010-\u001a\u00020\u0019H\u0016J\b\u0010.\u001a\u00020\u0019H\u0016J\b\u0010/\u001a\u00020\tH\u0016J\b\u00100\u001a\u00020\tH\u0016J\b\u00101\u001a\u00020\tH\u0016J\b\u00102\u001a\u00020\tH\u0016J\u0010\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\u0013H\u0016J\u0010\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\u0013H\u0016J\u0010\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020#H\u0016J\b\u00109\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/pedro/library/util/streamclient/RtmpStreamClient;", "Lcom/pedro/library/util/streamclient/StreamBaseClient;", "rtmpClient", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "streamClientListener", "Lcom/pedro/library/util/streamclient/StreamClientListener;", "<init>", "(Lcom/pedro/rtmp/rtmp/RtmpClient;Lcom/pedro/library/util/streamclient/StreamClientListener;)V", "setFlashVersion", "", "flashVersion", "", "addCertificates", "certificates", "", "Ljavax/net/ssl/TrustManager;", "([Ljavax/net/ssl/TrustManager;)V", "forceIncrementalTs", "enabled", "", "setWriteChunkSize", "chunkSize", "", "reTry", "delay", "", "reason", "backupUrl", "setAuthorization", "user", "password", "setReTries", "reTries", "hasCongestion", "percentUsed", "", "setLogs", "setCheckServerAlive", "resizeCache", "newSize", "clearCache", "getCacheSize", "getItemsInCache", "getSentAudioFrames", "getSentVideoFrames", "getDroppedAudioFrames", "getDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "setOnlyAudio", "onlyAudio", "setOnlyVideo", "onlyVideo", "setBitrateExponentialFactor", "factor", "getBitrateExponentialFactor", "library_release"})
public final class RtmpStreamClient
extends StreamBaseClient {
    @NotNull
    private final RtmpClient rtmpClient;
    @Nullable
    private final StreamClientListener streamClientListener;

    public RtmpStreamClient(@NotNull RtmpClient rtmpClient, @Nullable StreamClientListener streamClientListener2) {
        Intrinsics.checkNotNullParameter((Object)rtmpClient, (String)"rtmpClient");
        this.rtmpClient = rtmpClient;
        this.streamClientListener = streamClientListener2;
    }

    public final void setFlashVersion(@NotNull String flashVersion) {
        Intrinsics.checkNotNullParameter((Object)flashVersion, (String)"flashVersion");
        this.rtmpClient.setFlashVersion(flashVersion);
    }

    public final void addCertificates(@Nullable TrustManager[] certificates) {
        this.rtmpClient.addCertificates(certificates);
    }

    public final void forceIncrementalTs(boolean enabled) {
        this.rtmpClient.forceIncrementalTs(enabled);
    }

    public final void setWriteChunkSize(int chunkSize) {
        this.rtmpClient.setWriteChunkSize(chunkSize);
    }

    @Override
    public boolean reTry(long delay, @NotNull String reason, @Nullable String backupUrl) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        boolean result = this.rtmpClient.shouldRetry(reason);
        if (result) {
            StreamClientListener streamClientListener2 = this.streamClientListener;
            if (streamClientListener2 != null) {
                streamClientListener2.onRequestKeyframe();
            }
            this.rtmpClient.reConnect(delay, backupUrl);
        }
        return result;
    }

    @Override
    public void setAuthorization(@Nullable String user, @Nullable String password) {
        this.rtmpClient.setAuthorization(user, password);
    }

    @Override
    public void setReTries(int reTries) {
        this.rtmpClient.setReTries(reTries);
    }

    @Override
    public boolean hasCongestion(float percentUsed) {
        return this.rtmpClient.hasCongestion(percentUsed);
    }

    @Override
    public void setLogs(boolean enabled) {
        this.rtmpClient.setLogs(enabled);
    }

    @Override
    public void setCheckServerAlive(boolean enabled) {
        this.rtmpClient.setCheckServerAlive(enabled);
    }

    @Override
    public void resizeCache(int newSize) {
        this.rtmpClient.resizeCache(newSize);
    }

    @Override
    public void clearCache() {
        this.rtmpClient.clearCache();
    }

    @Override
    public int getCacheSize() {
        return this.rtmpClient.getCacheSize();
    }

    @Override
    public int getItemsInCache() {
        return this.rtmpClient.getItemsInCache();
    }

    @Override
    public long getSentAudioFrames() {
        return this.rtmpClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.rtmpClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.rtmpClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.rtmpClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.rtmpClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.rtmpClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.rtmpClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.rtmpClient.resetDroppedVideoFrames();
    }

    @Override
    public void setOnlyAudio(boolean onlyAudio) {
        this.rtmpClient.setOnlyAudio(onlyAudio);
    }

    @Override
    public void setOnlyVideo(boolean onlyVideo) {
        this.rtmpClient.setOnlyVideo(onlyVideo);
    }

    @Override
    public void setBitrateExponentialFactor(float factor) {
        this.rtmpClient.setBitrateExponentialFactor(factor);
    }

    @Override
    public float getBitrateExponentialFactor() {
        return this.rtmpClient.getBitrateExponentialFactor();
    }
}

