/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util.sources.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.library.util.sources.MediaProjectionHandler;
import com.pedro.library.util.sources.MediaProjectionInstance;
import com.pedro.library.util.sources.video.VideoSource;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0016\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/pedro/library/util/sources/video/ScreenSource;", "Lcom/pedro/library/util/sources/video/VideoSource;", "context", "Landroid/content/Context;", "mediaProjection", "Landroid/media/projection/MediaProjection;", "mediaProjectionCallback", "Landroid/media/projection/MediaProjection$Callback;", "virtualDisplayCallback", "Landroid/hardware/display/VirtualDisplay$Callback;", "<init>", "(Landroid/content/Context;Landroid/media/projection/MediaProjection;Landroid/media/projection/MediaProjection$Callback;Landroid/hardware/display/VirtualDisplay$Callback;)V", "virtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "handlerThread", "Landroid/os/HandlerThread;", "dpi", "", "mediaProjectionHandler", "Lcom/pedro/library/util/sources/MediaProjectionHandler;", "create", "", "width", "height", "fps", "rotation", "start", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "stop", "release", "isRunning", "checkResolutionSupported", "resize", "library_release"})
@RequiresApi(value=21)
public final class ScreenSource
extends VideoSource {
    @Nullable
    private VirtualDisplay virtualDisplay;
    @NotNull
    private final HandlerThread handlerThread;
    @NotNull
    private final MediaProjection.Callback mediaProjectionCallback;
    @NotNull
    private final VirtualDisplay.Callback virtualDisplayCallback;
    private final int dpi;
    @NotNull
    private final MediaProjectionHandler mediaProjectionHandler;

    @JvmOverloads
    public ScreenSource(@NotNull Context context, @NotNull MediaProjection mediaProjection, @Nullable MediaProjection.Callback mediaProjectionCallback2, @Nullable VirtualDisplay.Callback virtualDisplayCallback2) {
        VirtualDisplay.Callback callback;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        this.handlerThread = new HandlerThread("ScreenSource");
        MediaProjection.Callback callback2 = mediaProjectionCallback2;
        if (callback2 == null) {
            callback2 = this.mediaProjectionCallback = (MediaProjection.Callback)new MediaProjection.Callback(){};
        }
        if ((callback = virtualDisplayCallback2) == null) {
            callback = new VirtualDisplay.Callback(){};
        }
        this.virtualDisplayCallback = callback;
        this.dpi = context.getResources().getDisplayMetrics().densityDpi;
        this.mediaProjectionHandler = MediaProjectionInstance.INSTANCE.getMediaProjectionHandler();
        this.mediaProjectionHandler.setMediaProjection(mediaProjection);
    }

    public /* synthetic */ ScreenSource(Context context, MediaProjection mediaProjection, MediaProjection.Callback callback, VirtualDisplay.Callback callback2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            callback = null;
        }
        if ((n & 8) != 0) {
            callback2 = null;
        }
        this(context, mediaProjection, callback, callback2);
    }

    @Override
    protected boolean create(int width, int height, int fps, int rotation) {
        return this.checkResolutionSupported(width, height);
    }

    @Override
    public void start(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.setSurfaceTexture(surfaceTexture);
        if (!this.isRunning()) {
            int displayHeight;
            int flags = 16;
            boolean shouldRotate = this.getRotation() == 90 || this.getRotation() == 270;
            int displayWidth = shouldRotate ? this.getHeight() : this.getWidth();
            int n = displayHeight = shouldRotate ? this.getWidth() : this.getHeight();
            if (shouldRotate) {
                surfaceTexture.setDefaultBufferSize(this.getHeight(), this.getWidth());
            }
            this.handlerThread.start();
            this.mediaProjectionHandler.registerCallback(this.mediaProjectionCallback, new Handler(this.handlerThread.getLooper()));
            this.virtualDisplay = this.mediaProjectionHandler.createVirtualDisplay("ScreenSource", displayWidth, displayHeight, this.dpi, flags, new Surface(surfaceTexture), this.virtualDisplayCallback, new Handler(this.handlerThread.getLooper()));
            if (this.virtualDisplay == null) {
                throw new IllegalArgumentException("Failed to create internal virtual display");
            }
            this.mediaProjectionHandler.start();
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            VirtualDisplay virtualDisplay = this.virtualDisplay;
            if (virtualDisplay != null) {
                virtualDisplay.release();
            }
            this.virtualDisplay = null;
            this.handlerThread.quitSafely();
        }
    }

    @Override
    public void release() {
        this.mediaProjectionHandler.unregisterCallback(this.mediaProjectionCallback);
        this.mediaProjectionHandler.stop();
    }

    @Override
    public boolean isRunning() {
        return this.virtualDisplay != null;
    }

    private final boolean checkResolutionSupported(int width, int height) {
        if (width % 2 != 0 || height % 2 != 0) {
            throw new IllegalArgumentException("width and height values must be divisible by 2");
        }
        return true;
    }

    public final void resize(int width, int height) {
        block0: {
            VirtualDisplay virtualDisplay = this.virtualDisplay;
            if (virtualDisplay == null) break block0;
            virtualDisplay.resize(width, height, this.dpi);
        }
    }

    @JvmOverloads
    public ScreenSource(@NotNull Context context, @NotNull MediaProjection mediaProjection, @Nullable MediaProjection.Callback mediaProjectionCallback2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        this(context, mediaProjection, mediaProjectionCallback2, null, 8, null);
    }

    @JvmOverloads
    public ScreenSource(@NotNull Context context, @NotNull MediaProjection mediaProjection) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        this(context, mediaProjection, null, null, 12, null);
    }
}

