/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.EncoderErrorCallback;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.audio.MicrophoneManagerManual;
import com.pedro.encoder.input.audio.MicrophoneMode;
import com.pedro.encoder.input.video.Camera1ApiManager;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.input.video.GetCameraData;
import com.pedro.encoder.input.video.facedetector.FaceDetectorCallback;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.AndroidMuxerRecordController;
import com.pedro.library.util.FpsListener;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.GlStreamInterface;
import com.pedro.library.view.OpenGlView;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class Camera1Base {
    private static final String TAG = "Camera1Base";
    private final Context context;
    private final Camera1ApiManager cameraManager;
    protected VideoEncoder videoEncoder;
    private MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private GlInterface glInterface;
    private boolean streaming = false;
    protected boolean audioInitialized = false;
    private boolean onPreview = false;
    protected BaseRecordController recordController;
    private int previewWidth;
    private int previewHeight;
    private final FpsListener fpsListener = new FpsListener();
    private final GetCameraData getCameraData = frame -> this.videoEncoder.inputYUVData(frame);
    private final GetMicrophoneData getMicrophoneData = frame -> this.audioEncoder.inputPCMData(frame);
    private final GetAacData getAacData = new GetAacData(){

        public void getAacData(@NonNull ByteBuffer aacBuffer, @NonNull MediaCodec.BufferInfo info) {
            if (Build.VERSION.SDK_INT >= 18) {
                Camera1Base.this.recordController.recordAudio(aacBuffer, info);
            }
            if (Camera1Base.this.streaming) {
                Camera1Base.this.getAacDataRtp(aacBuffer, info);
            }
        }

        public void onAudioFormat(@NonNull MediaFormat mediaFormat) {
            Camera1Base.this.recordController.setAudioFormat(mediaFormat);
        }
    };
    private final GetVideoData getVideoData = new GetVideoData(){

        public void onSpsPpsVps(@NonNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
            Camera1Base.this.onSpsPpsVpsRtp(sps.duplicate(), pps != null ? pps.duplicate() : null, vps != null ? vps.duplicate() : null);
        }

        public void getVideoData(@NonNull ByteBuffer h264Buffer, @NonNull MediaCodec.BufferInfo info) {
            Camera1Base.this.fpsListener.calculateFps();
            if (Build.VERSION.SDK_INT >= 18) {
                Camera1Base.this.recordController.recordVideo(h264Buffer, info);
            }
            if (Camera1Base.this.streaming) {
                Camera1Base.this.getH264DataRtp(h264Buffer, info);
            }
        }

        public void onVideoFormat(@NonNull MediaFormat mediaFormat) {
            Camera1Base.this.recordController.setVideoFormat(mediaFormat, !Camera1Base.this.audioInitialized);
        }
    };

    public Camera1Base(SurfaceView surfaceView) {
        this.context = surfaceView.getContext();
        this.cameraManager = new Camera1ApiManager(surfaceView, this.getCameraData);
        this.init();
    }

    public Camera1Base(TextureView textureView) {
        this.context = textureView.getContext();
        this.cameraManager = new Camera1ApiManager(textureView, this.getCameraData);
        this.init();
    }

    @RequiresApi(api=18)
    public Camera1Base(OpenGlView openGlView) {
        this.context = openGlView.getContext();
        this.glInterface = openGlView;
        this.cameraManager = new Camera1ApiManager(null, this.context);
        this.init();
    }

    @RequiresApi(api=18)
    public Camera1Base(Context context) {
        this.context = context;
        this.glInterface = new GlStreamInterface(context);
        this.cameraManager = new Camera1ApiManager(null, context);
        this.init();
    }

    private void init() {
        this.videoEncoder = new VideoEncoder(this.getVideoData);
        this.setMicrophoneMode(MicrophoneMode.ASYNC);
        this.recordController = new AndroidMuxerRecordController();
    }

    public void setMicrophoneMode(MicrophoneMode microphoneMode) {
        switch (microphoneMode) {
            case SYNC: {
                this.microphoneManager = new MicrophoneManagerManual();
                this.audioEncoder = new AudioEncoder(this.getAacData);
                this.audioEncoder.setGetFrame(((MicrophoneManagerManual)this.microphoneManager).getGetFrame());
                this.audioEncoder.setTsModeBuffer(false);
                break;
            }
            case ASYNC: {
                this.microphoneManager = new MicrophoneManager(this.getMicrophoneData);
                this.audioEncoder = new AudioEncoder(this.getAacData);
                this.audioEncoder.setTsModeBuffer(false);
                break;
            }
            case BUFFER: {
                this.microphoneManager = new MicrophoneManager(this.getMicrophoneData);
                this.audioEncoder = new AudioEncoder(this.getAacData);
                this.audioEncoder.setTsModeBuffer(true);
            }
        }
    }

    public void setCameraCallbacks(CameraCallbacks callbacks) {
        this.cameraManager.setCameraCallbacks(callbacks);
    }

    public void setEncoderErrorCallback(EncoderErrorCallback encoderErrorCallback) {
        this.videoEncoder.setEncoderErrorCallback(encoderErrorCallback);
        this.audioEncoder.setEncoderErrorCallback(encoderErrorCallback);
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.microphoneManager.setCustomAudioEffect(customAudioEffect);
    }

    public void setFpsListener(FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public boolean enableFaceDetection(FaceDetectorCallback faceDetectorCallback) {
        return this.cameraManager.enableFaceDetection(faceDetectorCallback);
    }

    public void disableFaceDetection() {
        this.cameraManager.disableFaceDetection();
    }

    public boolean isFaceDetectionEnabled() {
        return this.cameraManager.isFaceDetectionEnabled();
    }

    public boolean enableVideoStabilization() {
        return this.cameraManager.enableVideoStabilization();
    }

    public void disableVideoStabilization() {
        this.cameraManager.disableVideoStabilization();
    }

    public boolean isVideoStabilizationEnabled() {
        return this.cameraManager.isVideoStabilizationEnabled();
    }

    @Deprecated
    public boolean isFrontCamera() {
        return this.cameraManager.getCameraFacing() == CameraHelper.Facing.FRONT;
    }

    public CameraHelper.Facing getCameraFacing() {
        return this.cameraManager.getCameraFacing();
    }

    public void enableLantern() throws Exception {
        this.cameraManager.enableLantern();
    }

    public void disableLantern() {
        this.cameraManager.disableLantern();
    }

    public boolean isLanternEnabled() {
        return this.cameraManager.isLanternEnabled();
    }

    public void enableAutoFocus() {
        this.cameraManager.enableAutoFocus();
    }

    public void disableAutoFocus() {
        this.cameraManager.disableAutoFocus();
    }

    public boolean isAutoFocusEnabled() {
        return this.cameraManager.isAutoFocusEnabled();
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation, int profile, int level) {
        if (this.onPreview && width != this.previewWidth || height != this.previewHeight || fps != this.videoEncoder.getFps() || rotation != this.videoEncoder.getRotation()) {
            this.stopPreview();
        }
        FormatVideoEncoder formatVideoEncoder = this.glInterface == null ? FormatVideoEncoder.YUV420Dynamical : FormatVideoEncoder.SURFACE;
        return this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, iFrameInterval, formatVideoEncoder, profile, level);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, iFrameInterval, rotation, -1, -1);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, 2, rotation);
    }

    public boolean prepareVideo(int width, int height, int bitrate) {
        int rotation = CameraHelper.getCameraOrientation((Context)this.context);
        return this.prepareVideo(width, height, 30, bitrate, 2, rotation);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int audioSource, int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        if (!this.microphoneManager.createMicrophone(audioSource, sampleRate, isStereo, echoCanceler, noiseSuppressor)) {
            return false;
        }
        this.prepareAudioRtp(isStereo, sampleRate);
        this.audioInitialized = this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo, this.microphoneManager.getMaxInputSize());
        return this.audioInitialized;
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        return this.prepareAudio(0, bitrate, sampleRate, isStereo, echoCanceler, noiseSuppressor);
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo) {
        return this.prepareAudio(bitrate, sampleRate, isStereo, false, false);
    }

    public boolean prepareVideo() {
        int rotation = CameraHelper.getCameraOrientation((Context)this.context);
        return this.prepareVideo(640, 480, 30, 1228800, rotation);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    public void forceCodecType(CodecUtil.CodecType codecTypeVideo, CodecUtil.CodecType codecTypeAudio) {
        this.videoEncoder.forceCodecType(codecTypeVideo);
        this.audioEncoder.forceCodecType(codecTypeAudio);
    }

    @RequiresApi(api=18)
    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=18)
    public void startRecord(@NonNull String path) throws IOException {
        this.startRecord(path, null);
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(fd, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd) throws IOException {
        this.startRecord(fd, null);
    }

    @RequiresApi(api=18)
    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    @RequiresApi(api=18)
    public void replaceView(Context context) {
        if (Build.VERSION.SDK_INT >= 18) {
            this.replaceGlInterface(new GlStreamInterface(context));
        }
    }

    @RequiresApi(api=18)
    public void replaceView(OpenGlView openGlView) {
        this.replaceGlInterface(openGlView);
    }

    @RequiresApi(api=18)
    private void replaceGlInterface(GlInterface glInterface) {
        if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
            if (this.isStreaming() || this.isRecording() || this.isOnPreview()) {
                Point size = this.glInterface.getEncoderSize();
                this.cameraManager.stop();
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
                this.glInterface = glInterface;
                int w = size.x;
                int h = size.y;
                int rotation = this.videoEncoder.getRotation();
                if (rotation == 90 || rotation == 270) {
                    h = size.x;
                    w = size.y;
                }
                this.prepareGlView(w, h, rotation);
                this.cameraManager.setRotation(rotation);
                this.cameraManager.start(this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoder.getFps());
            } else {
                this.glInterface = glInterface;
            }
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height, int fps, int rotation) {
        if (!this.onPreview) {
            if (Build.VERSION.SDK_INT >= 18 && this.glInterface instanceof GlStreamInterface) {
                this.cameraManager.setCameraFacing(cameraFacing);
                return;
            }
            this.previewWidth = width;
            this.previewHeight = height;
            this.videoEncoder.setFps(fps);
            this.videoEncoder.setRotation(rotation);
            this.prepareGlView(width, height, rotation);
            this.cameraManager.setRotation(rotation);
            this.cameraManager.start(cameraFacing, width, height, this.videoEncoder.getFps());
            this.onPreview = true;
        } else {
            Log.e((String)TAG, (String)"Streaming or preview started, ignored");
        }
    }

    public void startPreview(int cameraId, int width, int height, int fps, int rotation) {
        if (!this.isStreaming() && !this.onPreview) {
            if (Build.VERSION.SDK_INT >= 18 && this.glInterface instanceof GlStreamInterface) {
                this.cameraManager.setCameraSelect(cameraId);
                return;
            }
            this.previewWidth = width;
            this.previewHeight = height;
            this.videoEncoder.setFps(fps);
            this.videoEncoder.setRotation(rotation);
            this.prepareGlView(width, height, rotation);
            this.cameraManager.setRotation(rotation);
            this.cameraManager.start(cameraId, width, height, this.videoEncoder.getFps());
            this.onPreview = true;
        } else {
            Log.e((String)TAG, (String)"Streaming or preview started, ignored");
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height, int rotation) {
        this.startPreview(cameraFacing, width, height, this.videoEncoder.getFps(), rotation);
    }

    public void startPreview(int cameraFacing, int width, int height, int rotation) {
        this.startPreview(cameraFacing, width, height, this.videoEncoder.getFps(), rotation);
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height) {
        this.startPreview(cameraFacing, width, height, CameraHelper.getCameraOrientation((Context)this.context));
    }

    public void startPreview(int cameraFacing, int width, int height) {
        this.startPreview(cameraFacing, width, height, CameraHelper.getCameraOrientation((Context)this.context));
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int rotation) {
        this.startPreview(cameraFacing, this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), rotation);
    }

    public void startPreview(CameraHelper.Facing cameraFacing) {
        this.startPreview(cameraFacing, this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
    }

    public void startPreview(int cameraFacing) {
        this.startPreview(cameraFacing, this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
    }

    public void startPreview(int width, int height) {
        this.startPreview(this.getCameraFacing(), width, height);
    }

    public void startPreview() {
        this.startPreview(this.getCameraFacing());
    }

    public void stopPreview() {
        if (!this.isStreaming() && !this.isRecording()) {
            this.stopCamera();
        } else {
            Log.e((String)TAG, (String)"Streaming or preview stopped, ignored");
        }
    }

    public void stopCamera() {
        if (this.onPreview) {
            if (Build.VERSION.SDK_INT >= 18 && this.glInterface instanceof GlStreamInterface) {
                return;
            }
            if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                this.glInterface.stop();
            }
            this.cameraManager.stop();
            this.onPreview = false;
            this.previewWidth = 0;
            this.previewHeight = 0;
        } else {
            Log.e((String)TAG, (String)"Preview stopped, ignored");
        }
    }

    public void setPreviewOrientation(int orientation) {
        this.cameraManager.setPreviewOrientation(orientation);
    }

    public void setZoom(MotionEvent event) {
        this.cameraManager.setZoom(event);
    }

    public void setZoom(int level) {
        this.cameraManager.setZoom(level);
    }

    public float getZoom() {
        return this.cameraManager.getZoom();
    }

    public int getMaxZoom() {
        return this.cameraManager.getMaxZoom();
    }

    public int getMinZoom() {
        return this.cameraManager.getMinZoom();
    }

    @RequiresApi(api=18)
    public void startStreamAndRecord(String url, String path, RecordController.Listener listener) throws IOException {
        this.startStream(url);
        this.recordController.startRecord(path, listener);
    }

    @RequiresApi(api=18)
    public void startStreamAndRecord(String url, String path) throws IOException {
        this.startStreamAndRecord(url, path, null);
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        } else {
            this.requestKeyFrame();
        }
        this.startStreamRtp(url);
        this.onPreview = true;
    }

    private void startEncoders() {
        long startTs = System.nanoTime() / 1000L;
        this.videoEncoder.start(startTs);
        if (this.audioInitialized) {
            this.audioEncoder.start(startTs);
        }
        this.prepareGlView(this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoder.getRotation());
        if (this.audioInitialized) {
            this.microphoneManager.start();
        }
        this.cameraManager.setRotation(this.videoEncoder.getRotation());
        if (!this.cameraManager.isRunning()) {
            this.cameraManager.start(this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoder.getFps());
        }
        this.onPreview = true;
    }

    public void requestKeyFrame() {
        if (this.videoEncoder.isRunning()) {
            if (Build.VERSION.SDK_INT >= 19) {
                this.videoEncoder.requestKeyframe();
            } else {
                if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                    this.glInterface.removeMediaCodecSurface();
                }
                this.videoEncoder.reset();
                if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                    this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
                }
            }
        }
    }

    private void prepareGlView(int width, int height, int rotation) {
        if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
            int w = width;
            int h = height;
            boolean isPortrait = false;
            if (rotation == 90 || rotation == 270) {
                h = width;
                w = height;
                isPortrait = true;
            }
            this.glInterface.setEncoderSize(w, h);
            GlInterface glInterface = this.glInterface;
            if (glInterface instanceof GlStreamInterface) {
                GlStreamInterface glStreamInterface = (GlStreamInterface)glInterface;
                glStreamInterface.setPreviewResolution(w, h);
                glStreamInterface.setIsPortrait(isPortrait);
            }
            this.glInterface.setRotation(0);
            if (!this.glInterface.isRunning()) {
                this.glInterface.start();
            }
            if (this.videoEncoder.getInputSurface() != null && this.videoEncoder.isRunning()) {
                this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            }
            this.cameraManager.setSurfaceTexture(this.glInterface.getSurfaceTexture());
        }
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recordController.isRecording()) {
            if (this.audioInitialized) {
                this.microphoneManager.stop();
            }
            if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                this.glInterface.removeMediaCodecSurface();
                if (this.glInterface instanceof GlStreamInterface) {
                    this.glInterface.stop();
                    this.cameraManager.stop();
                    this.onPreview = false;
                }
            }
            this.videoEncoder.stop();
            if (this.audioInitialized) {
                this.audioEncoder.stop();
            }
            this.recordController.resetFormats();
        }
    }

    public List<Camera.Size> getResolutionsBack() {
        return this.cameraManager.getPreviewSizeBack();
    }

    public List<Camera.Size> getResolutionsFront() {
        return this.cameraManager.getPreviewSizeFront();
    }

    public List<int[]> getSupportedFps() {
        return this.cameraManager.getSupportedFps();
    }

    public void setAudioMaxInputSize(int size) {
        this.microphoneManager.setMaxInputSize(size);
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    public void switchCamera() throws CameraOpenException {
        if (this.isStreaming() || this.isRecording() || this.onPreview) {
            this.cameraManager.switchCamera();
        } else {
            this.cameraManager.setCameraFacing(this.getCameraFacing() == CameraHelper.Facing.FRONT ? CameraHelper.Facing.BACK : CameraHelper.Facing.FRONT);
        }
    }

    public void switchCamera(int cameraId) throws CameraOpenException {
        if (this.isStreaming() || this.onPreview) {
            this.cameraManager.switchCamera(cameraId);
        } else {
            this.cameraManager.setCameraSelect(cameraId);
        }
    }

    public void setExposure(int value) {
        this.cameraManager.setExposure(value);
    }

    public int getExposure() {
        return this.cameraManager.getExposure();
    }

    public int getMaxExposure() {
        return this.cameraManager.getMaxExposure();
    }

    public int getMinExposure() {
        return this.cameraManager.getMinExposure();
    }

    public void tapToFocus(View view, MotionEvent event) {
        this.cameraManager.tapToFocus(view, event);
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    @RequiresApi(api=19)
    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void forceFpsLimit(boolean enabled) {
        int fps = enabled ? this.videoEncoder.getFps() : 0;
        this.videoEncoder.setForceFps(fps);
        if (this.glInterface != null) {
            this.glInterface.forceFpsLimit(fps);
        }
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isOnPreview() {
        return this.onPreview;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void setRecordController(BaseRecordController recordController) {
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }

    public abstract StreamBaseClient getStreamClient();

    public void setVideoCodec(VideoCodec codec) {
        this.setVideoCodecImp(codec);
        this.recordController.setVideoCodec(codec);
        String type = switch (codec) {
            default -> throw new IncompatibleClassChangeError();
            case VideoCodec.H264 -> "video/avc";
            case VideoCodec.H265 -> "video/hevc";
            case VideoCodec.AV1 -> "video/av01";
        };
        this.videoEncoder.setType(type);
    }

    public void setAudioCodec(AudioCodec codec) {
        this.setAudioCodecImp(codec);
        this.recordController.setAudioCodec(codec);
        String type = switch (codec) {
            default -> throw new IncompatibleClassChangeError();
            case AudioCodec.G711 -> "audio/g711-alaw";
            case AudioCodec.AAC -> "audio/mp4a-latm";
            case AudioCodec.OPUS -> "audio/opus";
        };
        this.audioEncoder.setType(type);
    }

    protected abstract void setVideoCodecImp(VideoCodec var1);

    protected abstract void setAudioCodecImp(AudioCodec var1);
}

