/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util.streamclient;

import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.rtmp.rtmp.RtmpClient;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\bH\u0016J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010!\u001a\u00020\bH\u0016J\b\u0010\"\u001a\u00020\bH\u0016J\b\u0010#\u001a\u00020\bH\u0016J\b\u0010$\u001a\u00020\bH\u0016J\u0010\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0012H\u0016J\u001c\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010\u001f2\b\u0010)\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010*\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u001fJ\u0010\u0010-\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u0010H\u0016J\u0010\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\u0010H\u0016J\u0010\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\u0012H\u0016J\u000e\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/pedro/library/util/streamclient/RtmpStreamClient;", "Lcom/pedro/library/util/streamclient/StreamBaseClient;", "rtmpClient", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "streamClientListener", "Lcom/pedro/library/util/streamclient/StreamClientListener;", "(Lcom/pedro/rtmp/rtmp/RtmpClient;Lcom/pedro/library/util/streamclient/StreamClientListener;)V", "addCertificates", "", "certificates", "", "Ljavax/net/ssl/TrustManager;", "([Ljavax/net/ssl/TrustManager;)V", "clearCache", "forceIncrementalTs", "enabled", "", "getCacheSize", "", "getDroppedAudioFrames", "", "getDroppedVideoFrames", "getItemsInCache", "getSentAudioFrames", "getSentVideoFrames", "hasCongestion", "percentUsed", "", "reTry", "delay", "reason", "", "backupUrl", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "setAuthorization", "user", "password", "setCheckServerAlive", "setFlashVersion", "flashVersion", "setLogs", "setOnlyAudio", "onlyAudio", "setOnlyVideo", "onlyVideo", "setReTries", "reTries", "setWriteChunkSize", "chunkSize", "library_release"})
public final class RtmpStreamClient
extends StreamBaseClient {
    @NotNull
    private final RtmpClient rtmpClient;
    @Nullable
    private final StreamClientListener streamClientListener;

    public RtmpStreamClient(@NotNull RtmpClient rtmpClient, @Nullable StreamClientListener streamClientListener2) {
        Intrinsics.checkNotNullParameter((Object)rtmpClient, (String)"rtmpClient");
        this.rtmpClient = rtmpClient;
        this.streamClientListener = streamClientListener2;
    }

    public final void setFlashVersion(@NotNull String flashVersion) {
        Intrinsics.checkNotNullParameter((Object)flashVersion, (String)"flashVersion");
        this.rtmpClient.setFlashVersion(flashVersion);
    }

    public final void addCertificates(@Nullable TrustManager[] certificates) {
        this.rtmpClient.addCertificates(certificates);
    }

    public final void forceIncrementalTs(boolean enabled) {
        this.rtmpClient.forceIncrementalTs(enabled);
    }

    public final void setWriteChunkSize(int chunkSize) {
        this.rtmpClient.setWriteChunkSize(chunkSize);
    }

    @Override
    public boolean reTry(long delay, @NotNull String reason, @Nullable String backupUrl) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        boolean result = this.rtmpClient.shouldRetry(reason);
        if (result) {
            StreamClientListener streamClientListener2 = this.streamClientListener;
            if (streamClientListener2 != null) {
                streamClientListener2.onRequestKeyframe();
            }
            this.rtmpClient.reConnect(delay, backupUrl);
        }
        return result;
    }

    @Override
    public void setAuthorization(@Nullable String user, @Nullable String password) {
        this.rtmpClient.setAuthorization(user, password);
    }

    @Override
    public void setReTries(int reTries) {
        this.rtmpClient.setReTries(reTries);
    }

    @Override
    public boolean hasCongestion(float percentUsed) {
        return this.rtmpClient.hasCongestion(percentUsed);
    }

    @Override
    public void setLogs(boolean enabled) {
        this.rtmpClient.setLogs(enabled);
    }

    @Override
    public void setCheckServerAlive(boolean enabled) {
        this.rtmpClient.setCheckServerAlive(enabled);
    }

    @Override
    public void resizeCache(int newSize) {
        this.rtmpClient.resizeCache(newSize);
    }

    @Override
    public void clearCache() {
        this.rtmpClient.clearCache();
    }

    @Override
    public int getCacheSize() {
        return this.rtmpClient.getCacheSize();
    }

    @Override
    public int getItemsInCache() {
        return this.rtmpClient.getItemsInCache();
    }

    @Override
    public long getSentAudioFrames() {
        return this.rtmpClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.rtmpClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.rtmpClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.rtmpClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.rtmpClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.rtmpClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.rtmpClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.rtmpClient.resetDroppedVideoFrames();
    }

    @Override
    public void setOnlyAudio(boolean onlyAudio) {
        this.rtmpClient.setOnlyAudio(onlyAudio);
    }

    @Override
    public void setOnlyVideo(boolean onlyVideo) {
        this.rtmpClient.setOnlyVideo(onlyVideo);
    }
}

